/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.compiled;

import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.importer.FlexImporter;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayInputStream;

public class SwfFileStubBuilder
implements BinaryFileStubBuilder {
    private static final int VERSION = 2;

    public boolean acceptsFile(VirtualFile file) {
        return file.getFileType() == FlexApplicationComponent.SWF_FILE_TYPE && file.getPath().endsWith("!/" + file.getName());
    }

    public StubElement buildStubTree(FileContent fileContent) {
        return SwfFileStubBuilder.buildFileStub(fileContent.getFile(), fileContent.getContent());
    }

    static PsiFileStub buildFileStub(VirtualFile file, byte[] content) {
        JSFileStubImpl stub = new JSFileStubImpl((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, new JSFileCachedData());
        try {
            FlexImporter.buildStubsInterfaceFromStream(new ByteArrayInputStream(content), (StubElement)stub);
        }
        catch (Exception ex) {
            Logger.getInstance((String)SwfFileStubBuilder.class.getName()).warn(file.getPath(), (Throwable)ex);
        }
        return stub;
    }

    public int getStubVersion() {
        return JSFileElementType.getVersion() + 2;
    }
}

