/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.javascript.flex.maven.Flexmojos3GenerateConfigTask;
import com.intellij.javascript.flex.maven.Flexmojos4Configurator;
import com.intellij.javascript.flex.maven.FlexmojosImporter;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorBasicTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class Flexmojos4GenerateConfigTask
extends MavenProjectsProcessorBasicTask {
    private static final Pattern RESULT_PATTERN = Pattern.compile("^\\[fcg\\] generated: (\\d+):([^|]+)\\|(.+)\\[/fcg\\]$", 8);
    private static final String ERROR = "[ERROR]";
    private DataOutputStream out;
    private Process process;
    private MavenProgressIndicator indicator;
    private final List<MavenProject> projects = new ArrayList<MavenProject>();
    private final Map<Module, String> myModuleToConfigFilePath = new THashMap();
    private RefreshConfigFiles postTask;

    public Flexmojos4GenerateConfigTask(MavenProjectsTree tree) {
        super(null, tree);
    }

    private static String getSettingsFilePath(File settingsFile) {
        return settingsFile == null || !settingsFile.exists() ? " " : settingsFile.getAbsolutePath();
    }

    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        long start = System.currentTimeMillis();
        this.indicator = indicator;
        indicator.setText(FlexBundle.message("generating.flex.configs", new Object[0]));
        try {
            this.runGeneratorServer(MavenProjectsManager.getInstance((Project)project), project);
            this.writeProjects(project);
        }
        catch (IOException e) {
            Flexmojos4GenerateConfigTask.showWarning(project, e.getMessage());
            MavenLog.LOG.error((Throwable)e);
        }
        catch (ExecutionException e) {
            Flexmojos4GenerateConfigTask.showWarning(project, e.getMessage());
        }
        if (this.process == null) {
            return;
        }
        while (this.process != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {
                break;
            }
            if (!indicator.isCanceled()) continue;
            MavenLog.LOG.warn("Generating flex configs canceled");
            if (this.process == null) break;
            this.process.destroy();
            break;
        }
        if (this.postTask != null) {
            MavenUtil.invokeAndWait((Project)project, (Runnable)this.postTask);
            MavenUtil.invokeAndWaitWriteAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : Flexmojos4GenerateConfigTask.this.myModuleToConfigFilePath.entrySet()) {
                        VirtualFile configFile;
                        if (((Module)entry.getKey()).isDisposed() || (configFile = LocalFileSystem.getInstance().refreshAndFindFileByPath((String)entry.getValue())) == null || configFile.isDirectory()) continue;
                        Flexmojos3GenerateConfigTask.updateMainClass((Module)entry.getKey(), configFile);
                    }
                }
            });
        }
        long duration = System.currentTimeMillis() - start;
        MavenLog.LOG.info("Generating flex configs took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }

    private void writeProjects(Project project) throws IOException {
        assert (!this.projects.isEmpty());
        this.out.writeShort(this.projects.size());
        MavenProject outdatedIdeaMavenPluginHolder = null;
        for (MavenProject pendingProject : this.projects) {
            if (outdatedIdeaMavenPluginHolder == null && pendingProject.findPlugin("com.intellij.flex.maven", "idea-flexmojos-maven-plugin") != null) {
                outdatedIdeaMavenPluginHolder = pendingProject;
            }
            this.out.writeUTF(pendingProject.getFile().getPath());
        }
        this.out.flush();
        if (outdatedIdeaMavenPluginHolder != null) {
            new Notification("Maven", FlexBundle.message("flexmojos.project.import", new Object[0]), FlexBundle.message("flexmojos.maven.plugin.outdated.warning", outdatedIdeaMavenPluginHolder.getMavenId().toString()), NotificationType.WARNING).notify(project);
        }
    }

    void submit(MavenProject mavenProject, Module module, String configFilePath) {
        assert (this.out == null);
        assert (!this.projects.contains(mavenProject)) : mavenProject.getName();
        this.projects.add(mavenProject);
        this.myModuleToConfigFilePath.put(module, configFilePath);
    }

    private void runGeneratorServer(MavenProjectsManager mavenProjectsManager, Project project) throws IOException, ExecutionException, MavenProcessCanceledException {
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        MavenGeneralSettings mavenGeneralSettings = mavenProjectsManager.getGeneralSettings();
        ParametersList programParametersList = params.getProgramParametersList();
        programParametersList.add(Flexmojos4GenerateConfigTask.getSettingsFilePath(mavenGeneralSettings.getEffectiveGlobalSettingsIoFile()));
        programParametersList.add(Flexmojos4GenerateConfigTask.getSettingsFilePath(mavenGeneralSettings.getEffectiveUserSettingsIoFile()));
        programParametersList.add(mavenGeneralSettings.getEffectiveLocalRepository().getAbsolutePath());
        programParametersList.add(mavenGeneralSettings.isWorkOffline() ? "t" : "f");
        programParametersList.add(project.getBaseDir().getPath() + "/.idea/flexmojos");
        Flexmojos4GenerateConfigTask.configureMavenClassPath(mavenGeneralSettings, params.getClassPath());
        File userVmP = new File(SystemProperties.getUserHome(), "fcg-vmp");
        if (userVmP.exists()) {
            params.getVMParametersList().addParametersString(FileUtil.loadFile((File)userVmP));
        }
        params.setMainClass("com.intellij.flex.maven.GeneratorServer");
        GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)params);
        commandLine.setRedirectErrorStream(true);
        MavenLog.LOG.info("Generate Flex Configs Task:" + commandLine.getCommandLineString());
        this.indicator.checkCanceled();
        this.process = commandLine.createProcess();
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new OutputReader(project));
        this.out = new DataOutputStream(new BufferedOutputStream(this.process.getOutputStream()));
        this.writeExplicitProfiles(mavenProjectsManager.getExplicitProfiles().getEnabledProfiles());
        this.writeWorkspaceMap(this.myTree.getProjects());
        this.out.writeUTF(FlexCommonUtils.getPathToBundledJar((String)"flexmojos-idea-configurator.jar"));
        this.out.writeUTF(this.getIdeaConfiguratorClassName());
    }

    protected String getIdeaConfiguratorClassName() {
        return "com.intellij.flex.maven.IdeaConfigurator";
    }

    private void writeExplicitProfiles(Collection<String> explicitProfiles) throws IOException {
        this.out.writeShort(explicitProfiles.size());
        if (explicitProfiles.isEmpty()) {
            return;
        }
        for (String explicitProfile : explicitProfiles) {
            this.out.writeUTF(explicitProfile);
        }
    }

    private void writeWorkspaceMap(Collection<MavenProject> mavenProjects) throws IOException {
        int actualLength = 0;
        for (MavenProject mavenProject : mavenProjects) {
            if (!ArrayUtil.contains((String)mavenProject.getPackaging(), (String[])FlexmojosImporter.SUPPORTED_PACKAGINGS)) continue;
            ++actualLength;
        }
        this.out.writeShort(actualLength);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
        for (MavenProject mavenProject : mavenProjects) {
            if (!ArrayUtil.contains((String)mavenProject.getPackaging(), (String[])FlexmojosImporter.SUPPORTED_PACKAGINGS)) continue;
            MavenId mavenId = mavenProject.getMavenId();
            objectOutputStream.writeObject(mavenId.getGroupId());
            objectOutputStream.writeObject(mavenId.getArtifactId());
            objectOutputStream.writeObject(mavenId.getVersion());
            objectOutputStream.writeObject(mavenProject.getFile().getPath());
        }
        objectOutputStream.flush();
    }

    private static void configureMavenClassPath(MavenGeneralSettings mavenGeneralSettings, PathsList classPath) throws ExecutionException {
        String mavenHome = MavenExternalParameters.resolveMavenHome((MavenGeneralSettings)mavenGeneralSettings);
        String version = MavenUtil.getMavenVersion((String)mavenHome);
        String pathToBundledJar = FlexCommonUtils.getPathToBundledJar((String)(StringUtil.compareVersionNumbers((String)version, (String)"3.1") >= 0 ? "flexmojos-flex-configs-generator-server-31.jar" : "flexmojos-flex-configs-generator-server.jar"));
        MavenLog.LOG.info("Generating flex configs pathToBundledJar: " + pathToBundledJar);
        MavenLog.LOG.assertTrue(!StringUtil.isEmpty((String)pathToBundledJar));
        classPath.add(pathToBundledJar);
        String libDirPath = mavenHome + "/lib";
        for (String s : new File(libDirPath).list()) {
            if (!s.endsWith(".jar") || s.startsWith("maven-embedder-") || s.startsWith("commons-cli-") || s.startsWith("nekohtml-")) continue;
            classPath.add(libDirPath + File.separator + s);
        }
        String libBootDirPath = mavenHome + "/boot";
        for (String s : new File(libBootDirPath).list()) {
            if (!s.endsWith(".jar")) continue;
            classPath.add(libBootDirPath + File.separator + s);
        }
    }

    private static void showWarning(Project project, String text) {
        new Notification("Maven", FlexBundle.message("flexmojos.project.import", new Object[0]), FlexBundle.message("flexmojos4.warning", text), NotificationType.WARNING).notify(project);
    }

    private static void showWarningWithDetails(final Project project, final String details) {
        NotificationListener.Adapter listener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/flex/maven/Flexmojos4GenerateConfigTask$2", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/flex/maven/Flexmojos4GenerateConfigTask$2", "hyperlinkActivated"));
                }
                Messages.showErrorDialog((Project)project, (String)FlexBundle.message("flexmojos4.details.start", details), (String)FlexBundle.message("flexmojos.project.import", new Object[0]));
                notification.expire();
            }
        };
        new Notification("Maven", FlexBundle.message("flexmojos.project.import", new Object[0]), FlexBundle.message("flexmojos4.warning.with.link", new Object[0]), NotificationType.WARNING, (NotificationListener)listener).notify(project);
    }

    private static final class RefreshConfigFiles
    implements Runnable {
        private final List<String> filesForRefresh;
        private final THashMap<MavenProject, List<String>> sourceRoots;
        private final Project project;

        public RefreshConfigFiles(List<String> filesForRefresh, THashMap<MavenProject, List<String>> sourceRoots, Project project) {
            this.filesForRefresh = filesForRefresh;
            this.sourceRoots = sourceRoots;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AccessToken token = WriteAction.start();
            try {
                VirtualFile p = LocalFileSystem.getInstance().refreshAndFindFileByPath(Flexmojos4Configurator.getCompilerConfigsDir(this.project));
                if (p == null) {
                    return;
                }
                p.refresh(false, true);
                ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>(this.filesForRefresh.size());
                for (String path : this.filesForRefresh) {
                    VirtualFile file = p.findChild(path);
                    if (file == null) continue;
                    virtualFiles.add(file);
                }
                LocalFileSystem.getInstance().refreshFiles(virtualFiles);
                final MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.project);
                this.sourceRoots.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<MavenProject, List<String>>(){

                    public boolean execute(MavenProject mavenProject, List<String> sourceRoots) {
                        Module module = mavenProjectsManager.findModule(mavenProject);
                        if (module == null) {
                            return true;
                        }
                        IdeModifiableModelsProviderImpl provider = new IdeModifiableModelsProviderImpl(project);
                        MavenRootModelAdapter a = new MavenRootModelAdapter(mavenProject, module, (IdeModifiableModelsProvider)provider);
                        for (String sourceRoot : sourceRoots) {
                            a.addSourceFolder(sourceRoot, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
                        }
                        provider.commit();
                        return true;
                    }
                });
            }
            finally {
                token.finish();
            }
        }
    }

    private final class OutputReader
    implements Runnable {
        private final Project project;

        public OutputReader(Project project) {
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
            int exitCode = -1;
            InputStreamReader reader = new InputStreamReader(Flexmojos4GenerateConfigTask.this.process.getInputStream());
            ArrayList<String> filesForRefresh = new ArrayList<String>(Flexmojos4GenerateConfigTask.this.projects.size());
            THashMap sourceRoots = new THashMap(Flexmojos4GenerateConfigTask.this.projects.size());
            try {
                int read;
                char[] buf = new char[8196];
                Matcher matcher = RESULT_PATTERN.matcher(stringBuilder);
                int startForResultParse = 0;
                while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                    stringBuilder.append(buf, 0, read);
                    if (Flexmojos4GenerateConfigTask.this.indicator.isCanceled()) {
                        Flexmojos4GenerateConfigTask.this.process.destroy();
                    }
                    while (matcher.find(startForResultParse)) {
                        MavenProject mavenProject = (MavenProject)Flexmojos4GenerateConfigTask.this.projects.get(Integer.parseInt(matcher.group(1)));
                        Flexmojos4GenerateConfigTask.this.indicator.setText2(mavenProject.getDisplayName());
                        filesForRefresh.add(matcher.group(2));
                        StringTokenizer tokenizer = new StringTokenizer(matcher.group(3), "|");
                        ArrayList<String> moduleSourcesRoots = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens()) {
                            moduleSourcesRoots.add(tokenizer.nextToken());
                        }
                        sourceRoots.put((Object)mavenProject, moduleSourcesRoots);
                        startForResultParse = matcher.end();
                    }
                }
                try {
                    Flexmojos4GenerateConfigTask.this.process.waitFor();
                }
                catch (InterruptedException mavenProject) {
                    // empty catch block
                }
                exitCode = Flexmojos4GenerateConfigTask.this.process.exitValue();
            }
            catch (IOException e) {
                MavenLog.LOG.warn(stringBuilder.toString(), (Throwable)e);
            }
            finally {
                Flexmojos4GenerateConfigTask.this.process.destroy();
                Flexmojos4GenerateConfigTask.this.process = null;
                String result = stringBuilder.toString().replace('\r', '\n');
                StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
                if (exitCode != 0) {
                    MavenLog.LOG.warn("Generating flex configs exited with exit code " + exitCode);
                    Flexmojos4GenerateConfigTask.showWarning(this.project, "exit code: " + exitCode);
                }
                MavenLog.LOG.info("Generating flex configs out:\n" + result);
                if (result.startsWith(Flexmojos4GenerateConfigTask.ERROR) || result.contains("\n[ERROR]")) {
                    StringBuilder errorBuf = new StringBuilder();
                    List lines = StringUtil.split((String)result, (String)"\n");
                    for (String line : lines) {
                        if (!line.startsWith(Flexmojos4GenerateConfigTask.ERROR)) continue;
                        if (errorBuf.length() > 0) {
                            errorBuf.append("\n");
                        }
                        errorBuf.append(line);
                    }
                    Flexmojos4GenerateConfigTask.showWarningWithDetails(this.project, errorBuf.toString());
                }
                if (!filesForRefresh.isEmpty()) {
                    Flexmojos4GenerateConfigTask.this.postTask = new RefreshConfigFiles(filesForRefresh, (THashMap<MavenProject, List<String>>)sourceRoots, this.project);
                }
            }
        }
    }
}

