/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.javascript.flex.mxml.schema.AnnotationBackedDescriptorImpl;
import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.javascript.flex.mxml.schema.CodeContextHolder;
import com.intellij.javascript.flex.mxml.schema.MxmlBackedElementDescriptor;
import com.intellij.javascript.flex.resolve.SwcCatalogXmlUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeContext {
    private static final String CLASS_FACTORY = "mx.core.ClassFactory";
    @NonNls
    static final String DEFINITION_TAG_NAME = "Definition";
    @NonNls
    public static final String REPARENT_TAG_NAME = "Reparent";
    @NonNls
    public static final String TARGET_ATTR_NAME = "target";
    public static final String AS3_VEC_VECTOR_QUALIFIED_NAME = "__AS3__.vec.Vector";
    static final String FORMAT_ATTR_NAME = "format";
    static final String TWO_WAY_ATTR_NAME = "twoWay";
    private static final String XML_CLASS = "XML";
    private static final String XMLNODE_CLASS = "flash.xml.XMLNode";
    static final String[] GUMBO_ATTRIBUTES = new String[]{"includeIn", "excludeFrom", "itemCreationPolicy", "itemDestructionPolicy"};
    private final Map<String, ClassBackedElementDescriptor> myNameToDescriptorsMap;
    public final String namespace;
    public final Module module;
    private final Set<Object> dependencies = new THashSet();

    CodeContext(String _namespace, Module _module) {
        this.myNameToDescriptorsMap = new THashMap(100);
        this.namespace = _namespace;
        this.module = _module;
        if (JavaScriptSupportLoader.isLanguageNamespace((String)this.namespace)) {
            CodeContext.addPredefinedTags(this);
            this.myNameToDescriptorsMap.put(XML_CLASS, CodeContext.createXmlTagDescriptor(this, XML_CLASS));
            this.myNameToDescriptorsMap.put("XMLList", new ClassBackedElementDescriptor("XMLList", this, this.module.getProject(), false));
        }
    }

    private void putDescriptor(String name, ClassBackedElementDescriptor descriptor, boolean addGumboAttributesIfNeeded) {
        if (JavaScriptSupportLoader.isLanguageNamespace((String)this.namespace)) {
            if (XML_CLASS.equals(name) || "XMLList".equals(name)) {
                return;
            }
            if ("String".equals(name) || "Boolean".equals(name) || "int".equals(name) || "uint".equals(name) || "Number".equals(name)) {
                descriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("source", descriptor, true, null, null, null));
            }
        }
        if ("http://ns.adobe.com/mxml/2009".equals(this.namespace) && "Vector".equals(name)) {
            AnnotationBackedDescriptorImpl typeDescriptor = new AnnotationBackedDescriptorImpl("type", descriptor, true, null, null, null);
            typeDescriptor.setRequired(true);
            descriptor.addPredefinedMemberDescriptor(typeDescriptor);
        } else if (addGumboAttributesIfNeeded && FlexSdkUtils.isFlex4Sdk(FlexUtils.getSdkForActiveBC(this.module))) {
            for (String gumboAttr : GUMBO_ATTRIBUTES) {
                descriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl(gumboAttr, descriptor, true, null, null, null));
            }
        }
        this.myNameToDescriptorsMap.put(name, descriptor);
    }

    private void addDependency(@NotNull Object dep) {
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "com/intellij/javascript/flex/mxml/schema/CodeContext", "addDependency"));
        }
        this.dependencies.add(dep);
    }

    Object[] getDependencies() {
        return this.dependencies.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeContext getContext(String namespace, Module module) {
        if (StringUtil.isEmptyOrSpaces((String)namespace) || module == null || module.isDisposed() || !(ModuleType.get((Module)module) instanceof FlexModuleType)) {
            return CodeContextHolder.EMPTY;
        }
        FlexBuildConfiguration bc = FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration();
        if (bc == null) {
            return CodeContextHolder.EMPTY;
        }
        Class<CodeContext> clazz = CodeContext.class;
        synchronized (CodeContext.class) {
            if (CodeContext.isStdNamespace(namespace)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return CodeContext.getStdCodeContext(namespace, module, bc);
            }
            CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
            CodeContext codeContext = contextHolder.getCodeContext(namespace, module);
            if (codeContext == null && (codeContext = CodeContext.createCodeContext(namespace, module, bc)).getAllDescriptorsSize() > 0) {
                contextHolder.putCodeContext(namespace, module, codeContext);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return codeContext;
        }
    }

    public static boolean isStdNamespace(String namespace) {
        return FlexUtils.isMxmlNs(namespace);
    }

    public static boolean isPackageBackedNamespace(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/CodeContext", "isPackageBackedNamespace"));
        }
        return namespace.equals("*") || namespace.endsWith(".*");
    }

    private static CodeContext createCodeContext(String namespace, Module module, FlexBuildConfiguration bc) {
        if (!CodeContext.isPackageBackedNamespace(namespace)) {
            return CodeContext.createCodeContextFromLibraries(namespace, module, bc);
        }
        final Project project = module.getProject();
        final CodeContext codeContext = new CodeContext(namespace, module);
        final String packageName = namespace.endsWith(".*") ? namespace.substring(0, namespace.length() - 2) : "";
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JSPackageIndex.processElementsInScope((String)packageName, null, (JSPackageIndex.PackageElementsProcessor)new JSPackageIndex.PackageElementsProcessor(){

            public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (kind != JSPackageIndexInfo.Kind.CLASS) {
                    return true;
                }
                if (JavaScriptSupportLoader.isMxmlOrFxgFile((VirtualFile)file)) {
                    CodeContext.addFileBackedDescriptor(file, codeContext, packageName, project);
                    PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(file.getParent());
                    if (psiDirectory != null) {
                        codeContext.addDependency(psiDirectory);
                    }
                } else {
                    String qName = JSPackageIndex.buildQualifiedName((String)packageName, (String)name);
                    codeContext.putDescriptor(name, new ClassBackedElementDescriptor(name, qName, codeContext, project), true);
                    PsiFile containingFile = PsiManager.getInstance((Project)project).findFile(file);
                    if (containingFile == null) {
                        return true;
                    }
                    PsiDirectory containingDirectory = containingFile.getParent();
                    PsiDirectory dependency = containingDirectory != null ? containingDirectory : containingFile;
                    codeContext.addDependency(dependency);
                }
                return true;
            }
        }, (GlobalSearchScope)searchScope, (Project)project);
        return codeContext;
    }

    private static void handleSwcFromSdk(Module module, @NotNull FlexBuildConfiguration bc) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/javascript/flex/mxml/schema/CodeContext", "handleSwcFromSdk"));
        }
        Sdk sdk = bc.getSdk();
        if (sdk == null) {
            return;
        }
        THashMap contextsOfModule = new THashMap();
        for (VirtualFile file : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            String swcPath = VirtualFileManager.extractPath((String)StringUtil.trimEnd((String)file.getUrl(), (String)"!/"));
            if (BCUtils.getSdkEntryLinkageType(swcPath, bc) == null) continue;
            CodeContext.handleFileDependency(module, (Map<String, CodeContext>)contextsOfModule, file);
        }
        CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
        for (Map.Entry entry : contextsOfModule.entrySet()) {
            contextHolder.putCodeContext((String)entry.getKey(), module, (CodeContext)entry.getValue());
        }
    }

    private static CodeContext createCodeContextFromLibraries(String namespace, Module module, FlexBuildConfiguration bc) {
        THashMap contextsOfModule = new THashMap();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            Library library;
            if (entry.getDependencyType().getLinkageType() == LinkageType.LoadInRuntime) continue;
            if (entry instanceof BuildConfigurationEntry) {
                FlexBuildConfiguration bcDependency = ((BuildConfigurationEntry)entry).findBuildConfiguration();
                if (bcDependency == null || bcDependency.getOutputType() != OutputType.Library) continue;
                CodeContext.addComponentsFromManifests(module, (Map<String, CodeContext>)contextsOfModule, bcDependency, true);
                continue;
            }
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, (ModuleRootModel)rootManager);
                if (orderEntry == null) continue;
                for (VirtualFile file : orderEntry.getRootFiles(OrderRootType.CLASSES)) {
                    CodeContext.handleFileDependency(module, (Map<String, CodeContext>)contextsOfModule, file);
                }
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(module.getProject(), (SharedLibraryEntry)entry)) == null) continue;
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                CodeContext.handleFileDependency(module, (Map<String, CodeContext>)contextsOfModule, file);
            }
        }
        CodeContext.addComponentsFromManifests(module, (Map<String, CodeContext>)contextsOfModule, bc, false);
        CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
        for (Map.Entry entry : contextsOfModule.entrySet()) {
            contextHolder.putCodeContext((String)entry.getKey(), module, (CodeContext)entry.getValue());
        }
        CodeContext codeContext = (CodeContext)contextsOfModule.get(namespace);
        if (codeContext == null) {
            codeContext = CodeContextHolder.EMPTY;
        }
        return codeContext;
    }

    private static void addComponentsFromManifests(final Module module, final Map<String, CodeContext> contextsOfModule, FlexBuildConfiguration bc, boolean onlyIncludedInSwc) {
        String configFilePath = bc.getCompilerOptions().getAdditionalConfigFilePath();
        final VirtualFile configFile = StringUtil.isEmptyOrSpaces((String)configFilePath) ? null : LocalFileSystem.getInstance().findFileByPath(configFilePath);
        for (FlexCompilerConfigFileUtil.NamespacesInfo info : FlexCompilerConfigFileUtil.getNamespacesInfos(configFile)) {
            VirtualFile manifestFile;
            if (onlyIncludedInSwc && !info.includedInSwc || (manifestFile = VfsUtil.findRelativeFile((String)info.manifest, (VirtualFile)configFile)) == null || manifestFile.isDirectory()) continue;
            CodeContext.processManifestFile(module, contextsOfModule, manifestFile, info.namespace, (ModificationTracker)configFile);
        }
        FlexUtils.processCompilerOption(module, bc, "compiler.namespaces.namespace", new Processor<Pair<String, String>>(){

            public boolean process(Pair<String, String> namespaceAndManifest) {
                VirtualFile manifestFile = VfsUtil.findRelativeFile((String)((String)namespaceAndManifest.second), (VirtualFile)configFile);
                if (manifestFile != null && !manifestFile.isDirectory()) {
                    CodeContext.processManifestFile(module, contextsOfModule, manifestFile, (String)namespaceAndManifest.first, (ModificationTracker)configFile);
                }
                return true;
            }
        });
    }

    private static void handleFileDependency(Module module, Map<String, CodeContext> contextsOfModule, VirtualFile file) {
        if (file.getFileType() == FileTypes.ARCHIVE && ("swc".equalsIgnoreCase(file.getExtension()) || "ane".equalsIgnoreCase(file.getExtension()))) {
            VirtualFile local;
            VirtualFile virtualFile = local = file.getFileSystem() instanceof JarFileSystem ? file : JarFileSystem.getInstance().getJarRootForLocalFile(file);
            if (local == null) {
                return;
            }
            VirtualFile catalog = local.findChild("catalog.xml");
            if (catalog == null) {
                return;
            }
            CodeContext.processCatalogFile(module, contextsOfModule, catalog);
        }
    }

    private static void processCatalogFile(final Module module, final Map<String, CodeContext> contextsOfModule, final VirtualFile catalogFile) {
        SwcCatalogXmlUtil.processComponentsFromCatalogXml(catalogFile, new Consumer<SwcCatalogXmlUtil.ComponentFromCatalogXml>(){

            public void consume(SwcCatalogXmlUtil.ComponentFromCatalogXml componentFromCatalogXml) {
                CodeContext codeContext = CodeContext.identifyCodeContext(module, contextsOfModule, componentFromCatalogXml.myUri);
                codeContext.addDependency(catalogFile);
                codeContext.putDescriptor(componentFromCatalogXml.myName, new ClassBackedElementDescriptor(componentFromCatalogXml.myName, componentFromCatalogXml.myClassFqn, codeContext, module.getProject(), false, componentFromCatalogXml.myIcon), true);
            }
        });
    }

    private static CodeContext identifyCodeContext(Module module, Map<String, CodeContext> contextsOfModule, String uri) {
        CodeContext codeContext;
        if (CodeContext.isStdNamespace(uri)) {
            CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
            codeContext = contextHolder.getStandardContext(uri, module);
            if (codeContext == null) {
                codeContext = new CodeContext(uri, module);
                contextHolder.putStandardContext(uri, module, codeContext);
            }
        } else {
            codeContext = contextsOfModule.get(uri);
            if (codeContext == null) {
                codeContext = new CodeContext(uri, module);
                contextsOfModule.put(uri, codeContext);
            }
        }
        return codeContext;
    }

    private static void processManifestFile(Module module, Map<String, CodeContext> contextsOfModule, VirtualFile manifestFile, String uri, @Nullable ModificationTracker dependency) {
        CodeContext codeContext = CodeContext.identifyCodeContext(module, contextsOfModule, uri);
        if (dependency != null) {
            codeContext.addDependency(dependency);
        }
        CodeContext.processManifestFile(manifestFile, codeContext);
    }

    private static void processManifestFile(VirtualFile manifestFile, final CodeContext codeContext) {
        codeContext.addDependency(manifestFile);
        SwcCatalogXmlUtil.processManifestFile(manifestFile, new Consumer<SwcCatalogXmlUtil.ComponentFromManifest>(){

            public void consume(SwcCatalogXmlUtil.ComponentFromManifest componentFromManifest) {
                codeContext.putDescriptor(componentFromManifest.myComponentName, new ClassBackedElementDescriptor(componentFromManifest.myComponentName, componentFromManifest.myClassFqn, codeContext, codeContext.module.getProject()), true);
            }
        });
    }

    private static void addFileBackedDescriptor(VirtualFile file, CodeContext codeContext, String packageName, Project project) {
        codeContext.putDescriptor(file.getNameWithoutExtension(), new MxmlBackedElementDescriptor(JSPackageIndex.buildQualifiedName((String)packageName, (String)file.getNameWithoutExtension()), codeContext, project, file), true);
    }

    private static CodeContext getStdCodeContext(String namespace, Module module, FlexBuildConfiguration bc) {
        CodeContext context;
        CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
        if (!contextHolder.areSdkComponentsHandledForModule(module)) {
            CodeContext.handleAllStandardManifests(module, bc);
            CodeContext.handleSwcFromSdk(module, bc);
            CodeContext.createCodeContextFromLibraries(namespace, module, bc);
            contextHolder.setSdkComponentsHandledForModule(module);
        }
        return (context = contextHolder.getStandardContext(namespace, module)) != null ? context : CodeContextHolder.EMPTY;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NonNls String localName, @Nullable XmlTag tag) {
        String format;
        ClassBackedElementDescriptor descriptor;
        ClassBackedElementDescriptor classBackedElementDescriptor = descriptor = this == CodeContextHolder.EMPTY ? null : this.myNameToDescriptorsMap.get(localName);
        if (tag != null && XML_CLASS.equals(localName) && JavaScriptSupportLoader.isLanguageNamespace((String)tag.getNamespace()) && (format = tag.getAttributeValue(FORMAT_ATTR_NAME)) != null && !"e4x".equalsIgnoreCase(format)) {
            return CodeContext.createXmlTagDescriptor(this, XMLNODE_CLASS);
        }
        return descriptor;
    }

    public void appendDescriptorsWithAllowedDeclaration(Collection<XmlElementDescriptor> resultList) {
        for (ClassBackedElementDescriptor descriptor : this.myNameToDescriptorsMap.values()) {
            if (!CodeContext.checkDeclaration(descriptor)) continue;
            resultList.add(descriptor);
        }
    }

    public static boolean checkDeclaration(@NotNull ClassBackedElementDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javascript/flex/mxml/schema/CodeContext", "checkDeclaration"));
        }
        PsiElement declaration = descriptor.getDeclaration();
        return declaration instanceof XmlFile || declaration instanceof JSClass && CodeContext.hasDefaultConstructor((JSClass)declaration);
    }

    public XmlElementDescriptor[] getDescriptorsWithAllowedDeclaration() {
        THashSet descriptors = new THashSet();
        this.appendDescriptorsWithAllowedDeclaration((Collection<XmlElementDescriptor>)descriptors);
        return (XmlElementDescriptor[])descriptors.toArray((Object[])new XmlElementDescriptor[descriptors.size()]);
    }

    public static boolean hasDefaultConstructor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/javascript/flex/mxml/schema/CodeContext", "hasDefaultConstructor"));
        }
        JSFunction constructor = jsClass.getConstructor();
        JSParameter[] parameters = constructor == null ? null : constructor.getParameterVariables();
        return parameters == null || parameters.length == 0 || parameters[0].isOptional() || parameters[0].isRest();
    }

    public int getAllDescriptorsSize() {
        return this.myNameToDescriptorsMap.size();
    }

    @Nullable
    public ClassBackedElementDescriptor getElementDescriptor(@NotNull String name, @NotNull String qname) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/mxml/schema/CodeContext", "getElementDescriptor"));
        }
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "com/intellij/javascript/flex/mxml/schema/CodeContext", "getElementDescriptor"));
        }
        ClassBackedElementDescriptor descriptor = this.myNameToDescriptorsMap.get(name);
        if (descriptor != null && !qname.equals(descriptor.getQualifiedName())) {
            descriptor = null;
        }
        if (descriptor == null && !name.equals(qname)) {
            descriptor = this.myNameToDescriptorsMap.get(qname);
        }
        return descriptor;
    }

    private static void handleAllStandardManifests(final Module module, @NotNull FlexBuildConfiguration bc) {
        VirtualFile sdkHome;
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/javascript/flex/mxml/schema/CodeContext", "handleAllStandardManifests"));
        }
        Sdk sdk = bc.getSdk();
        String homePath = sdk == null ? null : sdk.getHomePath();
        VirtualFile virtualFile = sdkHome = homePath == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
        if (sdkHome == null || sdk.getSdkType() == FlexmojosSdkType.getInstance()) {
            return;
        }
        FlexSdkUtils.processStandardNamespaces(bc, new PairConsumer<String, String>(){

            public void consume(String namespace, String relativePath) {
                VirtualFile manifestFile = VfsUtil.findRelativeFile((String)relativePath, (VirtualFile)sdkHome);
                if (manifestFile != null) {
                    CodeContext.handleStandardManifest(module, namespace, manifestFile, sdkHome);
                }
            }
        });
    }

    private static void handleStandardManifest(Module module, String namespace, VirtualFile manifestFile, VirtualFile flexSdkRoot) {
        CodeContextHolder contextHolder = CodeContextHolder.getInstance(module.getProject());
        CodeContext _context = contextHolder.getStandardContext(namespace, module);
        if (_context == null) {
            _context = new CodeContext(namespace, module);
            contextHolder.putStandardContext(namespace, module, _context);
        }
        CodeContext context = _context;
        context.addDependency(flexSdkRoot);
        CodeContext.processManifestFile(manifestFile, context);
    }

    private static void addPredefinedTags(CodeContext codeContext) {
        ArrayList<String> predefinedTags = new ArrayList<String>();
        predefinedTags.add("Script");
        predefinedTags.add("Style");
        predefinedTags.add("Metadata");
        if ("http://ns.adobe.com/mxml/2009".equals(codeContext.namespace)) {
            predefinedTags.add("Declarations");
            predefinedTags.add("Private");
            predefinedTags.add("Library");
            ClassBackedElementDescriptor definitionDescriptor = new ClassBackedElementDescriptor(DEFINITION_TAG_NAME, codeContext, codeContext.module.getProject(), true);
            definitionDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("name", definitionDescriptor, true, null, null, null));
            codeContext.putDescriptor(DEFINITION_TAG_NAME, definitionDescriptor, false);
            ClassBackedElementDescriptor reparentDescriptor = new ClassBackedElementDescriptor(REPARENT_TAG_NAME, codeContext, codeContext.module.getProject(), true);
            reparentDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl(TARGET_ATTR_NAME, reparentDescriptor, true, null, null, null));
            reparentDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("includeIn", reparentDescriptor, true, null, null, null));
            reparentDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("excludeFrom", reparentDescriptor, true, null, null, null));
            codeContext.putDescriptor(REPARENT_TAG_NAME, reparentDescriptor, false);
        }
        for (String predefined : predefinedTags) {
            codeContext.putDescriptor(predefined, new ClassBackedElementDescriptor(predefined, codeContext, codeContext.module.getProject(), true), false);
        }
        ClassBackedElementDescriptor modelDescriptor = new ClassBackedElementDescriptor("Model", codeContext, codeContext.module.getProject(), true);
        modelDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("id", modelDescriptor, true, null, null, null));
        modelDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("source", modelDescriptor, true, null, null, null));
        codeContext.putDescriptor("Model", modelDescriptor, false);
        ClassBackedElementDescriptor bindingDescriptor = new ClassBackedElementDescriptor("Binding", codeContext, codeContext.module.getProject(), true);
        bindingDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("source", bindingDescriptor, true, null, null, null));
        bindingDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("destination", bindingDescriptor, true, null, null, null));
        if ("http://ns.adobe.com/mxml/2009".equals(codeContext.namespace)) {
            bindingDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl(TWO_WAY_ATTR_NAME, bindingDescriptor, true, null, null, null));
        }
        codeContext.putDescriptor("Binding", bindingDescriptor, false);
        ClassBackedElementDescriptor componentDescriptor = new ClassBackedElementDescriptor("Component", CLASS_FACTORY, codeContext, codeContext.module.getProject());
        codeContext.putDescriptor("Component", componentDescriptor, false);
    }

    private static ClassBackedElementDescriptor createXmlTagDescriptor(CodeContext codeContext, String backedClassFqn) {
        ClassBackedElementDescriptor xmlDescriptor = new ClassBackedElementDescriptor(XML_CLASS, backedClassFqn, codeContext, codeContext.module.getProject());
        xmlDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("source", xmlDescriptor, true, null, null, null));
        xmlDescriptor.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl(FORMAT_ATTR_NAME, xmlDescriptor, true, null, null, null));
        return xmlDescriptor;
    }
}

