/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.ProjectTopics;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeContextHolder
extends AbstractProjectComponent {
    private final Set<Module> myModulesWithSdkComponentsHandled = new HashSet<Module>();
    private final Map<String, Map<Module, CodeContext>> myStandardContexts = new HashMap<String, Map<Module, CodeContext>>();
    private final Map<String, Map<Module, CodeContext>> myNSToCodeContextMap = new THashMap();
    static final CodeContext EMPTY = new CodeContext(null, null);

    public CodeContextHolder(Project project) {
        super(project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(ModuleRootEvent event) {
                CodeContextHolder codeContextHolder = CodeContextHolder.this;
                synchronized (codeContextHolder) {
                    CodeContextHolder.this.myNSToCodeContextMap.clear();
                    CodeContextHolder.this.myStandardContexts.clear();
                    CodeContextHolder.this.myModulesWithSdkComponentsHandled.clear();
                }
            }
        });
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CodeContextHolder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "getComponentName"));
        }
        return "CodeContextHolder";
    }

    @Nullable
    public synchronized CodeContext getCodeContext(@NotNull String namespace, @NotNull Module module) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "getCodeContext"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "getCodeContext"));
        }
        Map<Module, CodeContext> map = this.myNSToCodeContextMap.get(namespace);
        if (map != null) {
            return map.get(module);
        }
        return null;
    }

    public synchronized void putCodeContext(@NotNull String namespace, @NotNull Module module, @NotNull CodeContext codeContext) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "putCodeContext"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "putCodeContext"));
        }
        if (codeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeContext", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "putCodeContext"));
        }
        THashMap map = this.myNSToCodeContextMap.get(namespace);
        if (map == null) {
            map = new THashMap();
            this.myNSToCodeContextMap.put(namespace, (Map<Module, CodeContext>)map);
        }
        map.put(module, codeContext);
    }

    public synchronized void clearCodeContext(@NotNull String namespace, @NotNull Module module) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "clearCodeContext"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "clearCodeContext"));
        }
        Map<Module, CodeContext> map = this.myNSToCodeContextMap.get(namespace);
        if (map != null) {
            map.remove(module);
        }
    }

    public static CodeContextHolder getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/mxml/schema/CodeContextHolder", "getInstance"));
        }
        return (CodeContextHolder)((Object)project.getComponent(CodeContextHolder.class));
    }

    @Nullable
    public synchronized CodeContext getStandardContext(String namespace, Module module) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        return map == null ? null : map.get(module);
    }

    public synchronized Collection<String> getNamespaces(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myStandardContexts.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myNSToCodeContextMap.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    synchronized void putStandardContext(String namespace, Module module, CodeContext codeContext) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        if (map == null) {
            map = new HashMap<Module, CodeContext>();
            this.myStandardContexts.put(namespace, map);
        }
        map.put(module, codeContext);
    }

    synchronized boolean areSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.contains(module);
    }

    synchronized boolean setSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.add(module);
    }
}

