/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.javascript.generation.JavaScriptGenerateEventHandler;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptArrangementEntry
extends DefaultArrangementEntry
implements TypeAwareArrangementEntry,
ModifierAwareArrangementEntry,
NameAwareArrangementEntry {
    private static final Logger LOG = Logger.getInstance((String)ActionScriptArrangementEntry.class.getName());
    static final Comparator<ActionScriptArrangementEntry> COMPARATOR = new Comparator<ActionScriptArrangementEntry>(){

        @Override
        public int compare(ActionScriptArrangementEntry entry1, ActionScriptArrangementEntry entry2) {
            return entry1.getStartOffset() - entry2.getStartOffset();
        }
    };
    private final String myName;
    private ArrangementSettingsToken myType;
    private Set<ArrangementSettingsToken> myModifiers;

    private ActionScriptArrangementEntry(@Nullable String name, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @NotNull TextRange range) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "<init>"));
        }
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "<init>"));
        }
        super(null, range.getStartOffset(), range.getEndOffset(), true);
        this.myName = name;
        this.myType = type;
        this.myModifiers = modifiers;
    }

    @Nullable
    public static ActionScriptArrangementEntry create(@NotNull JSBlockStatement blockStatement, @NotNull Collection<TextRange> allowedRanges, @Nullable Document document) {
        if (blockStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStatement", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        if (allowedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedRanges", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        TextRange textRange = blockStatement.getTextRange();
        if (ActionScriptArrangementEntry.isWithinBounds(textRange, allowedRanges)) {
            TextRange range = document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)document);
            return new ActionScriptArrangementEntry(null, StdArrangementTokens.EntryType.STATIC_INIT, Collections.emptySet(), range);
        }
        return null;
    }

    @Nullable
    public static ActionScriptArrangementEntry create(@NotNull JSVarStatement varStatement, @NotNull Collection<TextRange> allowedRanges, @Nullable Document document) {
        if (varStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varStatement", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        if (allowedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedRanges", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        TextRange textRange = varStatement.getTextRange();
        if (ActionScriptArrangementEntry.isWithinBounds(textRange, allowedRanges)) {
            TextRange range = document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)document);
            JSVariable[] variables = varStatement.getVariables();
            if (variables.length > 0) {
                JSVariable variable = variables[0];
                return new ActionScriptArrangementEntry(variable.getName(), ActionScriptArrangementEntry.getType((JSAttributeListOwner)variable), ActionScriptArrangementEntry.getModifiers((JSAttributeListOwner)variable), range);
            }
        }
        return null;
    }

    @Nullable
    public static ActionScriptArrangementEntry create(@NotNull JSFunction function, @NotNull Collection<TextRange> allowedRanges, @Nullable Document document) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        if (allowedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedRanges", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "create"));
        }
        TextRange textRange = function.getTextRange();
        if (ActionScriptArrangementEntry.isWithinBounds(textRange, allowedRanges)) {
            TextRange range = document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)document);
            return new ActionScriptArrangementEntry(function.getName(), ActionScriptArrangementEntry.getType((JSAttributeListOwner)function), ActionScriptArrangementEntry.getModifiers((JSAttributeListOwner)function), range);
        }
        return null;
    }

    private static ArrangementSettingsToken getType(JSAttributeListOwner fieldOrMethod) {
        if (fieldOrMethod instanceof JSVariable) {
            return ((JSVariable)fieldOrMethod).isConst() ? StdArrangementTokens.EntryType.CONST : StdArrangementTokens.EntryType.VAR;
        }
        LOG.assertTrue(fieldOrMethod instanceof JSFunction, (Object)fieldOrMethod);
        JSFunction function = (JSFunction)fieldOrMethod;
        if (function.isConstructor()) {
            return StdArrangementTokens.EntryType.CONSTRUCTOR;
        }
        if (function.isGetProperty()) {
            return StdArrangementTokens.EntryType.PROPERTY;
        }
        if (function.isSetProperty()) {
            return StdArrangementTokens.EntryType.PROPERTY;
        }
        if (ActionScriptArrangementEntry.isEventHandler(function)) {
            return StdArrangementTokens.EntryType.EVENT_HANDLER;
        }
        return StdArrangementTokens.EntryType.METHOD;
    }

    private static boolean isEventHandler(JSFunction function) {
        PsiElement resolve;
        PsiElement typeElement;
        JSParameter[] parameters = function.getParameterVariables();
        return parameters.length == 1 && (typeElement = parameters[0].getTypeElement()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)typeElement).resolve()) instanceof JSClass && ("flash.events.Event".equals(((JSClass)resolve).getQualifiedName()) || "starling.events.Event".equals(((JSClass)resolve).getQualifiedName()) || JavaScriptGenerateEventHandler.isEventClass((JSClass)resolve));
    }

    private static Set<ArrangementSettingsToken> getModifiers(JSAttributeListOwner fieldOrMethod) {
        HashSet result = ContainerUtilRt.newHashSet();
        JSAttributeList attributes = fieldOrMethod.getAttributeList();
        if (attributes != null) {
            String namespace;
            JSAttributeList.AccessType accessType = attributes.getExplicitAccessType();
            if (accessType == null && (namespace = attributes.getNamespace()) == null) {
                accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
            if (accessType != null) {
                switch (accessType) {
                    case PUBLIC: {
                        result.add(StdArrangementTokens.Modifier.PUBLIC);
                        break;
                    }
                    case PROTECTED: {
                        result.add(StdArrangementTokens.Modifier.PROTECTED);
                        break;
                    }
                    case PACKAGE_LOCAL: {
                        result.add(StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
                        break;
                    }
                    case PRIVATE: {
                        result.add(StdArrangementTokens.Modifier.PRIVATE);
                    }
                }
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                result.add(StdArrangementTokens.Modifier.STATIC);
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                result.add(StdArrangementTokens.Modifier.FINAL);
            }
            if (attributes.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                result.add(StdArrangementTokens.Modifier.OVERRIDE);
            }
        }
        return result;
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "isWithinBounds"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "isWithinBounds"));
        }
        for (TextRange textRange : ranges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setType(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "setType"));
        }
        this.myType = type;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "getType"));
        }
        return arrangementSettingsToken;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        HashSet hashSet = ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{this.myType});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "getTypes"));
        }
        return hashSet;
    }

    public void setModifiers(@NotNull Set<ArrangementSettingsToken> modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "setModifiers"));
        }
        this.myModifiers = modifiers;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getModifiers() {
        Set<ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptArrangementEntry", "getModifiers"));
        }
        return set;
    }

    public String toString() {
        return StringUtil.join(this.myModifiers, (String)" ").toLowerCase() + " " + this.myType.toString().toLowerCase() + " " + this.myName;
    }
}

