/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class ActionScriptExpectedTypeEvaluator
extends ExpectedTypeEvaluator {
    public ActionScriptExpectedTypeEvaluator(JSExpression parent) {
        super(parent);
    }

    protected ActionScriptExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        return new ActionScriptExpectedTypeEvaluator(parent);
    }

    protected void findRestParameterExpectedType(JSParameterItem parameterItem) {
        JSType classType;
        if (!(parameterItem instanceof JSParameter)) {
            super.findRestParameterExpectedType(parameterItem);
            return;
        }
        JSParameter param = (JSParameter)parameterItem;
        JSFunction fun = param.getDeclaringFunction();
        if (fun == null) {
            super.findRestParameterExpectedType(parameterItem);
            return;
        }
        PsiElement element = JSResolveUtil.findParent((PsiElement)fun);
        JSType jSType = classType = element instanceof JSClass ? JSNamedType.createType((String)((JSClass)element).getQualifiedName(), (JSTypeSource)JSTypeSource.EMPTY, (JSContext)JSContext.INSTANCE) : null;
        if (classType != null && JSTypeUtils.isActionScriptVectorType((JSType)classType)) {
            JSExpression qualifier;
            String name = fun.getName();
            JSType qualifiedExpressionType = null;
            JSExpression methodExpression = ((JSCallExpression)JSTypeUtils.getScopeInOriginalTree((PsiElement)this.myGrandParent).getParent()).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
                qualifiedExpressionType = JSResolveUtil.getQualifiedExpressionJSType((JSExpression)qualifier, (PsiFile)qualifier.getContainingFile());
            }
            if (qualifiedExpressionType != null) {
                if ("push".equals(name) || "unshift".equals(name) || "splice".equals(name)) {
                    if (qualifiedExpressionType instanceof JSGenericTypeImpl) {
                        this.myResult = (JSType)ContainerUtil.getFirstItem((List)((JSGenericTypeImpl)qualifiedExpressionType).getArguments());
                    }
                } else if ("concat".equals(name)) {
                    this.myResult = qualifiedExpressionType;
                }
            }
        } else {
            this.myResult = this.createNamedType("Object", (PsiElement)this.myParent);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        if (ActionScriptExpectedTypeEvaluator.isASDictionaryAccess(node)) {
            this.myResult = this.createNamedType("Object", this.myGrandParent);
        } else {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)this.myGrandParent, (boolean)true);
            this.myResult = new JSCompositeTypeImpl(typeSource, new JSType[]{JSNamedType.createType((String)"int", (JSTypeSource)typeSource, (JSContext)JSContext.INSTANCE), JSNamedType.createType((String)"uint", (JSTypeSource)typeSource, (JSContext)JSContext.INSTANCE)});
        }
    }

    private static boolean isASDictionaryAccess(JSIndexedPropertyAccessExpression expression) {
        if (expression.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        JSExpression qualifier = expression.getQualifier();
        PsiElement resolve = qualifier instanceof JSReferenceExpression ? ((JSReferenceExpression)qualifier).resolve() : null;
        String type = resolve instanceof JSVariable ? ((JSVariable)resolve).getTypeString() : null;
        return type != null && JSResolveUtil.isAssignableType((String)"flash.utils.Dictionary", (String)type, (PsiElement)expression);
    }
}

