/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.FlexBCTree;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageAction;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.lang.javascript.flex.actions.airpackage.PasswordStore;
import com.intellij.lang.javascript.flex.build.FlashProjectStructureProblem;
import com.intellij.lang.javascript.flex.build.ValidateFlashConfigurationsPrecompileTask;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AirPackageDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private FlexBCTree myTree;
    private JComboBox myDesktopTypeCombo;
    private JComboBox myAndroidTypeCombo;
    private JCheckBox myApkCaptiveRuntimeCheckBox;
    private JPanel myApkDebugPortPanel;
    private JTextField myApkDebugPortTextField;
    private JComboBox myIOSTypeCombo;
    private JCheckBox myIosFastPackagingCheckBox;
    private JLabel myDesktopTypeLabel;
    private JLabel myAndroidTypeLabel;
    private JLabel myIosTypeLabel;
    private final Project myProject;
    private PasswordStore myPasswords;

    protected AirPackageDialog(Project project) {
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(FlexBundle.message("package.air.application.title", objectArray));
        this.setOKButtonText("Package");
        this.setupComboBoxes();
        this.init();
        this.loadParameters();
        this.updateControlsVisibility();
        this.updateControlsEnabledState();
    }

    private void setupComboBoxes() {
        this.myDesktopTypeCombo.setModel(new DefaultComboBoxModel<AirPackageProjectParameters.DesktopPackageType>(AirPackageProjectParameters.DesktopPackageType.values()));
        this.myAndroidTypeCombo.setModel(new DefaultComboBoxModel<AirPackageProjectParameters.AndroidPackageType>(AirPackageProjectParameters.AndroidPackageType.values()));
        this.myIOSTypeCombo.setModel(new DefaultComboBoxModel<AirPackageProjectParameters.IOSPackageType>(new AirPackageProjectParameters.IOSPackageType[]{AirPackageProjectParameters.IOSPackageType.Test, AirPackageProjectParameters.IOSPackageType.DebugOverNetwork, AirPackageProjectParameters.IOSPackageType.AdHoc, AirPackageProjectParameters.IOSPackageType.AppStore}));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirPackageDialog.this.updateControlsVisibility();
            }
        };
        this.myDesktopTypeCombo.addActionListener(listener);
        this.myAndroidTypeCombo.addActionListener(listener);
        this.myIOSTypeCombo.addActionListener(listener);
    }

    private void updateControlsVisibility() {
        AirPackageProjectParameters.AndroidPackageType androidPackaging = (AirPackageProjectParameters.AndroidPackageType)((Object)this.myAndroidTypeCombo.getSelectedItem());
        this.myApkCaptiveRuntimeCheckBox.setVisible(androidPackaging == AirPackageProjectParameters.AndroidPackageType.Release);
        this.myApkDebugPortPanel.setVisible(androidPackaging == AirPackageProjectParameters.AndroidPackageType.DebugOverUSB);
        AirPackageProjectParameters.IOSPackageType iosPackaging = (AirPackageProjectParameters.IOSPackageType)((Object)this.myIOSTypeCombo.getSelectedItem());
        this.myIosFastPackagingCheckBox.setVisible(iosPackaging == AirPackageProjectParameters.IOSPackageType.DebugOverNetwork || iosPackaging == AirPackageProjectParameters.IOSPackageType.Test);
    }

    private void updateControlsEnabledState() {
        boolean desktopPresent = false;
        boolean androidPresent = false;
        boolean iosPresent = false;
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : this.getSelectedBCs()) {
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            BuildConfigurationNature nature = bc.getNature();
            if (nature.isDesktopPlatform()) {
                desktopPresent = true;
            }
            if (nature.isMobilePlatform() && bc.getAndroidPackagingOptions().isEnabled()) {
                androidPresent = true;
            }
            if (nature.isMobilePlatform() && bc.getIosPackagingOptions().isEnabled()) {
                iosPresent = true;
            }
            if (!desktopPresent || !androidPresent || !iosPresent) continue;
            break;
        }
        this.myDesktopTypeLabel.setEnabled(desktopPresent);
        this.myDesktopTypeCombo.setEnabled(desktopPresent);
        this.myAndroidTypeLabel.setEnabled(androidPresent);
        this.myAndroidTypeCombo.setEnabled(androidPresent);
        this.myApkCaptiveRuntimeCheckBox.setEnabled(androidPresent);
        UIUtil.setEnabled((Component)this.myApkDebugPortPanel, (boolean)androidPresent, (boolean)true);
        this.myIosTypeLabel.setEnabled(iosPresent);
        this.myIOSTypeCombo.setEnabled(iosPresent);
        this.myIosFastPackagingCheckBox.setEnabled(iosPresent);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myTree = new FlexBCTree(this.myProject, new Condition<FlexBuildConfiguration>(){

            public boolean value(FlexBuildConfiguration bc) {
                BuildConfigurationNature nature = bc.getNature();
                return nature.isApp() && !nature.isWebPlatform();
            }
        });
        this.myTree.addToggleCheckBoxListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AirPackageDialog.this.updateControlsEnabledState();
            }
        });
    }

    protected String getDimensionServiceKey() {
        return "AirPackageDialog.DimensionServiceKey";
    }

    protected String getHelpId() {
        return "reference.flex.package.air.application";
    }

    protected ValidationInfo doValidate() {
        Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs = this.getSelectedBCs();
        if (modulesAndBCs.isEmpty()) {
            return new ValidationInfo("Please select one or more build configurations");
        }
        if (this.myApkDebugPortTextField.isVisible() && this.myApkDebugPortPanel.isEnabled()) {
            try {
                int port;
                String portValue = this.myApkDebugPortTextField.getText().trim();
                int n = port = portValue.isEmpty() ? 7936 : Integer.parseInt(portValue);
                if (port <= 0 || port > 65535) {
                    return new ValidationInfo("Incorrect port", (JComponent)this.myApkDebugPortPanel);
                }
            }
            catch (NumberFormatException e) {
                return new ValidationInfo("Incorrect port", (JComponent)this.myApkDebugPortTextField);
            }
        }
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCs) {
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            if (bc.isSkipCompile() && LocalFileSystem.getInstance().findFileByPath(bc.getActualOutputFilePath()) == null) {
                return new ValidationInfo(FlexBundle.message("can.not.package.bc", bc.getName(), FlexBundle.message("compilation.is.switched.off", new Object[0])));
            }
            BuildConfigurationNature nature = bc.getNature();
            if (nature.isMobilePlatform()) {
                if (!bc.getAndroidPackagingOptions().isEnabled() && !bc.getIosPackagingOptions().isEnabled()) {
                    return new ValidationInfo(FlexBundle.message("can.not.package.bc", bc.getName(), "both Android and iOS packaging disabled"));
                }
                if (bc.getAndroidPackagingOptions().isEnabled() && bc.getIosPackagingOptions().isEnabled()) {
                    boolean iosDebug;
                    AirPackageProjectParameters.AndroidPackageType androidPackage = (AirPackageProjectParameters.AndroidPackageType)((Object)this.myAndroidTypeCombo.getSelectedItem());
                    AirPackageProjectParameters.IOSPackageType iosPackage = (AirPackageProjectParameters.IOSPackageType)((Object)this.myIOSTypeCombo.getSelectedItem());
                    boolean androidDebug = androidPackage != AirPackageProjectParameters.AndroidPackageType.Release;
                    boolean bl = iosDebug = iosPackage == AirPackageProjectParameters.IOSPackageType.DebugOverNetwork;
                    if (androidDebug != iosDebug) {
                        return new ValidationInfo(FlexBundle.message("can.not.package.bc", bc.getName(), FlexBundle.message("different.debug.settings", androidDebug ? 1 : 2)));
                    }
                }
            }
            final Ref firstErrorRef = new Ref();
            ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions((Module)moduleAndBC.first, bc, new Consumer<FlashProjectStructureProblem>(){

                public void consume(FlashProjectStructureProblem problem) {
                    if (problem.severity == ProjectStructureProblemType.Severity.ERROR && firstErrorRef.isNull()) {
                        firstErrorRef.set((Object)problem.errorMessage);
                    }
                }
            });
            if (firstErrorRef.isNull()) continue;
            return new ValidationInfo(FlexBundle.message("can.not.package.bc", bc.getName(), firstErrorRef.get()));
        }
        return null;
    }

    protected void doOKAction() {
        Collection<Pair<Module, FlexBuildConfiguration>> selectedBCs = this.getSelectedBCs();
        if (!AirPackageDialog.checkDisabledCompilation(this.myProject, selectedBCs)) {
            return;
        }
        if (!this.checkPasswords(selectedBCs)) {
            return;
        }
        this.saveParameters();
        super.doOKAction();
    }

    private static boolean checkDisabledCompilation(Project project, Collection<Pair<Module, FlexBuildConfiguration>> selectedBCs) {
        ArrayList<Object> bcsWithDisabledCompilation = new ArrayList<Object>();
        for (Pair<Module, FlexBuildConfiguration> pair : selectedBCs) {
            if (!((FlexBuildConfiguration)pair.second).isSkipCompile()) continue;
            bcsWithDisabledCompilation.add(pair.second);
        }
        if (!bcsWithDisabledCompilation.isEmpty()) {
            StringBuilder bcs = new StringBuilder();
            for (FlexBuildConfiguration flexBuildConfiguration : bcsWithDisabledCompilation) {
                bcs.append("<b>").append(StringUtil.escapeXml((String)flexBuildConfiguration.getName())).append("</b><br>");
            }
            String string = FlexBundle.message("package.bc.with.disabled.compilation", bcsWithDisabledCompilation.size(), bcs.toString());
            int n = Messages.showYesNoDialog((Project)project, (String)string, (String)FlexBundle.message("package.air.application.title", new Object[0]), (Icon)Messages.getWarningIcon());
            return n == 0;
        }
        return true;
    }

    private boolean checkPasswords(Collection<Pair<Module, FlexBuildConfiguration>> selectedBCs) {
        ArrayList<AirPackagingOptions> allPackagingOptions = new ArrayList<AirPackagingOptions>();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : selectedBCs) {
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
                if (this.myDesktopTypeCombo.getSelectedItem() == AirPackageProjectParameters.DesktopPackageType.Airi) continue;
                allPackagingOptions.add(bc.getAirDesktopPackagingOptions());
                continue;
            }
            if (bc.getAndroidPackagingOptions().isEnabled()) {
                allPackagingOptions.add(bc.getAndroidPackagingOptions());
            }
            if (!bc.getIosPackagingOptions().isEnabled()) continue;
            allPackagingOptions.add(bc.getIosPackagingOptions());
        }
        this.myPasswords = AirPackageAction.getPasswords(this.myProject, allPackagingOptions);
        return this.myPasswords != null;
    }

    private void loadParameters() {
        AirPackageProjectParameters params = AirPackageProjectParameters.getInstance(this.myProject);
        this.myDesktopTypeCombo.setSelectedItem((Object)params.desktopPackageType);
        this.myAndroidTypeCombo.setSelectedItem((Object)params.androidPackageType);
        this.myApkCaptiveRuntimeCheckBox.setSelected(params.apkCaptiveRuntime);
        this.myApkDebugPortTextField.setText(String.valueOf(params.apkDebugListenPort));
        this.myIOSTypeCombo.setSelectedItem((Object)params.iosPackageType);
        this.myIosFastPackagingCheckBox.setSelected(params.iosFastPackaging);
        for (String entry : StringUtil.split((String)params.deselectedBCs, (String)"\n")) {
            int tabIndex = entry.indexOf("\t");
            if (tabIndex <= 0) continue;
            this.myTree.setChecked(entry.substring(0, tabIndex), entry.substring(tabIndex + 1), false);
        }
    }

    private void saveParameters() {
        AirPackageProjectParameters params = AirPackageProjectParameters.getInstance(this.myProject);
        params.desktopPackageType = (AirPackageProjectParameters.DesktopPackageType)((Object)this.myDesktopTypeCombo.getSelectedItem());
        params.androidPackageType = (AirPackageProjectParameters.AndroidPackageType)((Object)this.myAndroidTypeCombo.getSelectedItem());
        params.apkCaptiveRuntime = this.myApkCaptiveRuntimeCheckBox.isSelected();
        try {
            int port;
            String portValue = this.myApkDebugPortTextField.getText().trim();
            int n = port = portValue.isEmpty() ? 7936 : Integer.parseInt(portValue);
            if (port > 0 && port <= 65535) {
                params.apkDebugListenPort = port;
            }
        }
        catch (NumberFormatException portValue) {
            // empty catch block
        }
        params.iosPackageType = (AirPackageProjectParameters.IOSPackageType)((Object)this.myIOSTypeCombo.getSelectedItem());
        params.iosFastPackaging = this.myIosFastPackagingCheckBox.isSelected();
        Collection<Pair<Module, FlexBuildConfiguration>> deselectedBCs = this.myTree.getDeselectedBCs();
        StringBuilder buf = new StringBuilder();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : deselectedBCs) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(((Module)moduleAndBC.first).getName()).append('\t').append(((FlexBuildConfiguration)moduleAndBC.second).getName());
        }
        params.deselectedBCs = buf.toString();
    }

    public Collection<Pair<Module, FlexBuildConfiguration>> getSelectedBCs() {
        return this.myTree.getSelectedBCs();
    }

    public PasswordStore getPasswords() {
        assert (this.isOK()) : "ask for passwords only after OK in dialog";
        return this.myPasswords;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JPanel jPanel;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel2;
        JComboBox jComboBox3;
        JLabel jLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 7, 7, null, new Dimension(500, 200), null));
        FlexBCTree flexBCTree = this.myTree;
        jBScrollPane.setViewportView((Component)((Object)flexBCTree));
        this.myDesktopTypeLabel = jLabel3 = new JLabel();
        jLabel3.setText("Desktop application package:");
        jLabel3.setDisplayedMnemonic('D');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDesktopTypeCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("*.air installer");
        jComboBox3.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myAndroidTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Android package type (*.apk):");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAndroidTypeCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("release");
        jComboBox2.setModel(defaultComboBoxModel2);
        jPanel2.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myIOSTypeCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("test without debugging");
        jComboBox.setModel(defaultComboBoxModel3);
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myApkDebugPortPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myApkDebugPortTextField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("port:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myApkCaptiveRuntimeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Captive runtime");
        jCheckBox2.setMnemonic('R');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIosFastPackagingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Fast packaging");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 2, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myIosTypeLabel = jLabel = new JLabel();
        jLabel.setText("iOS package type (*.ipa):");
        jLabel.setDisplayedMnemonic('I');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jComboBox3);
        jLabel2.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jTextField);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

