/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.actions.ExternalTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AdtException;
import com.intellij.lang.javascript.flex.actions.airpackage.AdtPackageTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AdtTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageAction;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.lang.javascript.flex.actions.airpackage.DeviceInfo;
import com.intellij.lang.javascript.flex.actions.airpackage.PasswordStore;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class AirPackageUtil {
    public static final int DEBUG_PORT_DEFAULT = 7936;
    public static final String TEMP_KEYSTORE_PASSWORD = "keystore_password";
    static final String ADB_RELATIVE_PATH = "/lib/android/bin/adb" + (SystemInfo.isWindows ? ".exe" : "");
    private static final String IDB_RELATIVE_PATH = "/lib/aot/bin/iOSBin/idb" + (SystemInfo.isWindows ? ".exe" : "");
    private static final String PREFERRED_IOS_DEVICE_ID_PROPERTY = "flex.preferred.ios.device.id";
    private static final String PREFERRED_ANDROID_DEVICE_ID_PROPERTY = "flex.preferred.android.device.id";

    private AirPackageUtil() {
    }

    public static String getTempKeystorePath() {
        return FlexCommonUtils.getPathToBundledJar((String)"temp_keystore.p12");
    }

    @Nullable
    public static String getAdtVersion(Project project, Sdk sdk) {
        final Ref versionRef = new Ref();
        ExternalTask.runWithProgress(new AdtTask(project, sdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-version");
            }

            @Override
            protected boolean checkMessages() {
                if (this.myMessages.size() == 1) {
                    FlexCommonUtils.parseAirVersionFromAdtOutput((String)((String)this.myMessages.get(0)), (Ref)versionRef);
                    if (!versionRef.isNull()) {
                        return true;
                    }
                }
                return false;
            }
        }, FlexBundle.message("checking.air.version", new Object[0]), FlexBundle.message("check.air.version.title", new Object[0]));
        return (String)versionRef.get();
    }

    public static String getAirRuntimeVersionOnDevice(Project project, Sdk sdk, final FlashRunnerParameters runnerParameters) throws AdtException {
        final Ref versionRef = new Ref();
        boolean ok = ExternalTask.runWithProgress(new AdtTask(project, sdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-runtimeVersion");
                command.add("-platform");
                command.add("android");
                DeviceInfo device = runnerParameters.getDeviceInfo();
                if (device != null) {
                    command.add("-device");
                    command.add(device.DEVICE_ID);
                }
            }

            @Override
            protected boolean checkMessages() {
                if (this.myMessages.size() == 1) {
                    String output = (String)this.myMessages.get(0);
                    if (output.startsWith("Failed to find package com.adobe.air")) {
                        versionRef.set((Object)"");
                        return true;
                    }
                    if (FlexCommonUtils.AIR_VERSION_PATTERN.matcher(output).matches()) {
                        versionRef.set((Object)output);
                        return true;
                    }
                }
                return false;
            }
        }, FlexBundle.message("checking.air.version", new Object[0]), FlexBundle.message("check.air.version.title", new Object[0]));
        if (!ok) {
            throw new AdtException();
        }
        return (String)versionRef.get();
    }

    public static boolean checkAdtVersionForPackaging(Project project, String actualAdtVersion, String requiredAdtVersion, String sdkName, String errorMessageStart) {
        if (StringUtil.compareVersionNumbers((String)actualAdtVersion, (String)requiredAdtVersion) < 0) {
            Messages.showErrorDialog((Project)project, (String)FlexBundle.message("air.mobile.packaging.version.problem", errorMessageStart, sdkName, actualAdtVersion, requiredAdtVersion), (String)FlexBundle.message("air.mobile.version.problem.title", new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean startAdbServer(Project project, final Sdk sdk) {
        return ExternalTask.runWithProgress(new ExternalTask(project, sdk){

            @Override
            protected List<String> createCommandLine() {
                ArrayList<String> command = new ArrayList<String>();
                command.add(sdk.getHomePath() + ADB_RELATIVE_PATH);
                command.add("start-server");
                return command;
            }

            @Override
            protected void scheduleInputStreamReading() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            this.getProcess().waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.cancel();
                        }
                    }
                });
            }
        }, "adb start-server", "ADB Server Start");
    }

    private static void stopAdbServer(Project project, final Sdk sdk, String progressTitle, String frameTitle) {
        ExternalTask.runWithProgress(new ExternalTask(project, sdk){

            @Override
            protected List<String> createCommandLine() {
                ArrayList<String> command = new ArrayList<String>();
                command.add(sdk.getHomePath() + ADB_RELATIVE_PATH);
                command.add("kill-server");
                return command;
            }

            @Override
            protected boolean checkMessages() {
                return true;
            }
        }, progressTitle, frameTitle);
    }

    public static boolean checkAirRuntimeOnDevice(Project project, Sdk sdk, FlashRunnerParameters runnerParameters, String adtVersion) {
        if (StringUtil.compareVersionNumbers((String)adtVersion, (String)"3.7") >= 0) {
            return true;
        }
        try {
            String airRuntimeVersion = AirPackageUtil.getAirRuntimeVersionOnDevice(project, sdk, runnerParameters);
            String adtVersionTruncated = AirPackageUtil.truncateVersionString(adtVersion);
            String airRuntimeVersionTruncated = AirPackageUtil.truncateVersionString(airRuntimeVersion);
            if (airRuntimeVersion.isEmpty() || StringUtil.compareVersionNumbers((String)adtVersionTruncated, (String)airRuntimeVersionTruncated) > 0) {
                String message = airRuntimeVersion.isEmpty() ? FlexBundle.message("air.runtime.not.installed", sdk.getName(), adtVersionTruncated) : FlexBundle.message("update.air.runtime.question", airRuntimeVersionTruncated, sdk.getName(), adtVersionTruncated);
                int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)FlexBundle.message("air.runtime.version.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (answer == -1) {
                    return false;
                }
                if (answer == 0) {
                    AirPackageUtil.installAirRuntimeOnDevice(project, sdk, runnerParameters.getDeviceInfo(), adtVersionTruncated, !airRuntimeVersion.isEmpty());
                }
            }
            return true;
        }
        catch (AdtException ignore) {
            return false;
        }
    }

    private static String truncateVersionString(String version) {
        int firstDotIndex = version.indexOf(46);
        int secondDotIndex = version.indexOf(46, firstDotIndex + 1);
        int thirdDotIndex = version.indexOf(46, secondDotIndex + 1);
        return thirdDotIndex > 0 ? version.substring(0, thirdDotIndex) : version;
    }

    private static void installAirRuntimeOnDevice(Project project, Sdk sdk, final @Nullable DeviceInfo device, String version, boolean uninstallExistingBeforeInstalling) {
        if (uninstallExistingBeforeInstalling) {
            ExternalTask.runWithProgress(new AdtTask(project, sdk){

                @Override
                protected void appendAdtOptions(List<String> command) {
                    command.add("-uninstallRuntime");
                    command.add("-platform");
                    command.add("android");
                    if (device != null) {
                        command.add("-device");
                        command.add(device.DEVICE_ID);
                    }
                }
            }, FlexBundle.message("uninstalling.air.runtime", new Object[0]), FlexBundle.message("uninstall.air.runtime.title", new Object[0]));
        }
        ExternalTask.runWithProgress(new AdtTask(project, sdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-installRuntime");
                command.add("-platform");
                command.add("android");
                if (device != null) {
                    command.add("-device");
                    command.add(device.DEVICE_ID);
                }
            }
        }, FlexBundle.message("installing.air.runtime", version), FlexBundle.message("install.air.runtime.title", new Object[0]));
    }

    public static boolean packageApk(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, boolean isDebug) {
        PasswordStore passwords;
        AndroidPackagingOptions packagingOptions = bc.getAndroidPackagingOptions();
        boolean tempCertificate = packagingOptions.getSigningOptions().isUseTempCertificate();
        PasswordStore passwordStore = passwords = tempCertificate ? null : AirPackageAction.getPasswords(module.getProject(), Collections.singletonList(packagingOptions));
        if (!tempCertificate && passwords == null) {
            return false;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AirPackageProjectParameters.AndroidPackageType packageType = isDebug ? (runnerParameters.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.Network ? AirPackageProjectParameters.AndroidPackageType.DebugOverNetwork : AirPackageProjectParameters.AndroidPackageType.DebugOverUSB) : AirPackageProjectParameters.AndroidPackageType.Release;
        ExternalTask task = AirPackageUtil.createAndroidPackageTask(module, bc, packageType, false, runnerParameters.getUsbDebugPort(), passwords);
        return ExternalTask.runWithProgress(task, FlexBundle.message("creating.android.package", new Object[0]), FlexBundle.message("create.android.package.title", new Object[0]));
    }

    public static boolean packageIpaForSimulator(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, boolean isDebug) {
        FileDocumentManager.getInstance().saveAllDocuments();
        AirPackageProjectParameters.IOSPackageType packageType = isDebug ? AirPackageProjectParameters.IOSPackageType.DebugOnSimulator : AirPackageProjectParameters.IOSPackageType.TestOnSimulator;
        ExternalTask task = AirPackageUtil.createIOSPackageTask(module, bc, packageType, true, runnerParameters.getIOSSimulatorSdkPath(), 0, null);
        return ExternalTask.runWithProgress(task, FlexBundle.message("creating.ios.package", new Object[0]), FlexBundle.message("create.ios.package.title", new Object[0]));
    }

    public static boolean packageIpaForDevice(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, String adtVersion, boolean isDebug) {
        IosPackagingOptions packagingOptions = bc.getIosPackagingOptions();
        PasswordStore passwords = AirPackageAction.getPasswords(module.getProject(), Collections.singletonList(packagingOptions));
        if (passwords == null) {
            return false;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AirPackageProjectParameters.IOSPackageType packageType = isDebug ? (runnerParameters.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.Network ? AirPackageProjectParameters.IOSPackageType.DebugOverNetwork : AirPackageProjectParameters.IOSPackageType.DebugOverUSB) : AirPackageProjectParameters.IOSPackageType.Test;
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        if (packageType == AirPackageProjectParameters.IOSPackageType.DebugOverUSB && !AirPackageUtil.checkAdtVersionForPackaging(module.getProject(), adtVersion, "3.4", sdk.getName(), FlexBundle.message("air.ios.debug.via.usb.requires.3.4", new Object[0]))) {
            return false;
        }
        if (runnerParameters.isFastPackaging() && !AirPackageUtil.checkAdtVersionForPackaging(module.getProject(), adtVersion, "2.7", sdk.getName(), FlexBundle.message("air.mobile.ios.fast.packaging.requires.2.7", new Object[0]))) {
            return false;
        }
        if (!AirPackageUtil.checkAdtVersionForPackaging(module.getProject(), adtVersion, "2.6", sdk.getName(), FlexBundle.message("air.mobile.packaging.requires.2.6", new Object[0]))) {
            return false;
        }
        ExternalTask task = AirPackageUtil.createIOSPackageTask(module, bc, packageType, runnerParameters.isFastPackaging(), bc.getIosPackagingOptions().getSigningOptions().getIOSSdkPath(), runnerParameters.getUsbDebugPort(), passwords);
        return ExternalTask.runWithProgress(task, FlexBundle.message("creating.ios.package", new Object[0]), FlexBundle.message("create.ios.package.title", new Object[0]));
    }

    public static ExternalTask createAirDesktopTask(final Module module, final FlexBuildConfiguration bc, final AirPackageProjectParameters.DesktopPackageType packageType, PasswordStore passwords) {
        final AirDesktopPackagingOptions packagingOptions = bc.getAirDesktopPackagingOptions();
        AirSigningOptions signingOptions = packagingOptions.getSigningOptions();
        boolean tempCertificate = signingOptions.isUseTempCertificate();
        final String keystorePassword = tempCertificate ? TEMP_KEYSTORE_PASSWORD : passwords.getKeystorePassword(signingOptions.getKeystorePath());
        final String keyPassword = tempCertificate || signingOptions.getKeyAlias().isEmpty() ? "" : passwords.getKeyPassword(signingOptions.getKeystorePath(), signingOptions.getKeyAlias());
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String packageFilePath = outputFolder + "/" + packagingOptions.getPackageFileName() + packageType.getFileExtension();
        return new AdtPackageTask(module.getProject(), bc.getSdk(), packageFilePath){

            @Override
            protected void appendAdtOptions(List<String> command) {
                switch (packageType) {
                    case AirInstaller: {
                        command.add("-package");
                        7.appendSigningOptions(command, packagingOptions, keystorePassword, keyPassword);
                        break;
                    }
                    case NativeInstaller: {
                        command.add("-package");
                        7.appendSigningOptions(command, packagingOptions, keystorePassword, keyPassword);
                        command.add("-target");
                        command.add("native");
                        break;
                    }
                    case CaptiveRuntimeBundle: {
                        command.add("-package");
                        7.appendSigningOptions(command, packagingOptions, keystorePassword, keyPassword);
                        command.add("-target");
                        command.add("bundle");
                        break;
                    }
                    case Airi: {
                        command.add("-prepare");
                    }
                }
                7.appendPaths(command, module, bc, packagingOptions, null, packageType.getFileExtension());
            }
        };
    }

    public static ExternalTask createAndroidPackageTask(final Module module, final FlexBuildConfiguration bc, final AirPackageProjectParameters.AndroidPackageType packageType, final boolean captiveRuntime, final int debugPort, PasswordStore passwords) {
        final AndroidPackagingOptions packagingOptions = bc.getAndroidPackagingOptions();
        AirSigningOptions signingOptions = packagingOptions.getSigningOptions();
        boolean tempCertificate = signingOptions.isUseTempCertificate();
        final String keystorePassword = tempCertificate ? TEMP_KEYSTORE_PASSWORD : passwords.getKeystorePassword(signingOptions.getKeystorePath());
        final String keyPassword = tempCertificate || signingOptions.getKeyAlias().isEmpty() ? "" : passwords.getKeyPassword(signingOptions.getKeystorePath(), signingOptions.getKeyAlias());
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String packageFilePath = outputFolder + "/" + packagingOptions.getPackageFileName() + ".apk";
        return new AdtPackageTask(module.getProject(), bc.getSdk(), packageFilePath){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-package");
                command.add("-target");
                switch (packageType) {
                    case Release: {
                        command.add(captiveRuntime ? "apk-captive-runtime" : "apk");
                        break;
                    }
                    case DebugOverNetwork: {
                        command.add("apk-debug");
                        command.add("-connect");
                        break;
                    }
                    case DebugOverUSB: {
                        command.add("apk-debug");
                        command.add("-listen");
                        command.add(String.valueOf(debugPort));
                    }
                }
                if (!"armv7".equals(packagingOptions.getSigningOptions().getArch())) {
                    command.add("-arch");
                    command.add(packagingOptions.getSigningOptions().getArch());
                }
                8.appendSigningOptions(command, packagingOptions, keystorePassword, keyPassword);
                8.appendPaths(command, module, bc, packagingOptions, null, ".apk");
            }
        };
    }

    public static ExternalTask createIOSPackageTask(final Module module, final FlexBuildConfiguration bc, final AirPackageProjectParameters.IOSPackageType packageType, final boolean fastPackaging, final String iosSDKPath, final int usbDebugPort, PasswordStore passwords) {
        final IosPackagingOptions packagingOptions = bc.getIosPackagingOptions();
        final AirSigningOptions signingOptions = packagingOptions.getSigningOptions();
        final boolean simulator = packageType == AirPackageProjectParameters.IOSPackageType.TestOnSimulator || packageType == AirPackageProjectParameters.IOSPackageType.DebugOnSimulator;
        final String keystorePassword = simulator ? TEMP_KEYSTORE_PASSWORD : passwords.getKeystorePassword(signingOptions.getKeystorePath());
        final String keyPassword = simulator ? null : passwords.getKeyPassword(signingOptions.getKeystorePath(), signingOptions.getKeyAlias());
        String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
        String packageFilePath = outputFolder + "/" + packagingOptions.getPackageFileName() + ".ipa";
        return new AdtPackageTask(module.getProject(), bc.getSdk(), packageFilePath){

            @Override
            protected void appendAdtOptions(List<String> command) {
                List useLegacyAOT;
                List hideAneLibSymbols;
                command.add("-package");
                String adtOptions = packagingOptions.getSigningOptions().getADTOptions();
                if (!adtOptions.isEmpty()) {
                    String undocumentedOptions = FlexCommonUtils.removeOptions((String)adtOptions, (String[])new String[]{"sampler", "hideAneLibSymbols", "useLegacyAOT"});
                    command.addAll(StringUtil.split((String)undocumentedOptions, (String)" "));
                }
                command.add("-target");
                switch (packageType) {
                    case Test: {
                        command.add(fastPackaging ? "ipa-test-interpreter" : "ipa-test");
                        break;
                    }
                    case DebugOverUSB: {
                        command.add(fastPackaging ? "ipa-debug-interpreter" : "ipa-debug");
                        command.add("-listen");
                        command.add(String.valueOf(usbDebugPort));
                        break;
                    }
                    case DebugOverNetwork: {
                        command.add(fastPackaging ? "ipa-debug-interpreter" : "ipa-debug");
                        command.add("-connect");
                        break;
                    }
                    case TestOnSimulator: {
                        command.add("ipa-test-interpreter-simulator");
                        break;
                    }
                    case DebugOnSimulator: {
                        command.add("ipa-debug-interpreter-simulator");
                        break;
                    }
                    case AdHoc: {
                        command.add("ipa-ad-hoc");
                        break;
                    }
                    case AppStore: {
                        command.add("ipa-app-store");
                    }
                }
                if (!adtOptions.isEmpty() && (adtOptions.equals("-sampler") || adtOptions.startsWith("-sampler ") || adtOptions.endsWith(" -sampler") || adtOptions.contains(" -sampler "))) {
                    command.add("-sampler");
                }
                if (!(hideAneLibSymbols = FlexCommonUtils.getOptionValues((String)adtOptions, (String[])new String[]{"hideAneLibSymbols"})).isEmpty()) {
                    command.add("-hideAneLibSymbols");
                    command.add((String)hideAneLibSymbols.get(0));
                }
                if (!(useLegacyAOT = FlexCommonUtils.getOptionValues((String)adtOptions, (String[])new String[]{"useLegacyAOT"})).isEmpty()) {
                    command.add("-useLegacyAOT");
                    command.add((String)useLegacyAOT.get(0));
                }
                if (simulator) {
                    command.add("-storetype");
                    command.add("PKCS12");
                    command.add("-keystore");
                    command.add(AirPackageUtil.getTempKeystorePath());
                    command.add("-storepass");
                    command.add(AirPackageUtil.TEMP_KEYSTORE_PASSWORD);
                } else {
                    9.appendSigningOptions(command, packagingOptions, keystorePassword, keyPassword);
                }
                if (!simulator) {
                    command.add("-provisioning-profile");
                    command.add(FileUtil.toSystemDependentName((String)signingOptions.getProvisioningProfilePath()));
                }
                9.appendPaths(command, module, bc, packagingOptions, iosSDKPath, ".ipa");
            }
        };
    }

    public static boolean installApk(Project project, Sdk flexSdk, final @Nullable DeviceInfo device, final String apkPath, String applicationId) {
        return AirPackageUtil.uninstallAndroidApplication(project, flexSdk, device, applicationId) && ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-installApp");
                command.add("-platform");
                command.add("android");
                if (device != null) {
                    command.add("-device");
                    command.add(device.DEVICE_ID);
                }
                command.add("-package");
                command.add(apkPath);
            }
        }, FlexBundle.message("installing.0", apkPath.substring(apkPath.lastIndexOf(47) + 1)), FlexBundle.message("install.android.application.title", new Object[0]));
    }

    public static boolean installOnIosSimulator(Project project, Sdk flexSdk, final String ipaPath, String applicationId, final String iOSSdkPath) {
        return AirPackageUtil.uninstallFromIosSimulator(project, flexSdk, applicationId, iOSSdkPath) && ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-installApp");
                command.add("-platform");
                command.add("ios");
                command.add("-platformsdk");
                command.add(iOSSdkPath);
                command.add("-device");
                command.add("ios-simulator");
                command.add("-package");
                command.add(ipaPath);
            }
        }, FlexBundle.message("installing.0", ipaPath.substring(ipaPath.lastIndexOf(47) + 1)), FlexBundle.message("install.ipa.on.simulator.title", new Object[0]));
    }

    public static boolean installOnIosDevice(Project project, Sdk flexSdk, final FlashRunnerParameters runnerParameters, final String ipaPath) {
        return ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-installApp");
                command.add("-platform");
                command.add("ios");
                DeviceInfo device = runnerParameters.getDeviceInfo();
                if (device != null) {
                    command.add("-device");
                    command.add(String.valueOf(device.IOS_HANDLE));
                }
                command.add("-package");
                command.add(ipaPath);
            }
        }, FlexBundle.message("installing.0", ipaPath.substring(ipaPath.lastIndexOf(47) + 1)), FlexBundle.message("install.ios.app.title", new Object[0]));
    }

    public static boolean scanIosDevices(Project project, Sdk flexSdk, BCBasedRunnerParameters runnerParameters) {
        int choice;
        List<DeviceInfo> devices = DeviceInfo.getIosDevices(project, flexSdk);
        if (devices.isEmpty()) {
            int choice2 = Messages.showYesNoDialog((Project)project, (String)"No iOS devices connected to the computer", (String)"Error", (String)"Scan Again", (String)"Cancel", (Icon)Messages.getErrorIcon());
            return choice2 == 0 && AirPackageUtil.scanIosDevices(project, flexSdk, runnerParameters);
        }
        if (devices.size() == 1) {
            runnerParameters.setDeviceInfo(devices.get(0));
            return true;
        }
        String preferredId = PropertiesComponent.getInstance((Project)project).getValue(PREFERRED_IOS_DEVICE_ID_PROPERTY);
        String preferredPresentableName = null;
        ArrayList<String> presentableNames = new ArrayList<String>();
        for (DeviceInfo device : devices) {
            StringBuilder presentableName = new StringBuilder();
            if (device.DEVICE_NAME != null && device.IOS_DEVICE_CLASS != null && !device.DEVICE_NAME.contains(device.IOS_DEVICE_CLASS)) {
                presentableName.append(device.IOS_DEVICE_CLASS).append(' ');
            }
            if (device.DEVICE_NAME != null) {
                presentableName.append('\'').append(device.DEVICE_NAME).append("' ");
            }
            presentableName.append('(').append(device.DEVICE_ID.substring(0, 6)).append("...").append(device.DEVICE_ID.substring(36)).append(')');
            if (device.DEVICE_ID.equals(preferredId)) {
                preferredPresentableName = presentableName.toString();
            }
            presentableNames.add(presentableName.toString());
        }
        if (preferredPresentableName == null) {
            preferredPresentableName = (String)presentableNames.iterator().next();
        }
        if ((choice = Messages.showChooseDialog((Project)project, (String)"Select iOS device", (String)"iOS Device", null, (String[])presentableNames.toArray(new String[presentableNames.size()]), (String)preferredPresentableName)) == -1) {
            return false;
        }
        DeviceInfo selectedDevice = devices.get(choice);
        runnerParameters.setDeviceInfo(selectedDevice);
        PropertiesComponent.getInstance((Project)project).setValue(PREFERRED_IOS_DEVICE_ID_PROPERTY, selectedDevice.DEVICE_ID);
        return true;
    }

    public static boolean scanAndroidDevices(Project project, Sdk flexSdk, BCBasedRunnerParameters runnerParameters) {
        int choice;
        List<DeviceInfo> devices = DeviceInfo.getAndroidDevices(project, flexSdk);
        if (devices.isEmpty()) {
            int choice2 = Messages.showYesNoDialog((Project)project, (String)"No Android devices connected to the computer", (String)"Error", (String)"Scan Again", (String)"Cancel", (Icon)Messages.getErrorIcon());
            return choice2 == 0 && AirPackageUtil.scanAndroidDevices(project, flexSdk, runnerParameters);
        }
        if (devices.size() == 1) {
            runnerParameters.setDeviceInfo(devices.get(0));
            return true;
        }
        String preferredId = PropertiesComponent.getInstance((Project)project).getValue(PREFERRED_ANDROID_DEVICE_ID_PROPERTY);
        String preferredPresentableName = null;
        ArrayList<String> presentableNames = new ArrayList<String>();
        for (DeviceInfo device : devices) {
            StringBuilder presentableName = new StringBuilder();
            if (!"device".equals(device.DEVICE_NAME)) {
                presentableName.append(device.DEVICE_NAME).append(' ');
                presentableName.append('(').append(device.DEVICE_ID).append(')');
            } else {
                presentableName.append(device.DEVICE_ID);
            }
            if (device.DEVICE_ID.equals(preferredId)) {
                preferredPresentableName = presentableName.toString();
            }
            presentableNames.add(presentableName.toString());
        }
        if (preferredPresentableName == null) {
            preferredPresentableName = (String)presentableNames.iterator().next();
        }
        if ((choice = Messages.showChooseDialog((Project)project, (String)"Select Android device", (String)"Android Device", null, (String[])presentableNames.toArray(new String[presentableNames.size()]), (String)preferredPresentableName)) == -1) {
            return false;
        }
        DeviceInfo selectedDevice = devices.get(choice);
        runnerParameters.setDeviceInfo(selectedDevice);
        PropertiesComponent.getInstance((Project)project).setValue(PREFERRED_ANDROID_DEVICE_ID_PROPERTY, selectedDevice.DEVICE_ID);
        return true;
    }

    private static boolean uninstallFromIosSimulator(Project project, Sdk sdk, final String applicationId, final String iOSSdkPath) {
        return ExternalTask.runWithProgress(new AdtTask(project, sdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-uninstallApp");
                command.add("-platform");
                command.add("ios");
                command.add("-platformsdk");
                command.add(iOSSdkPath);
                command.add("-device");
                command.add("ios-simulator");
                command.add("-appid");
                command.add(applicationId);
            }

            @Override
            protected boolean checkMessages() {
                return this.myMessages.isEmpty() || this.myMessages.size() == 1 && (((String)this.myMessages.get(0)).startsWith("Application is not installed") || ((String)this.myMessages.get(0)).equals("Failed to find package " + applicationId));
            }
        }, FlexBundle.message("uninstalling.0", applicationId), FlexBundle.message("uninstall.ios.simulator.application.title", new Object[0]));
    }

    private static boolean uninstallAndroidApplication(Project project, Sdk flexSdk, final @Nullable DeviceInfo device, final String applicationId) {
        return ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-uninstallApp");
                command.add("-platform");
                command.add("android");
                if (device != null) {
                    command.add("-device");
                    command.add(device.DEVICE_ID);
                }
                command.add("-appid");
                command.add(applicationId);
            }

            @Override
            protected boolean checkMessages() {
                return this.myMessages.isEmpty() || this.myMessages.size() == 1 && ((String)this.myMessages.get(0)).equals("Failed to find package " + applicationId);
            }
        }, FlexBundle.message("uninstalling.0", applicationId), FlexBundle.message("uninstall.android.application.title", new Object[0]));
    }

    public static boolean launchAndroidApplication(Project project, Sdk flexSdk, final @Nullable DeviceInfo device, final String applicationId) {
        return ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-launchApp");
                command.add("-platform");
                command.add("android");
                if (device != null) {
                    command.add("-device");
                    command.add(device.DEVICE_ID);
                }
                command.add("-appid");
                command.add(applicationId);
            }
        }, FlexBundle.message("launching.android.application", applicationId), FlexBundle.message("launch.android.application.title", new Object[0]));
    }

    public static boolean launchOnIosSimulator(Project project, Sdk flexSdk, final String applicationId, final String iOSSdkPath) {
        return ExternalTask.runWithProgress(new AdtTask(project, flexSdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-launchApp");
                command.add("-platform");
                command.add("ios");
                command.add("-platformsdk");
                command.add(iOSSdkPath);
                command.add("-device");
                command.add("ios-simulator");
                command.add("-appid");
                command.add(applicationId);
            }
        }, FlexBundle.message("launching.ios.application", applicationId), FlexBundle.message("launch.ios.application.title", new Object[0]));
    }

    public static boolean androidForwardTcpPort(Project project, final Sdk sdk, final @Nullable DeviceInfo device, final int usbDebugPort) {
        return ExternalTask.runWithProgress(new ExternalTask(project, sdk){

            @Override
            protected List<String> createCommandLine() {
                ArrayList<String> command = new ArrayList<String>();
                command.add(sdk.getHomePath() + ADB_RELATIVE_PATH);
                if (device != null) {
                    command.add("-s");
                    command.add(device.DEVICE_ID);
                }
                command.add("forward");
                command.add("tcp:" + usbDebugPort);
                command.add("tcp:" + usbDebugPort);
                return command;
            }
        }, "adb forward tcp:" + usbDebugPort + " tcp:" + usbDebugPort, FlexBundle.message("adb.forward.title", new Object[0]));
    }

    public static boolean iosForwardTcpPort(Project project, Sdk sdk, int usbDebugPort, int deviceHandle) {
        AirPackageUtil.stopAdbServer(project, sdk, FlexBundle.message("idb.forward", new Object[0]), FlexBundle.message("idb.forward.title", new Object[0]));
        try {
            Runtime.getRuntime().exec(new String[]{sdk.getHomePath() + IDB_RELATIVE_PATH, "-forward", String.valueOf(usbDebugPort), String.valueOf(usbDebugPort), String.valueOf(deviceHandle)});
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)("idb -forward " + usbDebugPort + " " + usbDebugPort + " " + deviceHandle));
            return false;
        }
        return true;
    }

    public static void iosStopForwardTcpPort(Sdk sdk, int usbDebugPort) {
        try {
            Runtime.getRuntime().exec(new String[]{sdk.getHomePath() + IDB_RELATIVE_PATH, "-stopforward", String.valueOf(usbDebugPort)});
        }
        catch (IOException e) {
            Logger.getInstance((String)AirPackageUtil.class.getName()).warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getAppIdFromPackage(String packagePath) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(packagePath);
            ZipEntry entry = zipFile.getEntry("assets/META-INF/AIR/application.xml");
            if (entry != null) {
                String string = FlexUtils.findXMLElement(zipFile.getInputStream(entry), "<application><id>");
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

