/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.ide.IdeView;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;

public class NewActionScriptClassAction
extends AnAction {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    private boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            Module module;
            if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || DirectoryIndex.getInstance((Project)dir.getProject()).getPackageName(dir.getVirtualFile()) == null || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dir)) == null || !this.isAvailableIn(module)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAvailableIn(Module module) {
        return ModuleType.get((Module)module) == FlexModuleType.getInstance();
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                NewActionScriptClassAction.this.createAction(dir).execute();
            }
        }, this.getCommandName(), null);
    }

    protected String getCommandName() {
        return JSBundle.message((String)"new.actionscript.class.command.name", (Object[])new Object[0]);
    }

    protected CreateClassOrInterfaceFix createAction(PsiDirectory dir) {
        return new CreateClassOrInterfaceFix(dir);
    }
}

