/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.lang.javascript.flex.build.CompilerConfigGenerator;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class FlexCompilationTask {
    protected final Module myModule;
    private final String myPresentableName;
    protected final FlexBuildConfiguration myBC;
    protected final Collection<FlexBuildConfiguration> myDependencies;
    private List<VirtualFile> myConfigFiles;
    protected boolean myFinished;
    protected boolean myCompilationFailed;

    protected FlexCompilationTask(Module module, FlexBuildConfiguration bc, Collection<FlexBuildConfiguration> dependencies) {
        this.myModule = module;
        this.myBC = bc;
        this.myDependencies = dependencies;
        this.myPresentableName = FlexCompilationTask.getPresentableName(module, bc);
    }

    public static String getPresentableName(Module module, FlexBuildConfiguration bc) {
        String postfix;
        String string = postfix = bc.isTempBCForCompilation() ? " - " + BCUtils.getBCSpecifier(bc) : "";
        if (!bc.getName().equals(module.getName())) {
            postfix = postfix + " (module " + module.getName() + ")";
        }
        return bc.getName() + postfix;
    }

    public void start(FlexCompilationManager compilationManager) {
        try {
            this.myConfigFiles = this.createConfigFiles();
            String outputFilePath = this.myBC.getActualOutputFilePath();
            if (compilationManager.isRebuild()) {
                FlexCompilationUtils.deleteCacheForFile(outputFilePath);
            }
            FlexCompilationUtils.ensureOutputFileWritable(this.myModule.getProject(), outputFilePath);
            this.doStart(compilationManager);
        }
        catch (IOException e) {
            compilationManager.addMessage(this, CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            this.myCompilationFailed = true;
            this.cancel();
        }
    }

    protected List<VirtualFile> createConfigFiles() throws IOException {
        ArrayList<VirtualFile> configFiles = new ArrayList<VirtualFile>(2);
        configFiles.add(CompilerConfigGenerator.getOrCreateConfigFile(this.myModule, this.myBC));
        String additionalConfigFilePath = this.myBC.getCompilerOptions().getAdditionalConfigFilePath();
        if (!this.myBC.isTempBCForCompilation() && !additionalConfigFilePath.isEmpty()) {
            VirtualFile additionalConfigFile = LocalFileSystem.getInstance().findFileByPath(additionalConfigFilePath);
            if (additionalConfigFile == null) {
                throw new IOException(FlexCommonBundle.message((String)"additional.config.file.not.found.for.bc.0.of.module.1", (Object[])new Object[]{additionalConfigFilePath, this.myBC.getName(), this.myModule.getName()}));
            }
            configFiles.add(additionalConfigFile);
        }
        return configFiles;
    }

    protected abstract void doStart(FlexCompilationManager var1) throws IOException;

    public void cancel() {
        this.doCancel();
        this.myFinished = true;
    }

    protected abstract void doCancel();

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean isCompilationFailed() {
        return this.myCompilationFailed;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public Module getModule() {
        return this.myModule;
    }

    public List<VirtualFile> getConfigFiles() {
        return this.myConfigFiles;
    }

    public FlexBuildConfiguration getBC() {
        return this.myBC;
    }

    public Collection<FlexBuildConfiguration> getDependencies() {
        return this.myDependencies;
    }
}

