/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.ServerConnectionBase;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.UIBundle;
import com.intellij.util.ResourceUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class FlexUnitPrecompileTask
implements CompileTask {
    public static final Key<Collection<String>> FILES_TO_DELETE = Key.create((String)"FlexUnitPrecompileTask.filesToRemove");
    private final Project myProject;
    private static final String TEST_RUNNER_VAR = "__testRunner";
    private static final int FLEX_UNIT_PORT_START = 7832;
    private static final int PORTS_ATTEMPT_NUMBER = 20;
    private static final int SWC_POLICY_PORT_START = 7852;

    public FlexUnitPrecompileTask(Project project) {
        this.myProject = project;
    }

    public static String getPathToFlexUnitTempDirectory(Project project) {
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(project);
        if (projectSystemDir == null) {
            Logger.getInstance((String)FlexUnitPrecompileTask.class.getName()).error((Object)project);
            return "";
        }
        return FileUtil.toSystemIndependentName((String)projectSystemDir.getPath()) + "/tmp";
    }

    public boolean execute(CompileContext context) {
        boolean desktop;
        String launcherText;
        boolean flexUnit4;
        final RunConfiguration runConfiguration = CompileStepBeforeRun.getRunConfiguration((CompileScope)context.getCompileScope());
        if (!(runConfiguration instanceof FlexUnitRunConfiguration)) {
            return true;
        }
        final Ref isDumb = new Ref((Object)false);
        RuntimeConfigurationException validationError = (RuntimeConfigurationException)((Object)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<RuntimeConfigurationException>(){

            public RuntimeConfigurationException compute() {
                if (DumbService.getInstance((Project)FlexUnitPrecompileTask.this.myProject).isDumb()) {
                    isDumb.set((Object)true);
                    return null;
                }
                try {
                    runConfiguration.checkConfiguration();
                    return null;
                }
                catch (RuntimeConfigurationException e) {
                    return e;
                }
            }
        }));
        if (((Boolean)isDumb.get()).booleanValue()) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("dumb.mode.flex.unit.warning", new Object[0]), null, -1, -1);
            return false;
        }
        if (validationError != null) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("configuration.not.valid", validationError.getMessage()), null, -1, -1);
            return false;
        }
        int flexUnitPort = ServerConnectionBase.getFreePort(7832, 20);
        if (flexUnitPort == -1) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("no.free.port", new Object[0]), null, -1, -1);
            return false;
        }
        int socketPolicyPort = SystemInfo.isWindows && ServerConnectionBase.tryPort(843) ? 843 : ServerConnectionBase.getFreePort(7852, 20);
        if (socketPolicyPort == -1) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("no.free.port", new Object[0]), null, -1, -1);
            return false;
        }
        final FlexUnitRunnerParameters params = ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters();
        params.setPort(flexUnitPort);
        params.setSocketPolicyPort(socketPolicyPort);
        final Ref moduleRef = new Ref();
        final Ref bcRef = new Ref();
        final Ref supportRef = new Ref();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (DumbService.getInstance((Project)FlexUnitPrecompileTask.this.myProject).isDumb()) {
                    return;
                }
                try {
                    Pair<Module, FlexBuildConfiguration> moduleAndBC = params.checkAndGetModuleAndBC(FlexUnitPrecompileTask.this.myProject);
                    moduleRef.set(moduleAndBC.first);
                    bcRef.set(moduleAndBC.second);
                    supportRef.set((Object)FlexUnitSupport.getSupport((FlexBuildConfiguration)moduleAndBC.second, (Module)moduleAndBC.first));
                }
                catch (RuntimeConfigurationError e) {
                    throw new RuntimeException(e);
                }
            }
        });
        Module module = (Module)moduleRef.get();
        FlexBuildConfiguration bc = (FlexBuildConfiguration)bcRef.get();
        final FlexUnitSupport support = (FlexUnitSupport)supportRef.get();
        if (bc == null || support == null) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("dumb.mode.flex.unit.warning", new Object[0]), null, -1, -1);
            return false;
        }
        final GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope((Module)module);
        StringBuilder imports = new StringBuilder();
        StringBuilder code = new StringBuilder();
        switch (params.getScope()) {
            case Class: {
                final Ref isFlexUnit1Suite = new Ref();
                final Ref isSuite = new Ref();
                Set customRunners = (Set)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Set<String>>(){

                    public Set<String> compute() {
                        if (DumbService.getInstance((Project)FlexUnitPrecompileTask.this.myProject).isDumb()) {
                            return null;
                        }
                        THashSet result = new THashSet();
                        JSClass clazz = (JSClass)ActionScriptClassResolver.findClassByQNameStatic(params.getClassName(), moduleScope);
                        FlexUnitPrecompileTask.collectCustomRunners((Set)result, clazz, support, null);
                        isFlexUnit1Suite.set((Object)support.isFlexUnit1SuiteSubclass(clazz));
                        isSuite.set((Object)support.isSuite(clazz));
                        return result;
                    }
                });
                if (customRunners == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("dumb.mode.flex.unit.warning", new Object[0]), null, -1, -1);
                    return false;
                }
                flexUnit4 = support.flexUnit4Present && (Boolean)isFlexUnit1Suite.get() == false;
                FlexUnitPrecompileTask.generateImportCode(imports, params.getClassName(), customRunners);
                FlexUnitPrecompileTask.generateTestClassCode(code, params.getClassName(), customRunners, (Boolean)isSuite.get());
                break;
            }
            case Method: {
                Set customRunners = (Set)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Set<String>>(){

                    public Set<String> compute() {
                        if (DumbService.getInstance((Project)FlexUnitPrecompileTask.this.myProject).isDumb()) {
                            return null;
                        }
                        THashSet result = new THashSet();
                        JSClass clazz = (JSClass)ActionScriptClassResolver.findClassByQNameStatic(params.getClassName(), moduleScope);
                        FlexUnitPrecompileTask.collectCustomRunners((Set)result, clazz, support, null);
                        return result;
                    }
                });
                if (customRunners == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("dumb.mode.flex.unit.warning", new Object[0]), null, -1, -1);
                    return false;
                }
                flexUnit4 = support.flexUnit4Present;
                FlexUnitPrecompileTask.generateImportCode(imports, params.getClassName(), customRunners);
                FlexUnitPrecompileTask.generateTestMethodCode(code, params.getClassName(), params.getMethodName(), customRunners);
                break;
            }
            case Package: {
                Collection classes = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Collection<Pair<String, Set<String>>>>(){

                    public Collection<Pair<String, Set<String>>> compute() {
                        if (DumbService.getInstance((Project)FlexUnitPrecompileTask.this.myProject).isDumb()) {
                            return null;
                        }
                        final ArrayList<Pair<String, Set<String>>> result = new ArrayList<Pair<String, Set<String>>>();
                        JSPackageIndex.processElementsInScopeRecursive((String)params.getPackageName(), (JSPackageIndex.PackageQualifiedElementsProcessor)new JSPackageIndex.PackageQualifiedElementsProcessor(){

                            public boolean process(String qualifiedName, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                                PsiElement clazz;
                                if (kind == JSPackageIndexInfo.Kind.CLASS && (clazz = ActionScriptClassResolver.findClassByQNameStatic(qualifiedName, moduleScope)) instanceof JSClass && support.isTestClass((JSClass)clazz, false)) {
                                    THashSet customRunners = new THashSet();
                                    FlexUnitPrecompileTask.collectCustomRunners((Set)customRunners, (JSClass)clazz, support, null);
                                    result.add(Pair.create((Object)((JSClass)clazz).getQualifiedName(), (Object)customRunners));
                                }
                                return true;
                            }
                        }, (GlobalSearchScope)moduleScope, (Project)FlexUnitPrecompileTask.this.myProject);
                        return result;
                    }
                });
                if (classes == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("dumb.mode.flex.unit.warning", new Object[0]), null, -1, -1);
                    return false;
                }
                if (classes.isEmpty()) {
                    String message = MessageFormat.format("No tests found in package ''{0}''", params.getPackageName());
                    context.addMessage(CompilerMessageCategory.WARNING, message, null, -1, -1);
                    return false;
                }
                flexUnit4 = support.flexUnit4Present;
                for (Pair classAndRunner : classes) {
                    FlexUnitPrecompileTask.generateImportCode(imports, (String)classAndRunner.first, (Collection)classAndRunner.second);
                    FlexUnitPrecompileTask.generateTestClassCode(code, (String)classAndRunner.first, (Collection)classAndRunner.second, false);
                }
                break;
            }
            default: {
                flexUnit4 = false;
                assert (false) : "Unknown scope: " + (Object)((Object)params.getScope());
                break;
            }
        }
        if (!flexUnit4 && bc.isPureAs()) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("cant.execute.flexunit1.for.pure.as.bc", new Object[0]), null, -1, -1);
        }
        try {
            launcherText = FlexUnitPrecompileTask.getLauncherTemplate(bc);
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            return false;
        }
        boolean bl = desktop = bc.getTargetPlatform() == TargetPlatform.Desktop;
        if (desktop) {
            FlexUnitPrecompileTask.generateImportCode(imports, "flash.desktop.NativeApplication");
        }
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*imports*/", imports.toString());
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*test_runner*/", flexUnit4 ? "com.intellij.flexunit.runner.TestRunner4" : "com.intellij.flexunit.runner.TestRunner1");
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*code*/", code.toString());
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*port*/", String.valueOf(flexUnitPort));
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*socketPolicyPort*/", String.valueOf(socketPolicyPort));
        launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*module*/", module.getName());
        if (!bc.isPureAs()) {
            FlexUnitRunnerParameters.OutputLogLevel logLevel = params.getOutputLogLevel();
            launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*isLogEnabled*/", logLevel != null ? "1" : "0");
            launcherText = FlexUnitPrecompileTask.replace(launcherText, "/*logLevel*/", logLevel != null ? logLevel.getFlexConstant() : FlexUnitRunnerParameters.OutputLogLevel.All.getFlexConstant());
        }
        File tmpDir = new File(FlexUnitPrecompileTask.getPathToFlexUnitTempDirectory(this.myProject));
        boolean ok = true;
        if (tmpDir.isFile()) {
            ok &= FileUtil.delete((File)tmpDir);
        }
        if (!tmpDir.isDirectory()) {
            ok &= tmpDir.mkdirs();
        }
        if (!ok) {
            String message = UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{FileUtil.toSystemDependentName((String)tmpDir.getPath())});
            context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            return false;
        }
        String fileName = "____FlexUnitLauncher" + FlexCommonUtils.getFlexUnitLauncherExtension((BuildConfigurationNature)bc.getNature());
        File launcherFile = new File(tmpDir, fileName);
        FileUtil.delete((File)launcherFile);
        try {
            FileUtil.writeToFile((File)launcherFile, (String)launcherText);
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            return false;
        }
        context.putUserData(FILES_TO_DELETE, Collections.singletonList(launcherFile.getPath()));
        return true;
    }

    private static String replace(String text, String pattern, String replacement) {
        if (!text.contains(pattern)) {
            throw new RuntimeException("Pattern '" + pattern + "' not found in launcher text");
        }
        return text.replace(pattern, replacement);
    }

    private static void collectCustomRunners(Set<String> result, JSClass testClass, FlexUnitSupport flexUnitSupport, @Nullable Collection<JSClass> seen) {
        if (seen != null && seen.contains(testClass)) {
            return;
        }
        String customRunner = FlexUnitSupport.getCustomRunner(testClass);
        if (!StringUtil.isEmptyOrSpaces((String)customRunner)) {
            result.add(customRunner);
        }
        if (flexUnitSupport.isSuite(testClass)) {
            if (seen == null) {
                seen = new THashSet();
            }
            seen.add((JSClass)testClass);
            for (JSClass referencedClass : flexUnitSupport.getSuiteTestClasses(testClass)) {
                FlexUnitPrecompileTask.collectCustomRunners(result, referencedClass, flexUnitSupport, (Collection<JSClass>)seen);
            }
        }
    }

    private static void generateImportCode(StringBuilder imports, String className, Collection<String> customRunners) {
        if (!StringUtil.isEmpty((String)StringUtil.getPackageName((String)className))) {
            FlexUnitPrecompileTask.generateImportCode(imports, className);
        }
        for (String customRunner : customRunners) {
            FlexUnitPrecompileTask.generateImportCode(imports, customRunner);
        }
    }

    private static void generateImportCode(StringBuilder imports, String qname) {
        imports.append("import ").append(qname).append(";\n");
    }

    private static void generateTestMethodCode(StringBuilder code, String className, String methodName, Collection<String> customRunners) {
        code.append(TEST_RUNNER_VAR).append(".addTestMethod(").append(className).append(", \"").append(methodName).append("\");\n");
        FlexUnitPrecompileTask.generateReferences(code, className, customRunners);
    }

    private static void generateTestClassCode(StringBuilder code, String className, Collection<String> customRunners, boolean isSuite) {
        code.append(TEST_RUNNER_VAR).append(".").append(isSuite ? "addTestSuiteClass(" : "addTestClass(").append(className).append(");\n");
        FlexUnitPrecompileTask.generateReferences(code, className, customRunners);
    }

    private static void generateReferences(StringBuilder code, String className, Collection<String> classes) {
        int i = 1;
        for (String qname : classes) {
            code.append("var __ref_").append(className.replace(".", "_")).append("_").append(i++).append("_ : ").append(qname).append(";\n");
        }
    }

    private static String getLauncherTemplate(FlexBuildConfiguration bc) throws IOException {
        String templateName = bc.isPureAs() ? "LauncherTemplateAs.as" : (bc.getNature().isMobilePlatform() || bc.getDependencies().getComponentSet() == ComponentSet.SparkOnly ? "LauncherTemplateSpark.mxml" : "LauncherTemplateMx.mxml");
        URL resource = FlexUnitPrecompileTask.class.getResource("/unittestingsupport/" + templateName);
        return ResourceUtil.loadText((URL)resource);
    }
}

