/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.presentation.FlexClassMemberNode;
import com.intellij.lang.javascript.flex.presentation.FlexStructureViewProvider;
import com.intellij.lang.javascript.flex.presentation.SwfQualifiedNamedElementNode;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.SimpleTextAttributes;
import icons.JavaScriptPsiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final int INTERFACE_VALUE = 10;
    private static final int NAMESPACE_VALUE = 7;
    private static final int FUNCTION_VALUE = 5;
    private static final int VARIABLE_VALUE = 4;
    private static final int CLASS_VALUE = 20;

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/presentation/FlexTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/flex/presentation/FlexTreeStructureProvider", "modify"));
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        if (parent instanceof SwfQualifiedNamedElementNode || parent instanceof FlexFileNode) {
            JSQualifiedNamedElement parentElement;
            if (((ProjectViewNode)parent).getSettings().isShowMembers() && (parentElement = FlexTreeStructureProvider.getElement(parent)) != null) {
                StructureViewTreeElement[] structureViewChildren;
                FlexStructureViewProvider.FlexStructureViewElement structureViewElement = parentElement instanceof XmlBackedJSClassImpl ? new FlexStructureViewProvider.FlexStructureViewElement((JSClass)((XmlBackedJSClassImpl)parentElement), (XmlFile)parentElement.getContainingFile(), false) : new JSStructureViewElement((PsiElement)parentElement, false, true);
                for (StructureViewTreeElement structureViewChild : structureViewChildren = structureViewElement.getChildren()) {
                    if (structureViewChild instanceof JSStructureViewElement) {
                        PsiElement childElement = ((JSStructureViewElement)structureViewChild).getValue();
                        result.add((AbstractTreeNode)new FlexClassMemberNode((JSElement)childElement, ((ProjectViewNode)parent).getSettings()));
                        continue;
                    }
                    result.add((AbstractTreeNode)new UnknownNode(parentElement.getProject(), structureViewChild, ((ProjectViewNode)parent).getSettings()));
                }
            }
        } else {
            for (AbstractTreeNode child : children) {
                Object o = child.getValue();
                if (o instanceof JSFileImpl && !(o instanceof PsiCompiledFile) && DialectDetector.isActionScript((PsiElement)((PsiFile)o)) || o instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)o))) {
                    result.add((AbstractTreeNode)new FlexFileNode((PsiFile)o, ((ProjectViewNode)parent).getSettings()));
                    continue;
                }
                result.add(child);
            }
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/FlexTreeStructureProvider", "modify"));
        }
        return arrayList;
    }

    @Nullable
    private static JSQualifiedNamedElement getElement(AbstractTreeNode parent) {
        if (parent instanceof SwfQualifiedNamedElementNode) {
            return (JSQualifiedNamedElement)parent.getValue();
        }
        PsiFile file = (PsiFile)((FlexFileNode)parent).getValue();
        if (file instanceof JSFileImpl) {
            JSNamedElement element = JSFileImpl.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)file));
            if (element instanceof JSQualifiedNamedElement) {
                return (JSQualifiedNamedElement)element;
            }
        } else if (file instanceof XmlFile) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)file));
        }
        return null;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    public static int getElementWeight(JSElement element) {
        if (element instanceof JSClass) {
            return ((JSClass)element).isInterface() ? 10 : 20;
        }
        if (element instanceof JSVariable) {
            return 4;
        }
        if (element instanceof JSFunction) {
            return 5;
        }
        if (element instanceof JSNamespaceDeclaration) {
            return 7;
        }
        return -1;
    }

    private static class UnknownNode
    extends ProjectViewNode<Object> {
        private final StructureViewTreeElement myElement;

        public UnknownNode(Project project, StructureViewTreeElement element, ViewSettings viewSettings) {
            super(project, element.getValue(), viewSettings);
            this.myElement = element;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/presentation/FlexTreeStructureProvider$UnknownNode", "contains"));
            }
            return false;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/FlexTreeStructureProvider$UnknownNode", "getChildren"));
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            ItemPresentation p = this.myElement.getPresentation();
            presentation.setPresentableText(p.getPresentableText());
            presentation.setIcon(p.getIcon(false));
            presentation.addText(p.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String location = presentation.getLocationString();
            if (!StringUtil.isEmpty((String)location)) {
                presentation.addText(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        public VirtualFile getVirtualFile() {
            Object value = this.getValue();
            return value instanceof PsiElement && ((PsiElement)value).isValid() ? ((PsiElement)value).getContainingFile().getVirtualFile() : null;
        }

        public boolean canNavigate() {
            return this.myElement.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myElement.canNavigateToSource();
        }

        public void navigate(boolean requestFocus) {
            this.myElement.navigate(requestFocus);
        }
    }

    private static class FlexFileNode
    extends PsiFileNode {
        public FlexFileNode(PsiFile value, ViewSettings viewSettings) {
            super(value.getProject(), value, viewSettings);
        }

        protected void updateImpl(PresentationData data) {
            VirtualFile file;
            PsiFile value = (PsiFile)this.getValue();
            String className = null;
            Icon icon = null;
            if (value instanceof JSFileImpl) {
                JSNamedElement element;
                VirtualFile file2 = value.getVirtualFile();
                if (file2 != null && ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(file2) != null && (element = JSFileImpl.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)value))) != null) {
                    className = element.getName();
                    icon = element.getIcon(3);
                }
            } else if (value instanceof XmlFile && (file = value.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(file) != null) {
                className = file.getNameWithoutExtension();
                icon = JavaScriptPsiIcons.Classes.XmlBackedClass;
            }
            if (className != null) {
                data.setPresentableText(className);
                data.setIcon(icon);
                return;
            }
            super.updateImpl(data);
        }

        public int getTypeSortWeight(boolean sortByType) {
            if (sortByType) {
                PsiFile value = (PsiFile)this.getValue();
                if (value instanceof JSFileImpl) {
                    JSNamedElement element = JSFileImpl.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)value));
                    int weight = FlexTreeStructureProvider.getElementWeight((JSElement)element);
                    if (weight != -1) {
                        return weight;
                    }
                } else if (value instanceof XmlFile) {
                    return 20;
                }
            }
            return super.getTypeSortWeight(sortByType);
        }
    }
}

