/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexOrderEnumerationHandler
extends OrderEnumerationHandler {
    public static Key<FlexBuildConfiguration> FORCE_BC = Key.create((String)(FlexOrderEnumerationHandler.class.getName() + ".forceBc"));
    @Nullable
    private final Map<Module, ModuleData> myActiveConfigurations;
    private final Module myRootModule;

    public FlexOrderEnumerationHandler(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "<init>"));
        }
        this.myRootModule = module;
        this.myActiveConfigurations = new HashMap<Module, ModuleData>();
        FlexOrderEnumerationHandler.processModuleWithBuildConfiguration(module, null, this.myActiveConfigurations, new HashSet<FlexBuildConfiguration>(), true);
    }

    private static void processModuleWithBuildConfiguration(@NotNull Module module, @Nullable FlexBuildConfiguration bc, Map<Module, ModuleData> modules2activeConfigurations, Set<FlexBuildConfiguration> processedConfigurations, boolean productionDependency) {
        boolean isRootModule;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "processModuleWithBuildConfiguration"));
        }
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return;
        }
        boolean bl = isRootModule = bc == null;
        if (isRootModule) {
            bc = FlexOrderEnumerationHandler.getActiveConfiguration(module);
        }
        if (bc == null || !processedConfigurations.add(bc)) {
            return;
        }
        ModuleData moduleData = modules2activeConfigurations.get(module);
        if (moduleData == null) {
            moduleData = new ModuleData();
            modules2activeConfigurations.put(module, moduleData);
        }
        moduleData.addBc(bc, productionDependency);
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            Module dependencyModule;
            FlexBuildConfiguration dependencyBc;
            LinkageType linkageType;
            if (!(entry instanceof BuildConfigurationEntry) || (linkageType = entry.getDependencyType().getLinkageType()) == LinkageType.LoadInRuntime || (dependencyBc = ((BuildConfigurationEntry)entry).findBuildConfiguration()) == null || !FlexCommonUtils.checkDependencyType((OutputType)bc.getOutputType(), (OutputType)dependencyBc.getOutputType(), (LinkageType)linkageType) || !isRootModule && !BCUtils.isTransitiveDependency(linkageType) || (dependencyModule = ((BuildConfigurationEntry)entry).findModule()) == null || dependencyModule == module) continue;
            FlexOrderEnumerationHandler.processModuleWithBuildConfiguration(dependencyModule, dependencyBc, modules2activeConfigurations, processedConfigurations, entry.getDependencyType().getLinkageType() != LinkageType.Test);
        }
    }

    private static FlexBuildConfiguration getActiveConfiguration(Module module) {
        FlexBuildConfiguration forced = (FlexBuildConfiguration)FORCE_BC.get((UserDataHolder)module);
        return forced != null ? forced : FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration();
    }

    @NotNull
    public OrderEnumerationHandler.AddDependencyType shouldAddDependency(@NotNull OrderEntry orderEntry, @NotNull OrderEnumeratorSettings settings) {
        ModuleData moduleData;
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
        }
        Module module = orderEntry.getOwnerModule();
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            OrderEnumerationHandler.AddDependencyType addDependencyType = super.shouldAddDependency(orderEntry, settings);
            if (addDependencyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
            }
            return addDependencyType;
        }
        if (orderEntry instanceof ModuleSourceOrderEntry) {
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
            if (addDependencyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
            }
            return addDependencyType;
        }
        if (orderEntry instanceof JdkOrderEntry) {
            if (module != this.myRootModule) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            if (this.myActiveConfigurations == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            ModuleData moduleData2 = this.myActiveConfigurations.get(module);
            for (FlexBuildConfiguration bc : moduleData2.bcs) {
                if (bc.getSdk() == null) continue;
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
            if (addDependencyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
            }
            return addDependencyType;
        }
        Collection<Object> accessibleConfigurations = this.myActiveConfigurations != null ? ((moduleData = this.myActiveConfigurations.get(module)) != null ? moduleData.bcs : Collections.emptyList()) : Arrays.asList(FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations());
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryEx library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            if (library.getKind() == FlexLibraryType.FLEX_LIBRARY) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = FlexProjectRootsUtil.dependOnLibrary(accessibleConfigurations, (Library)library, module != this.myRootModule, settings.isProductionOnly()) ? OrderEnumerationHandler.AddDependencyType.DEFAULT : OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
            if (addDependencyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
            }
            return addDependencyType;
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Module dependencyModule = ((ModuleOrderEntry)orderEntry).getModule();
            if (dependencyModule == null) {
                OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            if (this.myActiveConfigurations != null) {
                ModuleData moduleData3 = this.myActiveConfigurations.get(dependencyModule);
                OrderEnumerationHandler.AddDependencyType addDependencyType = moduleData3 != null && (moduleData3.accessibleInProduction || !settings.isProductionOnly()) ? OrderEnumerationHandler.AddDependencyType.DEFAULT : OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD;
                if (addDependencyType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
                }
                return addDependencyType;
            }
            OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
            if (addDependencyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
            }
            return addDependencyType;
        }
        OrderEnumerationHandler.AddDependencyType addDependencyType = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        if (addDependencyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "shouldAddDependency"));
        }
        return addDependencyType;
    }

    public boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<String> urls) {
        if (forOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forOrderEntry", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (!(forOrderEntry instanceof JdkOrderEntry)) {
            return false;
        }
        if (this.myActiveConfigurations == null) {
            return false;
        }
        Module forModule = forOrderEntry.getOwnerModule();
        final FlexBuildConfiguration bc = FlexOrderEnumerationHandler.getActiveConfiguration(forModule);
        Sdk sdk = bc.getSdk();
        if (sdk == null || sdk.getSdkType() != FlexSdkType2.getInstance()) {
            return false;
        }
        Object[] allUrls = sdk.getRootProvider().getUrls(type);
        if (type != OrderRootType.CLASSES) {
            urls.addAll(Arrays.asList(allUrls));
            return true;
        }
        final List<String> themePaths = BCUtils.getThemes(forModule, bc);
        List allAccessibleUrls = ContainerUtil.filter((Object[])allUrls, (Condition)new Condition<String>(){

            public boolean value(String s) {
                return BCUtils.getSdkEntryLinkageType(s = VirtualFileManager.extractPath((String)StringUtil.trimEnd((String)s, (String)"!/")), bc) != null || themePaths.contains(s);
            }
        });
        urls.addAll(new HashSet(allAccessibleUrls));
        return true;
    }

    private static class ModuleData {
        private Set<FlexBuildConfiguration> bcs = new HashSet<FlexBuildConfiguration>();
        private boolean accessibleInProduction = false;

        private ModuleData() {
        }

        public void addBc(FlexBuildConfiguration bc, boolean production) {
            this.bcs.add(bc);
            this.accessibleInProduction |= production;
        }
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler$FactoryImpl", "isApplicable"));
            }
            return ModuleType.get((Module)module) == FlexModuleType.getInstance();
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexOrderEnumerationHandler$FactoryImpl", "createHandler"));
            }
            return new FlexOrderEnumerationHandler(module);
        }
    }
}

