/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.FlexCompositeSdk;
import com.intellij.lang.javascript.flex.projectStructure.conversion.ConversionParams;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.ConversionHelper;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexLibraryIdGenerator;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

class FlexModuleConverter
extends ConversionProcessor<ModuleSettings> {
    private static final Logger LOG = Logger.getInstance((String)FlexModuleConverter.class.getName());
    private static final String FLEX_FACET_TYPE_ID = "flex";
    @NonNls
    private static final String FLEX_SDK_ATTR_NAME = "flex_sdk";
    private static final String NAMESPACE_AND_MANIFEST_FILE_INFO_LIST_ELEMENT_NAME = "NAMESPACE_AND_MANIFEST_FILE_INFO_LIST";
    private static final String CONDITIONAL_COMPILER_DEFINITION_LIST_ELEMENT_NAME = "CONDITIONAL_COMPILATION_DEFINITION_LIST";
    private static final String CSS_FILES_LIST_ELEMENT_NAME = "CSS_FILES_LIST";
    private static final String FILE_PATH_ELEMENT_NAME = "FILE_PATH";
    private final ConversionParams myParams;

    public FlexModuleConverter(ConversionParams params) {
        this.myParams = params;
    }

    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        return FlexModuleConverter.isConversionNeededStatic(moduleSettings);
    }

    static boolean isConversionNeededStatic(ModuleSettings moduleSettings) {
        if (!FlexModuleConverter.hasFlex(moduleSettings)) {
            return false;
        }
        return moduleSettings.getComponentElement("FlexBuildConfigurationManager") == null;
    }

    static boolean hasFlex(ModuleSettings moduleSettings) {
        return FlexModuleConverter.isFlexModule(moduleSettings) || !FlexModuleConverter.getFlexFacets(moduleSettings).isEmpty();
    }

    public static boolean isFlexModule(ModuleSettings moduleSettings) {
        return "Flex".equals(moduleSettings.getModuleType());
    }

    private static boolean isJavaModule(ModuleSettings module) {
        return StdModuleTypes.JAVA.getId().equals(module.getModuleType());
    }

    public static List<Element> getFlexFacets(ModuleSettings module) {
        if (!FlexModuleConverter.isJavaModule(module)) {
            return Collections.emptyList();
        }
        return new ArrayList<Element>(module.getFacetElements(FLEX_FACET_TYPE_ID));
    }

    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        FlexBuildConfigurationManagerImpl configurationManager = ConversionHelper.createBuildConfigurationManager();
        ArrayList<Element> orderEntriesToAdd = new ArrayList<Element>();
        HashSet<String> usedSdksNames = new HashSet<String>();
        HashSet<Element> usedModuleLibrariesEntries = new HashSet<Element>();
        if (FlexModuleConverter.isFlexModule(moduleSettings)) {
            ModifiableFlexBuildConfiguration newConfiguration = (ModifiableFlexBuildConfiguration)configurationManager.getBuildConfigurations()[0];
            newConfiguration.setName(FlexModuleConverter.generateModuleBcName(moduleSettings));
            Element oldConfigurationElement = moduleSettings.getComponentElement("Flex.Build.Configuration");
            FlexBuildConfiguration oldConfiguration = oldConfigurationElement != null ? (FlexBuildConfiguration)XmlSerializer.deserialize((Element)oldConfigurationElement, FlexBuildConfiguration.class) : null;
            this.processConfiguration(oldConfiguration, newConfiguration, moduleSettings, false, null, usedSdksNames, orderEntriesToAdd, usedModuleLibrariesEntries);
            if (oldConfigurationElement != null) {
                oldConfigurationElement.detach();
            }
        } else {
            List<Element> flexFacets = FlexModuleConverter.getFlexFacets(moduleSettings);
            for (int i = 0; i < flexFacets.size(); ++i) {
                Element facet = flexFacets.get(i);
                ModifiableFlexBuildConfiguration newConfiguration = i == 0 ? (ModifiableFlexBuildConfiguration)configurationManager.getBuildConfigurations()[0] : ConversionHelper.createBuildConfiguration(configurationManager);
                newConfiguration.setName(FlexModuleConverter.generateFacetBcName(flexFacets, facet));
                Element oldConfigurationElement = facet.getChild("configuration");
                if (oldConfigurationElement != null) {
                    FlexBuildConfiguration oldConfiguration = (FlexBuildConfiguration)XmlSerializer.deserialize((Element)oldConfigurationElement, FlexBuildConfiguration.class);
                    try {
                        FlexModuleConverter.readNamespaceAndManifestInfoList(oldConfigurationElement, oldConfiguration);
                        FlexModuleConverter.readConditionalCompilerDefinitionList(oldConfigurationElement, oldConfiguration);
                        FlexModuleConverter.readCssFilesList(oldConfigurationElement, oldConfiguration);
                    }
                    catch (InvalidDataException invalidDataException) {
                        // empty catch block
                    }
                    String facetSdkName = oldConfigurationElement.getAttributeValue(FLEX_SDK_ATTR_NAME);
                    this.processConfiguration(oldConfiguration, newConfiguration, moduleSettings, true, facetSdkName, usedSdksNames, orderEntriesToAdd, usedModuleLibrariesEntries);
                    continue;
                }
                this.processConfiguration(null, newConfiguration, moduleSettings, true, null, usedSdksNames, orderEntriesToAdd, usedModuleLibrariesEntries);
            }
            moduleSettings.setModuleType("Flex");
            moduleSettings.getComponentElement("FacetManager").getChildren("facet").removeAll(flexFacets);
        }
        ArrayList<Element> allEntries = new ArrayList<Element>();
        allEntries.addAll(usedModuleLibrariesEntries);
        allEntries.addAll(orderEntriesToAdd);
        for (Element orderEntry : allEntries) {
            if (DependencyScope.readExternal((Element)orderEntry) != DependencyScope.TEST) continue;
            orderEntry.removeAttribute("scope");
        }
        if (!usedSdksNames.isEmpty()) {
            Element sdkEntryElement = new Element("orderEntry");
            sdkEntryElement.setAttribute("type", "jdk");
            String compositeSdkName = FlexCompositeSdk.getCompositeName(ArrayUtil.toStringArray(usedSdksNames));
            sdkEntryElement.setAttribute("jdkName", compositeSdkName);
            sdkEntryElement.setAttribute("jdkType", "__CompositeFlexSdk__");
            moduleSettings.getOrderEntries().add(sdkEntryElement);
        }
        Element rootManagerElement = JDomSerializationUtil.findOrCreateComponentElement((Element)moduleSettings.getRootElement(), (String)"NewModuleRootManager");
        rootManagerElement.addContent(orderEntriesToAdd);
        Element componentElement = JDomSerializationUtil.findOrCreateComponentElement((Element)moduleSettings.getRootElement(), (String)"FlexBuildConfigurationManager");
        FlexModuleConverter.addContent(ConversionHelper.serialize(configurationManager), componentElement);
        this.ignoreInapplicableFacets(moduleSettings);
    }

    private void ignoreInapplicableFacets(ModuleSettings module) {
        boolean allowFlexFacets = FlexModuleConverter.isJavaModule(module);
        Element facetManager = module.getComponentElement("FacetManager");
        for (Element facet : JDOMUtil.getChildren((Element)facetManager, (String)"facet")) {
            String type = facet.getAttributeValue("type");
            if (allowFlexFacets && FLEX_FACET_TYPE_ID.equals(type)) continue;
            String name = facet.getAttributeValue("name");
            this.myParams.ignoreInvalidFacet(module.getModuleName(), type, name);
        }
    }

    private void processConfiguration(@Nullable FlexBuildConfiguration oldConfiguration, ModifiableFlexBuildConfiguration newBuildConfiguration, final ModuleSettings module, boolean facet, @Nullable String facetSdkName, Set<String> usedSdksNames, Collection<Element> orderEntriesToAdd, Set<Element> usedModuleLibrariesEntries) throws CannotConvertException {
        if (oldConfiguration == null) {
            newBuildConfiguration.setOutputType(OutputType.Application);
        } else {
            if ("Library".equals(oldConfiguration.OUTPUT_TYPE)) {
                newBuildConfiguration.setOutputType(OutputType.Library);
            } else {
                newBuildConfiguration.setOutputType(OutputType.Application);
            }
            if (newBuildConfiguration.getOutputType() == OutputType.Application) {
                newBuildConfiguration.setMainClass(oldConfiguration.MAIN_CLASS);
                this.myParams.addAppModuleAndBCName(module.getModuleName(), newBuildConfiguration.getName());
            }
            newBuildConfiguration.setOutputFileName(oldConfiguration.OUTPUT_FILE_NAME);
            newBuildConfiguration.setSkipCompile(!oldConfiguration.DO_BUILD);
            ModifiableCompilerOptions newCompilerOptions = newBuildConfiguration.getCompilerOptions();
            newCompilerOptions.setAllOptions(FlexModuleConverter.convertCompilerOptions(oldConfiguration, module, newCompilerOptions));
        }
        String outputFolder = facet && oldConfiguration != null && oldConfiguration.USE_FACET_COMPILE_OUTPUT_PATH ? PathUtil.getCanonicalPath((String)module.expandPath(oldConfiguration.FACET_COMPILE_OUTPUT_PATH)) : FlexModuleConverter.getOutputFolder(module);
        newBuildConfiguration.setOutputFolder(outputFolder);
        ArrayList<Element> orderEntriesToRemove = new ArrayList<Element>();
        for (Element orderEntry : module.getOrderEntries()) {
            String orderEntryType = orderEntry.getAttributeValue("type");
            if ("module-library".equals(orderEntryType)) {
                Element libraryProperties;
                Element library = orderEntry.getChild("library");
                if (!FlexModuleConverter.isApplicableLibrary(library, new Function<String, String>(){

                    public String fun(String s) {
                        return module.expandPath(s);
                    }
                })) {
                    orderEntriesToRemove.add(orderEntry);
                    continue;
                }
                if (facet && FlexModuleConverter.isAutogeneratedLibrary(library)) {
                    orderEntriesToRemove.add(orderEntry);
                    continue;
                }
                if (!usedModuleLibrariesEntries.add(orderEntry)) {
                    Element newEntry = orderEntry.clone();
                    orderEntriesToAdd.add(newEntry);
                    library = orderEntry.getChild("library");
                    libraryProperties = library.getChild("properties");
                } else {
                    library.setAttribute("type", FlexLibraryType.FLEX_LIBRARY.getKindId());
                    libraryProperties = new Element("properties");
                    library.getChildren().add(0, libraryProperties);
                }
                String libraryId = FlexLibraryIdGenerator.generateId();
                XmlSerializer.serializeInto((Object)((Object)new FlexLibraryProperties(libraryId)), (Element)libraryProperties);
                ModifiableModuleLibraryEntry moduleLibraryEntry = ConversionHelper.createModuleLibraryEntry(libraryId);
                FlexModuleConverter.convertDependencyType(orderEntry, (ModifiableDependencyType)moduleLibraryEntry.getDependencyType());
                newBuildConfiguration.getDependencies().getModifiableEntries().add(moduleLibraryEntry);
                continue;
            }
            if ("library".equals(orderEntryType)) {
                String libraryLevel;
                String libraryName = orderEntry.getAttributeValue("name");
                if (this.myParams.libraryExists(libraryName, libraryLevel = orderEntry.getAttributeValue("level"))) {
                    this.myParams.changeLibraryTypeToFlex(libraryName, libraryLevel);
                    ModifiableSharedLibraryEntry sharedLibraryEntry = ConversionHelper.createSharedLibraryEntry(libraryName, libraryLevel);
                    FlexModuleConverter.convertDependencyType(orderEntry, (ModifiableDependencyType)sharedLibraryEntry.getDependencyType());
                    newBuildConfiguration.getDependencies().getModifiableEntries().add(sharedLibraryEntry);
                    continue;
                }
                orderEntriesToRemove.add(orderEntry);
                continue;
            }
            if ("module".equals(orderEntryType)) {
                String moduleName = orderEntry.getAttributeValue("module-name");
                Collection<String> bcNames = this.myParams.getBcNamesForDependency(moduleName, newBuildConfiguration.getNature());
                for (String bcName : bcNames) {
                    ModifiableBuildConfigurationEntry bcEntry = ConversionHelper.createBuildConfigurationEntry(moduleName, bcName);
                    FlexModuleConverter.convertDependencyType(orderEntry, (ModifiableDependencyType)bcEntry.getDependencyType());
                    newBuildConfiguration.getDependencies().getModifiableEntries().add(bcEntry);
                }
                if (!bcNames.isEmpty()) continue;
                orderEntriesToRemove.add(orderEntry);
                continue;
            }
            if ("jdk".equals(orderEntryType)) {
                if (!facet) {
                    String sdkName = orderEntry.getAttributeValue("jdkName");
                    String newSdkName = FlexModuleConverter.processSdkEntry(newBuildConfiguration, oldConfiguration, sdkName);
                    ContainerUtil.addIfNotNull(usedSdksNames, (Object)newSdkName);
                }
                orderEntriesToRemove.add(orderEntry);
                continue;
            }
            if (!"inheritedJdk".equals(orderEntryType)) continue;
            if (!facet) {
                String newSdkName = FlexModuleConverter.processSdkEntry(newBuildConfiguration, oldConfiguration, this.myParams.projectSdkName);
                ContainerUtil.addIfNotNull(usedSdksNames, (Object)newSdkName);
            }
            orderEntriesToRemove.add(orderEntry);
        }
        if (facetSdkName != null) {
            String newSdkName = FlexModuleConverter.processSdkEntry(newBuildConfiguration, oldConfiguration, facetSdkName);
            ContainerUtil.addIfNotNull(usedSdksNames, (Object)newSdkName);
        }
        if (!orderEntriesToRemove.isEmpty()) {
            module.getOrderEntries().removeAll(orderEntriesToRemove);
        }
        if (BCUtils.canHaveRLMsAndRuntimeStylesheets(newBuildConfiguration) && oldConfiguration != null && !oldConfiguration.CSS_FILES_LIST.isEmpty()) {
            ArrayList<String> cssFilesToCompile = new ArrayList<String>();
            for (String cssPath : oldConfiguration.CSS_FILES_LIST) {
                cssFilesToCompile.add(PathUtil.getCanonicalPath((String)module.expandPath(cssPath)));
            }
            newBuildConfiguration.setCssFilesToCompile(cssFilesToCompile);
        }
    }

    public static boolean isAutogeneratedLibrary(Element libraryElement) {
        String libraryName = libraryElement.getAttributeValue("name");
        return libraryName != null && libraryName.startsWith("AUTOGENERATED library equal to Flex SDK ");
    }

    private static Map<String, String> convertCompilerOptions(FlexBuildConfiguration oldConfig, ModuleSettings module, ModifiableCompilerOptions newCompilerOptions) {
        StringBuilder b;
        if (oldConfig.USE_CUSTOM_CONFIG_FILE) {
            String customConfigFilePath = PathUtil.getCanonicalPath((String)module.expandPath(oldConfig.CUSTOM_CONFIG_FILE));
            newCompilerOptions.setAdditionalConfigFilePath(customConfigFilePath);
        }
        newCompilerOptions.setAdditionalOptions(oldConfig.ADDITIONAL_COMPILER_OPTIONS);
        THashMap options = new THashMap(newCompilerOptions.getAllOptions());
        if (oldConfig.USE_LOCALE_SETTINGS) {
            options.put("compiler.locale", oldConfig.LOCALE.replace(",", "\n"));
        }
        if (!oldConfig.CONDITIONAL_COMPILATION_DEFINITION_LIST.isEmpty()) {
            b = new StringBuilder();
            for (FlexBuildConfiguration.ConditionalCompilationDefinition def : oldConfig.CONDITIONAL_COMPILATION_DEFINITION_LIST) {
                if (b.length() > 0) {
                    b.append("\n");
                }
                b.append(def.NAME).append("\t").append(def.VALUE);
            }
            options.put("compiler.define", b.toString());
        }
        if (!oldConfig.NAMESPACE_AND_MANIFEST_FILE_INFO_LIST.isEmpty()) {
            b = new StringBuilder();
            for (FlexBuildConfiguration.NamespaceAndManifestFileInfo info : oldConfig.NAMESPACE_AND_MANIFEST_FILE_INFO_LIST) {
                if (b.length() > 0) {
                    b.append("\n");
                }
                b.append(info.NAMESPACE).append("\t").append(PathUtil.getCanonicalPath((String)module.expandPath(info.MANIFEST_FILE_PATH)));
            }
            options.put("compiler.namespaces.namespace", b.toString());
        }
        if (!oldConfig.PATH_TO_SERVICES_CONFIG_XML.isEmpty()) {
            options.put("compiler.services", oldConfig.PATH_TO_SERVICES_CONFIG_XML);
            options.put("compiler.context-root", oldConfig.CONTEXT_ROOT);
        }
        return options;
    }

    static boolean isApplicableLibrary(Element library, Function<String, String> pathExpander) {
        String libraryType = library.getAttributeValue("type");
        if (FlexLibraryType.FLEX_LIBRARY.getKindId().equals(libraryType)) {
            return true;
        }
        if (libraryType != null) {
            return false;
        }
        Element rootChild = library.getChild(OrderRootType.CLASSES.name());
        if (rootChild == null) {
            return false;
        }
        JarDirectories jarDirectories = new JarDirectories();
        try {
            jarDirectories.readExternal(library);
        }
        catch (InvalidDataException ignored) {
            jarDirectories.clear();
        }
        List classesRoots = rootChild.getChildren("root");
        if (classesRoots.isEmpty()) {
            return false;
        }
        for (Element root : classesRoots) {
            String path;
            String url = root.getAttributeValue("url");
            if (url == null || (path = FlexModuleConverter.getPathFromUrl(url)) == null) continue;
            if (path.toLowerCase().endsWith(".swc")) {
                return true;
            }
            if (jarDirectories.contains(OrderRootType.CLASSES, url)) {
                String expanded = (String)pathExpander.fun((Object)path);
                File file = new File(expanded);
                if (!file.isDirectory()) {
                    return true;
                }
                String[] allChildren = file.list();
                if (allChildren == null || allChildren.length == 0) {
                    return true;
                }
                File[] swcs = file.listFiles(FileFilters.filesWithExtension((String)"swc"));
                if (swcs != null && swcs.length > 0) {
                    return true;
                }
                File[] jars = file.listFiles(FileFilters.filesWithExtension((String)"jar"));
                if (jars != null && jars.length > 0) continue;
                return true;
            }
            if (path.toLowerCase().endsWith(".jar")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getPathFromUrl(String url) {
        if (url.startsWith("jar://") && url.endsWith("!/")) {
            return url.substring("jar://".length(), url.length() - "!/".length());
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        LOG.warn("Unknown url type: " + url);
        return null;
    }

    private static void convertDependencyType(Element orderEntry, ModifiableDependencyType dependencyType) {
        DependencyScope scope = DependencyScope.readExternal((Element)orderEntry);
        boolean isExported = orderEntry.getAttribute("exported") != null;
        dependencyType.setLinkageType(FlexUtils.convertLinkageType(scope, isExported));
    }

    private static String getOutputFolder(ModuleSettings moduleSettings) {
        String projectOutputUrl;
        boolean inheritOutput;
        Element rootManagerElement = moduleSettings.getComponentElement("NewModuleRootManager");
        if (rootManagerElement != null && !(inheritOutput = "true".equals(rootManagerElement.getAttributeValue("inherit-compiler-output")))) {
            String outputUrl;
            Element outputElement = rootManagerElement.getChild("output");
            String string = outputUrl = outputElement == null ? null : outputElement.getAttributeValue("url");
            if (outputUrl != null) {
                String path = PathUtil.getCanonicalPath((String)VfsUtilCore.urlToPath((String)moduleSettings.expandPath(outputUrl)));
                return moduleSettings.collapsePath(path);
            }
        }
        String path = (projectOutputUrl = moduleSettings.getProjectOutputUrl()) == null ? "" : VfsUtilCore.urlToPath((String)(moduleSettings.expandPath(projectOutputUrl) + "/" + "production" + "/" + moduleSettings.getModuleName()));
        return moduleSettings.collapsePath(path);
    }

    @Nullable
    private static String processSdkEntry(ModifiableFlexBuildConfiguration bc, @Nullable FlexBuildConfiguration oldConfiguration, String ideaSdkName) {
        Sdk sdk;
        String sdkTypeName;
        if (ideaSdkName == null) {
            bc.setTargetPlatform(TargetPlatform.Web);
            return null;
        }
        Sdk oldSdk = ProjectJdkTable.getInstance().findJdk(ideaSdkName);
        if (oldSdk == null || oldSdk.getHomePath() == null || !ArrayUtil.contains((String)(sdkTypeName = oldSdk.getSdkType().getName()), (String[])ConversionParams.OLD_SDKS_TYPES)) {
            bc.setTargetPlatform(TargetPlatform.Web);
            return null;
        }
        if ("AIR Mobile SDK Type".equals(sdkTypeName)) {
            bc.setTargetPlatform(TargetPlatform.Mobile);
            if (bc.getOutputType() == OutputType.Application) {
                bc.getAndroidPackagingOptions().setEnabled(true);
                String fileName = FileUtil.getNameWithoutExtension((String)bc.getOutputFileName());
                bc.getAndroidPackagingOptions().setPackageFileName(fileName);
                bc.getIosPackagingOptions().setPackageFileName(fileName);
            }
        } else if ("AIR SDK Type".equals(sdkTypeName)) {
            bc.setTargetPlatform(TargetPlatform.Desktop);
            if (bc.getOutputType() == OutputType.Application) {
                bc.getAirDesktopPackagingOptions().setPackageFileName(FileUtil.getNameWithoutExtension((String)bc.getOutputFileName()));
            }
        } else {
            bc.setTargetPlatform(TargetPlatform.Web);
            String targetPlayer = FlexSdkUtils.getTargetPlayer(oldConfiguration == null ? null : oldConfiguration.TARGET_PLAYER_VERSION, oldSdk.getHomePath());
            bc.getDependencies().setTargetPlayer(targetPlayer);
        }
        if ((sdk = ConversionParams.findNewSdk(oldSdk.getHomePath())) != null) {
            SdkEntry sdkEntry = Factory.createSdkEntry(sdk.getName());
            bc.getDependencies().setSdkEntry(sdkEntry);
            return sdk.getName();
        }
        return null;
    }

    private static void addContent(Element source, Element target) {
        List attributes = source.getAttributes();
        for (Object attribute : attributes) {
            target.setAttribute(((Attribute)attribute).clone());
        }
        for (Object child : source.getChildren()) {
            target.addContent(((Element)child).clone());
        }
    }

    public static String generateModuleBcName(ModuleSettings module) {
        return module.getModuleName();
    }

    public static String generateFacetBcName(List<Element> facets, Element facet) {
        List<String> names = FlexBuildConfigurationManagerImpl.generateUniqueNames(ContainerUtil.map(facets, (Function)new Function<Element, String>(){

            public String fun(Element element) {
                return element.getAttributeValue("name");
            }
        }));
        return names.get(facets.indexOf(facet));
    }

    private static void readNamespaceAndManifestInfoList(Element element, FlexBuildConfiguration oldConfig) throws InvalidDataException {
        ArrayList<FlexBuildConfiguration.NamespaceAndManifestFileInfo> namespaceAndManifestFileInfoList = new ArrayList<FlexBuildConfiguration.NamespaceAndManifestFileInfo>();
        Element namespaceAndManifestFileInfoListElement = element.getChild(NAMESPACE_AND_MANIFEST_FILE_INFO_LIST_ELEMENT_NAME);
        if (namespaceAndManifestFileInfoListElement != null) {
            for (Object namespaceAndManifestFileInfoElement : namespaceAndManifestFileInfoListElement.getChildren(FlexBuildConfiguration.NamespaceAndManifestFileInfo.class.getSimpleName())) {
                FlexBuildConfiguration.NamespaceAndManifestFileInfo namespaceAndManifestFileInfo = new FlexBuildConfiguration.NamespaceAndManifestFileInfo();
                DefaultJDOMExternalizer.readExternal((Object)namespaceAndManifestFileInfo, (Element)((Element)namespaceAndManifestFileInfoElement));
                namespaceAndManifestFileInfoList.add(namespaceAndManifestFileInfo);
            }
        }
        oldConfig.NAMESPACE_AND_MANIFEST_FILE_INFO_LIST = namespaceAndManifestFileInfoList;
    }

    private static void readConditionalCompilerDefinitionList(Element element, FlexBuildConfiguration oldConfig) throws InvalidDataException {
        ArrayList<FlexBuildConfiguration.ConditionalCompilationDefinition> conditionalCompilationDefinitionList = new ArrayList<FlexBuildConfiguration.ConditionalCompilationDefinition>();
        Element conditionalCompilerDefinitionListElement = element.getChild(CONDITIONAL_COMPILER_DEFINITION_LIST_ELEMENT_NAME);
        if (conditionalCompilerDefinitionListElement != null) {
            for (Object conditionalCompilerDefinitionElement : conditionalCompilerDefinitionListElement.getChildren(FlexBuildConfiguration.ConditionalCompilationDefinition.class.getSimpleName())) {
                FlexBuildConfiguration.ConditionalCompilationDefinition conditionalCompilationDefinition = new FlexBuildConfiguration.ConditionalCompilationDefinition();
                DefaultJDOMExternalizer.readExternal((Object)conditionalCompilationDefinition, (Element)((Element)conditionalCompilerDefinitionElement));
                conditionalCompilationDefinitionList.add(conditionalCompilationDefinition);
            }
        }
        oldConfig.CONDITIONAL_COMPILATION_DEFINITION_LIST = conditionalCompilationDefinitionList;
    }

    private static void readCssFilesList(Element element, FlexBuildConfiguration oldConfig) throws InvalidDataException {
        ArrayList<String> cssFilesList = new ArrayList<String>();
        Element cssFilesListElement = element.getChild(CSS_FILES_LIST_ELEMENT_NAME);
        if (cssFilesListElement != null) {
            for (Element conditionalCompilerDefinitionElement : cssFilesListElement.getChildren(FILE_PATH_ELEMENT_NAME)) {
                cssFilesList.add(conditionalCompilerDefinitionElement.getValue());
            }
        }
        oldConfig.CSS_FILES_LIST = cssFilesList;
    }
}

