/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.options;

import com.intellij.flex.model.bc.LinkageType;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexProjectRootsUtil {
    public static boolean dependsOnLibrary(@NotNull FlexBuildConfiguration bc, final @NotNull Library library, final boolean transitive, final boolean productionOnly) {
        String libraryLevel;
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/projectStructure/options/FlexProjectRootsUtil", "dependsOnLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/options/FlexProjectRootsUtil", "dependsOnLibrary"));
        }
        String string = libraryLevel = library.getTable() != null ? library.getTable().getTableLevel() : null;
        if ("application".equals(libraryLevel) || "project".equals(libraryLevel)) {
            return !ContainerUtil.process((Object[])bc.getDependencies().getEntries(), (Processor)new Processor<DependencyEntry>(){

                public boolean process(DependencyEntry dependencyEntry) {
                    if (!(dependencyEntry instanceof SharedLibraryEntry)) {
                        return true;
                    }
                    if (!FlexProjectRootsUtil.canDependOn(dependencyEntry, transitive, productionOnly)) {
                        return true;
                    }
                    return !((SharedLibraryEntry)dependencyEntry).getLibraryName().equals(library.getName()) || !((SharedLibraryEntry)dependencyEntry).getLibraryLevel().equals(libraryLevel);
                }
            });
        }
        final String libraryId = FlexProjectRootsUtil.getLibraryId(library);
        return libraryId != null && !ContainerUtil.process((Object[])bc.getDependencies().getEntries(), (Processor)new Processor<DependencyEntry>(){

            public boolean process(DependencyEntry dependencyEntry) {
                if (!(dependencyEntry instanceof ModuleLibraryEntry)) {
                    return true;
                }
                if (!FlexProjectRootsUtil.canDependOn(dependencyEntry, transitive, productionOnly)) {
                    return true;
                }
                return !((ModuleLibraryEntry)dependencyEntry).getLibraryId().equals(libraryId);
            }
        });
    }

    private static boolean canDependOn(DependencyEntry dependencyEntry, boolean transitive, boolean productionOnly) {
        if (productionOnly && dependencyEntry.getDependencyType().getLinkageType() == LinkageType.Test) {
            return false;
        }
        return !transitive || dependencyEntry.getDependencyType().getLinkageType() == LinkageType.Include;
    }

    public static boolean dependOnLibrary(Iterable<FlexBuildConfiguration> bcs, final @NotNull Library library, final boolean transitive, final boolean productionOnly) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/options/FlexProjectRootsUtil", "dependOnLibrary"));
        }
        return !ContainerUtil.process(bcs, (Processor)new Processor<FlexBuildConfiguration>(){

            public boolean process(FlexBuildConfiguration configuration) {
                return !FlexProjectRootsUtil.dependsOnLibrary(configuration, library, transitive, productionOnly);
            }
        });
    }

    public static String getLibraryId(Library library) {
        return ((FlexLibraryProperties)((LibraryEx)library).getProperties()).getId();
    }

    @Nullable
    public static LibraryOrderEntry findOrderEntry(ModuleLibraryEntry entry, ModuleRootModel rootModel) {
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            LibraryEx library;
            if (!(orderEntry instanceof LibraryOrderEntry) || !"module".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || (library = (LibraryEx)((LibraryOrderEntry)orderEntry).getLibrary()) == null || library.getKind() != FlexLibraryType.FLEX_LIBRARY || !entry.getLibraryId().equals(FlexProjectRootsUtil.getLibraryId((Library)library))) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static Library findOrderEntry(Project project, SharedLibraryEntry entry) {
        ApplicationLibraryTable libraryTable = "application".equals(entry.getLibraryLevel()) ? ApplicationLibraryTable.getApplicationTable() : ProjectLibraryTable.getInstance((Project)project);
        return libraryTable.getLibraryByName(entry.getLibraryName());
    }

    public static boolean isFlexLibrary(Library library) {
        return ((LibraryEx)library).getKind() == FlexLibraryType.FLEX_LIBRARY;
    }
}

