/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class ChooseActiveBuildConfigurationAction
extends DumbAwareAction {
    private static final Icon ICON_ACTIVE = PlatformIcons.CHECK_ICON;
    private static final Icon ICON_ACTIVE_SELECTED = PlatformIcons.CHECK_ICON_SELECTED;
    private static final Icon ICON_EMPTY = new EmptyIcon(ICON_ACTIVE.getIconWidth(), ICON_ACTIVE.getIconHeight());

    public void update(AnActionEvent e) {
        boolean enabled = ChooseActiveBuildConfigurationAction.isEnabled(e.getDataContext());
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
            e.getPresentation().setEnabled(enabled);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(enabled);
        }
    }

    private static boolean isEnabled(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module != null && ModuleType.get((Module)module) == FlexModuleType.getInstance();
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module != null) {
            ChooseActiveBuildConfigurationAction.createPopup(module).showInBestPositionFor(e.getDataContext());
        }
    }

    public static ListPopup createPopup(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/ui/ChooseActiveBuildConfigurationAction", "createPopup"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        FlexBuildConfigurationManager manager = FlexBuildConfigurationManager.getInstance(module);
        final FlexBuildConfiguration activeBc = manager.getActiveConfiguration();
        FlexBuildConfiguration[] bcs = manager.getBuildConfigurations();
        Arrays.sort(bcs, new Comparator<FlexBuildConfiguration>(){

            @Override
            public int compare(FlexBuildConfiguration o1, FlexBuildConfiguration o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (FlexBuildConfiguration bc : bcs) {
            actionGroup.add((AnAction)new SelectBcAction(bc, manager));
        }
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new EditBcsAction(module));
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)module.getProject());
        return new PopupFactoryImpl.ActionGroupPopup(FlexBundle.message("choose.build.configuration.popup.title", module.getName()), (ActionGroup)actionGroup, dataContext, false, false, false, true, null, -1, (Condition)new Condition<AnAction>(){

            public boolean value(AnAction anAction) {
                return anAction instanceof SelectBcAction && ((SelectBcAction)anAction).getBC() == activeBc;
            }
        }, null){

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer((ListPopupImpl)this){

                    protected JComponent createItemComponent() {
                        return new MyPanel();
                    }

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Icon icon;
                        SimpleColoredText text;
                        boolean isActive;
                        MyPanel p = (MyPanel)this.myComponent;
                        p.clear();
                        PopupFactoryImpl.ActionItem actionItem = (PopupFactoryImpl.ActionItem)value;
                        AnAction anAction = actionItem.getAction();
                        if (anAction instanceof SelectBcAction) {
                            FlexBuildConfiguration bc = ((SelectBcAction)anAction).getBC();
                            isActive = bc == activeBc;
                            text = BCUtils.renderBuildConfiguration(bc, null, isActive);
                            icon = bc.getIcon();
                        } else {
                            text = new SimpleColoredText(anAction.getTemplatePresentation().getText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            icon = anAction.getTemplatePresentation().getIcon();
                            isActive = false;
                        }
                        RowIcon rowIcon = new RowIcon(2);
                        rowIcon.setIcon(isActive ? (isSelected ? ICON_ACTIVE_SELECTED : ICON_ACTIVE) : ICON_EMPTY, 0);
                        rowIcon.setIcon(icon, 1);
                        p.setIcon((Icon)rowIcon);
                        if (isSelected) {
                            text = text.derive(SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES, true);
                            this.setSelected(p);
                        } else {
                            this.setDeselected(p);
                        }
                        p.setText(text);
                        this.mySeparatorComponent.setVisible(actionItem.isPrependWithSeparator());
                        return this.myRendererComponent;
                    }
                };
            }
        };
    }

    private static class MyPanel
    extends JPanel {
        private final SimpleColoredComponent myComponent;

        public MyPanel() {
            super(new BorderLayout());
            this.setBorder(new EmptyBorder(2, 0, 2, 0));
            this.setOpaque(true);
            this.myComponent = new SimpleColoredComponent();
            this.myComponent.setIconOpaque(false);
            this.myComponent.setOpaque(false);
            this.add((Component)this.myComponent, "Center");
        }

        public void setText(SimpleColoredText text) {
            text.appendToComponent((ColoredTextContainer)this.myComponent);
        }

        public void setIcon(Icon icon) {
            this.myComponent.setIcon(icon);
        }

        public void clear() {
            this.myComponent.clear();
        }
    }

    private static class EditBcsAction
    extends DumbAwareAction {
        private final Module myModule;

        public EditBcsAction(Module module) {
            super(null);
            this.myModule = module;
            AnAction a = ActionManager.getInstance().getAction("ShowProjectStructureSettings");
            this.getTemplatePresentation().copyFrom(a.getTemplatePresentation());
        }

        public void actionPerformed(AnActionEvent e) {
            final FlexBuildConfiguration activeConfiguration = FlexBuildConfigurationManager.getInstance(this.myModule).getActiveConfiguration();
            final ProjectStructureConfigurable c = ProjectStructureConfigurable.getInstance((Project)this.myModule.getProject());
            ShowSettingsUtil.getInstance().editConfigurable(this.myModule.getProject(), (Configurable)c, new Runnable(){

                @Override
                public void run() {
                    Place p = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor(myModule, activeConfiguration.getName());
                    c.navigateTo(p, true);
                }
            });
        }
    }

    private static class SelectBcAction
    extends DumbAwareAction {
        private final FlexBuildConfiguration myBc;
        private final FlexBuildConfigurationManager myManager;

        public SelectBcAction(FlexBuildConfiguration bc, FlexBuildConfigurationManager manager) {
            super(bc.getName(), SelectBcAction.getDescription(bc), bc.getIcon());
            this.myBc = bc;
            this.myManager = manager;
        }

        private static String getDescription(FlexBuildConfiguration bc) {
            return bc.getNature().getPresentableText();
        }

        public void actionPerformed(AnActionEvent e) {
            this.myManager.setActiveBuildConfiguration(this.myBc);
        }

        public FlexBuildConfiguration getBC() {
            return this.myBc;
        }
    }
}

