/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.javascript.flex.projectStructure.FlexCompositeSdk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompositeSdkProjectViewStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider", "modify"));
        }
        if (!(parent instanceof ExternalLibrariesNode)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider", "modify"));
            }
            return collection;
        }
        HashSet processedSdks = new HashSet();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            Sdk[] sdks;
            Object value = child.getValue();
            if (!(value instanceof NamedLibraryElement)) {
                result.add(child);
                continue;
            }
            NamedLibraryElement libraryElement = (NamedLibraryElement)value;
            LibraryOrSdkOrderEntry orderEntry = libraryElement.getOrderEntry();
            if (!(orderEntry instanceof JdkOrderEntry)) {
                result.add(child);
                continue;
            }
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (!(sdk instanceof FlexCompositeSdk)) {
                result.add(child);
                continue;
            }
            for (Sdk individualSdk : sdks = ((FlexCompositeSdk)sdk).getSdks()) {
                if (!processedSdks.add(individualSdk)) continue;
                IndividualSdkOrderEntry entry = new IndividualSdkOrderEntry(individualSdk, orderEntry.getOwnerModule());
                result.add((AbstractTreeNode)new NamedLibraryElementNode(parent.getProject(), new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)entry), ((ExternalLibrariesNode)parent).getSettings()));
            }
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider", "modify"));
        }
        return arrayList;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    private static class IndividualSdkOrderEntry
    implements ModuleJdkOrderEntry {
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final Module myModule;

        private IndividualSdkOrderEntry(Sdk sdk, Module module) {
            this.mySdk = sdk;
            this.myModule = module;
        }

        public Sdk getJdk() {
            return this.mySdk;
        }

        public String getJdkName() {
            return this.mySdk.getName();
        }

        public VirtualFile[] getRootFiles(OrderRootType type) {
            List directories = ContainerUtil.filter((Object[])this.mySdk.getRootProvider().getFiles(type), (Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile virtualFile) {
                    return virtualFile.isDirectory();
                }
            });
            return VfsUtil.toVirtualFileArray((Collection)directories);
        }

        public String[] getRootUrls(OrderRootType type) {
            return this.mySdk.getRootProvider().getUrls(type);
        }

        @NotNull
        public VirtualFile[] getFiles(OrderRootType type) {
            VirtualFile[] virtualFileArray = this.mySdk.getRootProvider().getFiles(type);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider$IndividualSdkOrderEntry", "getFiles"));
            }
            return virtualFileArray;
        }

        @NotNull
        public String[] getUrls(OrderRootType rootType) {
            String[] stringArray = this.getRootUrls(rootType);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider$IndividualSdkOrderEntry", "getUrls"));
            }
            return stringArray;
        }

        @NotNull
        public String getPresentableName() {
            String string = "<" + this.getJdkName() + ">";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider$IndividualSdkOrderEntry", "getPresentableName"));
            }
            return string;
        }

        public boolean isValid() {
            return true;
        }

        @NotNull
        public Module getOwnerModule() {
            Module module = this.myModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/FlexCompositeSdkProjectViewStructureProvider$IndividualSdkOrderEntry", "getOwnerModule"));
            }
            return module;
        }

        public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
            return (R)policy.visitModuleJdkOrderEntry((ModuleJdkOrderEntry)this, initialValue);
        }

        public int compareTo(OrderEntry o) {
            return 0;
        }

        public boolean isSynthetic() {
            return true;
        }
    }
}

