/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.extras.providers.ImplementationsProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class FlashUmlImplementationsProvider
extends ImplementationsProvider<Object> {
    public Object[] getElements(Object element, Project project) {
        JSClass clazz = (JSClass)element;
        final Set<PsiElement> inheritors = Collections.synchronizedSet(new THashSet());
        Processor<JSClass> p = new Processor<JSClass>(){

            public boolean process(JSClass aClass) {
                PsiElement navigationElement = aClass.getNavigationElement();
                inheritors.add(navigationElement instanceof JSClass ? navigationElement : aClass);
                return true;
            }
        };
        JSClassSearch.searchClassInheritors((JSClass)clazz, (boolean)true).forEach((Processor)p);
        if (clazz.isInterface()) {
            JSClassSearch.searchInterfaceImplementations((JSClass)clazz, (boolean)true).forEach((Processor)p);
        }
        return inheritors.toArray(new PsiElement[inheritors.size()]);
    }

    public boolean isEnabledOn(Object element) {
        return element instanceof JSClass;
    }

    public String getHeaderName(Object element, Project project) {
        return JSBundle.message((String)"javascript.uml.show.implementations.header", (Object[])new Object[]{((JSClass)element).getName()});
    }

    public Comparator<Object> getComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return DiagramElementsProvider.PSI_COMPARATOR.compare((PsiElement)o1, (PsiElement)o2);
            }
        };
    }
}

