/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssImageUtil {
    private static final String BACKGROUND_IMAGE_PROPERTY_NAME = "background-image";
    private static final String BACKGROUND_PROPERTY_NAME = "background";
    private static final List<String> supportedExtensions = Arrays.asList(ImageIO.getReaderFormatNames());

    private CssImageUtil() {
    }

    @NotNull
    public static Collection<CssUri> findBackgroundImageUris(@NotNull PsiElement element) {
        Collection uris;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/css/util/CssImageUtil", "findBackgroundImageUris"));
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class});
        if (declaration != null && CssImageUtil.isBackgroundDeclaration(declaration) && !(uris = PsiTreeUtil.findChildrenOfType((PsiElement)declaration.getValue(), CssUri.class)).isEmpty()) {
            Collection collection = uris;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssImageUtil", "findBackgroundImageUris"));
            }
            return collection;
        }
        List<CssUri> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssImageUtil", "findBackgroundImageUris"));
        }
        return list;
    }

    @NotNull
    public static Collection<CssUri> findBackgroundImageUrlsInBlock(@NotNull CssBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/css/util/CssImageUtil", "findBackgroundImageUrlsInBlock"));
        }
        ArrayList uris = ContainerUtil.newArrayList();
        for (CssDeclaration cssDeclaration : block.getDeclarations()) {
            if (!CssImageUtil.isBackgroundDeclaration(cssDeclaration)) continue;
            uris.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)cssDeclaration.getValue(), CssUri.class));
        }
        ArrayList arrayList = uris;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssImageUtil", "findBackgroundImageUrlsInBlock"));
        }
        return arrayList;
    }

    public static boolean isBackgroundDeclaration(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/css/util/CssImageUtil", "isBackgroundDeclaration"));
        }
        String propertyName = declaration.getPropertyName();
        return BACKGROUND_IMAGE_PROPERTY_NAME.equalsIgnoreCase(propertyName) || BACKGROUND_PROPERTY_NAME.equalsIgnoreCase(propertyName);
    }

    @NotNull
    public static Collection<VirtualFile> getImageFiles(@Nullable CssElement cssUriOrString) {
        if (cssUriOrString == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssImageUtil", "getImageFiles"));
            }
            return list;
        }
        Object[] psiFiles = CssResolveManager.getInstance().resolveFiles(cssUriOrString, cssUriOrString.getContainingFile());
        List virtualFiles = ContainerUtil.map((Object[])psiFiles, (Function)new Function<PsiFile, VirtualFile>(){

            public VirtualFile fun(PsiFile file) {
                return file.getVirtualFile();
            }
        });
        List list = ContainerUtil.filter((Collection)virtualFiles, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                if (file == null) {
                    return false;
                }
                String extension = file.getExtension();
                return extension != null && supportedExtensions.contains(extension.toLowerCase(Locale.US));
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssImageUtil", "getImageFiles"));
        }
        return list;
    }

    public static boolean isDataUri(@Nullable PsiElement uri) {
        if (uri != null && uri instanceof CssUri) {
            return URLUtil.isDataUri((String)((CssUri)uri).getValue());
        }
        return false;
    }
}

