/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class CfmlArgumentValuesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement parentSibling;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlArgumentValuesCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlArgumentValuesCompletionProvider", "addCompletions"));
        }
        PsiElement element = parameters.getPosition();
        CfmlFunctionCallExpression parentOfType = (CfmlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, CfmlFunctionCallExpression.class);
        if (parentOfType == null || !parentOfType.isCreateObject()) {
            return;
        }
        PsiElement parent = element.getParent();
        PsiElement psiElement = parentSibling = parent != null ? parent.getPrevSibling() : null;
        while (parentSibling != null && parentSibling.getNode().getElementType() == TokenType.WHITE_SPACE) {
            parentSibling = parentSibling.getPrevSibling();
        }
        if (parentSibling != null && parent.getNode().getElementType() == CfmlElementTypes.STRING_LITERAL && parentSibling.getNode().getElementType() == CfscriptTokenTypes.L_BRACKET) {
            result.addAllElements((Iterable)ContainerUtil.map2Set((Object[])CfmlUtil.getCreateObjectArgumentValues(), (Function)new Function<String, LookupElement>(){

                public LookupElementBuilder fun(String argumentValue) {
                    return LookupElementBuilder.create((String)argumentValue).withCaseSensitivity(false);
                }
            }));
        }
    }
}

