/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.psi.CfmlImplicitVariable;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiComment> CFMLVARIABLE_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(CfmlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@cfmlvariable "));
    public static final PsiElementPattern.Capture<PsiComment> CFMLJAVALOADER_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(CfmlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@javaloader "));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor", "registerReferenceProviders"));
        }
        this.registerImplicitVariableProvider(registrar);
    }

    private void registerImplicitVariableProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(CFMLVARIABLE_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = CfmlReferenceContributor.getReferencesToJavaTypes(element);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 0.0);
        registrar.registerReferenceProvider(CFMLVARIABLE_COMMENT, (PsiReferenceProvider)new VariableReferenceProvider(), 0.0);
        registrar.registerReferenceProvider(CFMLJAVALOADER_COMMENT, (PsiReferenceProvider)new VariableReferenceProvider(), 0.0);
    }

    public static PsiReference[] getReferencesToJavaTypes(PsiElement element) {
        String text = element.getText();
        TextRange range = CfmlReferenceContributor.findTypeNameRange(text);
        if (range == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        return provider.getReferencesByString(range.substring(text), element, range.getStartOffset());
    }

    @Nullable
    public static TextRange findTypeNameRange(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor", "findTypeNameRange"));
        }
        return CfmlPsiUtil.findRange(text, "type=\"", "\"");
    }

    private class VariableReferenceProvider
    extends PsiReferenceProvider {
        private VariableReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider", "getReferencesByElement"));
            }
            String text = element.getText();
            TextRange range = CfmlPsiUtil.findRange(text, "name=\"", "\"");
            if (range == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String name = range.substring(text);
            final CfmlImplicitVariable variable = ((CfmlFile)element.getContainingFile()).findImplicitVariable(name);
            if (variable == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReferenceBase<PsiComment> ref = new PsiReferenceBase<PsiComment>((PsiComment)element, TextRange.from((int)range.getStartOffset(), (int)name.length())){

                public PsiElement resolve() {
                    return variable;
                }

                @NotNull
                public Object[] getVariants() {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider$1", "getVariants"));
                    }
                    return EMPTY_ARRAY;
                }
            };
            SmartList result = new SmartList();
            result.add(ref);
            PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlReferenceContributor$VariableReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

