/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFileViewProvider;
import com.intellij.coldFusion.model.psi.CfmlImport;
import com.intellij.coldFusion.model.psi.stubs.CfmlIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

class CfmlTagNamesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    CfmlTagNamesCompletionProvider() {
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlTagNamesCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlTagNamesCompletionProvider", "addCompletions"));
        }
        if (!(parameters.getOriginalFile().getViewProvider() instanceof CfmlFileViewProvider)) {
            return;
        }
        for (String s : CfmlUtil.getTagList(parameters.getPosition().getProject())) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)s).withCaseSensitivity(false));
        }
        CfmlImport[] imports = (CfmlImport[])PsiTreeUtil.getChildrenOfType((PsiElement)parameters.getOriginalFile(), CfmlImport.class);
        if (imports == null) {
            return;
        }
        for (CfmlImport cfmlImport : imports) {
            String prefix = cfmlImport.getPrefix();
            if (prefix == null) continue;
            this.addCompletionsFromDirectory(result, parameters, cfmlImport.getImportString(), prefix);
        }
    }

    private void addCompletionsFromDirectory(CompletionResultSet result, CompletionParameters parameters, String libtag, String prefix) {
        PsiFile originalFile = parameters.getOriginalFile();
        VirtualFile folder = CfmlUtil.findFileByLibTag(originalFile, libtag);
        if (folder != null && folder.isDirectory()) {
            THashSet names = new THashSet(CfmlIndex.getInstance(originalFile.getProject()).getAllComponentsNames());
            names.retainAll(ContainerUtil.map((Object[])folder.getChildren(), (Function)new Function<VirtualFile, String>(){

                public String fun(VirtualFile virtualFile) {
                    return FileUtil.getNameWithoutExtension((String)virtualFile.getName()).toLowerCase();
                }
            }));
            for (String componentName : names) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + ':' + componentName)).withCaseSensitivity(false));
            }
        }
    }
}

