/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.info;

import com.intellij.coldFusion.UI.config.CfmlProjectConfiguration;
import com.intellij.coldFusion.model.info.CfmlFunctionDescription;
import com.intellij.coldFusion.model.info.CfmlTagDescription;
import com.intellij.coldFusion.model.info.CfmlTagsDescriptionsParser;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.LineReader;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CfmlLangInfo {
    private final Project myProject;
    private Reference<CfmlLangDictionary> myCFDictionary;
    private String myCFDictionaryLevel;
    private static final Logger LOG = Logger.getInstance((String)CfmlLangInfo.class.getName());

    public static CfmlLangInfo getInstance(Project project) {
        return (CfmlLangInfo)ServiceManager.getService((Project)project, CfmlLangInfo.class);
    }

    public CfmlLangInfo(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CfmlLangDictionary getProjectDictionary() {
        CfmlLangDictionary dictionary;
        String languageLevel = this.getLanguageLevel();
        if (Comparing.equal((String)this.myCFDictionaryLevel, (String)languageLevel) && (dictionary = (CfmlLangDictionary)SoftReference.dereference(this.myCFDictionary)) != null) {
            return dictionary;
        }
        Class<CfmlLangInfo> clazz = CfmlLangInfo.class;
        synchronized (CfmlLangInfo.class) {
            dictionary = (CfmlLangDictionary)SoftReference.dereference(this.myCFDictionary);
            if (dictionary == null || !Comparing.equal((String)this.myCFDictionaryLevel, (String)languageLevel)) {
                dictionary = new CfmlLangDictionary("scopes.txt", languageLevel);
                this.myCFDictionary = new SoftReference((Object)dictionary);
                this.myCFDictionaryLevel = languageLevel;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return dictionary;
        }
    }

    public String getLanguageLevel() {
        CfmlProjectConfiguration.State state = CfmlProjectConfiguration.getInstance(this.myProject).getState();
        return state != null ? state.getLanguageLevel() : "cf10_tags.xml";
    }

    public String[] getPredefinedFunctionsLowCase() {
        return this.getProjectDictionary().myPredefinedFunctionsInLowCase;
    }

    public String[] getPredefinedFunctions() {
        return this.getProjectDictionary().myPredefinedFunctions;
    }

    public Map<String, Integer> getPredefinedVariables() {
        return this.getProjectDictionary().myPredefinedVariables;
    }

    public String[] getPredefinedFunctionsInLowCase() {
        return this.getProjectDictionary().myPredefinedFunctionsInLowCase;
    }

    public String[] getVariableScopes() {
        return this.getProjectDictionary().myVariableScopes;
    }

    public Map<String, CfmlTagDescription> getTagAttributes() {
        return this.getProjectDictionary().myTagAttributes;
    }

    public Map<String, CfmlFunctionDescription> getFunctionParameters() {
        return this.getProjectDictionary().myFunctionParameters;
    }

    @Nullable
    private static String[] readStringsFromFile(String fileName) {
        String[] result = null;
        try {
            InputStream predefined = CfmlLangInfo.class.getResourceAsStream(fileName);
            if (predefined != null) {
                LineReader lineReader = new LineReader(predefined);
                List list = lineReader.readLines();
                result = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    String s;
                    byte[] bytes = (byte[])list.get(i);
                    result[i] = s = new String(bytes);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static class CfmlLangDictionary {
        public String[] myPredefinedFunctions;
        public Map<String, Integer> myPredefinedVariables;
        public String[] myPredefinedFunctionsInLowCase;
        public String[] myVariableScopes;
        public Map<String, CfmlTagDescription> myTagAttributes;
        public Map<String, CfmlFunctionDescription> myFunctionParameters;

        public CfmlLangDictionary(String scopesFileName, String tagsFileName) {
            if (StringUtil.isEmpty((String)scopesFileName) || StringUtil.isEmpty((String)tagsFileName)) {
                return;
            }
            this.myVariableScopes = CfmlLangInfo.readStringsFromFile(scopesFileName);
            CfmlTagsDescriptionsParser cfmlTagsParser = new CfmlTagsDescriptionsParser();
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(cfmlTagsParser);
                xr.parse(new InputSource(CfmlLangInfo.class.getResourceAsStream(tagsFileName)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            this.myTagAttributes = cfmlTagsParser.getTags();
            this.myFunctionParameters = cfmlTagsParser.getFunctions();
            this.myPredefinedFunctions = cfmlTagsParser.getFunctionsList();
            this.myPredefinedFunctionsInLowCase = cfmlTagsParser.getFunctionsListLowerCased();
            this.myPredefinedVariables = cfmlTagsParser.getPredefinedVariables();
        }
    }
}

