/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.resolver.CssEmmetResolver;
import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CssEmmetParser
extends EmmetParser {
    private final boolean myInDeclarationBlock;

    CssEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, boolean inDeclarationBlock, ZenCodingGenerator generator) {
        super(tokens, callback, generator);
        this.myInDeclarationBlock = inDeclarationBlock;
    }

    @Nullable
    protected ZenCodingNode parseTemplate() {
        ZenCodingNode expandResult;
        ZenCodingToken token = this.getToken();
        if (!(token instanceof IdentifierToken)) {
            return null;
        }
        String templateKey = ((IdentifierToken)token).getText();
        StringBuilder abbreviation = new StringBuilder(templateKey);
        this.advance();
        ZenCodingToken nextToken = this.getToken();
        while (nextToken != null && !(nextToken instanceof OperationToken)) {
            abbreviation.append(nextToken.toString());
            this.advance();
            nextToken = this.getToken();
        }
        String key = abbreviation.toString();
        TemplateImpl template = this.myCallback.findApplicableTemplate(key);
        CssEmmetOptions cssEmmetOptions = CssEmmetOptions.getInstance();
        if ((template == null || cssEmmetOptions.isAutoInsertCssPrefixedEnabled()) && this.myInDeclarationBlock && (expandResult = new CssEmmetResolver().expand(key, template, this.myCallback)) != null) {
            return expandResult;
        }
        TemplateToken templateToken = new TemplateToken(templateKey);
        if (!this.setTemplate(templateToken, template)) {
            return null;
        }
        return new TemplateNode(templateToken);
    }
}

