/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.emmet.CssEmmetParser;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetConfigurable;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.livetemplate.CssDeclarationBlockTemplateContextType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssZenCodingGenerator
extends ZenCodingGenerator {
    protected boolean isAllowedChar(char c) {
        return c == ',' || super.isAllowedChar(c);
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        boolean inDeclarationBlock = false;
        PsiElement context = callback.getContext();
        Set applicableContextTypes = TemplateManagerImpl.getApplicableContextTypes((PsiFile)context.getContainingFile(), (int)context.getTextOffset());
        for (TemplateContextType type : applicableContextTypes) {
            if (!(type instanceof CssDeclarationBlockTemplateContextType)) continue;
            inDeclarationBlock = true;
        }
        CssEmmetParser cssEmmetParser = new CssEmmetParser(tokens, callback, inDeclarationBlock, generator);
        if (cssEmmetParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/CssZenCodingGenerator", "createParser"));
        }
        return cssEmmetParser;
    }

    @Nullable
    public Configurable createConfigurable() {
        return new CssEmmetConfigurable();
    }

    public boolean hasCompletionItem() {
        CssEmmetOptions options = CssEmmetOptions.getInstance();
        return options.isCssEmmetEnabled() && options.isFuzzySearchEnabled();
    }

    public void disableEmmet() {
        CssEmmetOptions.getInstance().setCssEmmetEnabled(false);
    }
}

