/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.codeInsight.template.emmet.CssEmmetUtil;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory;
import java.util.Collection;
import java.util.List;

public abstract class CssEmmetNode
extends ZenCodingNode {
    protected final List<String> myValues;
    protected final Collection<CssPrefix> myPrefixes;
    protected final boolean myImportant;

    public CssEmmetNode(List<String> values, Collection<CssPrefix> prefixes, boolean isImportant) {
        this.myValues = values;
        this.myPrefixes = prefixes;
        this.myImportant = isImportant;
    }

    protected String createValue(String propertyName) {
        CssPropertyDescriptor descriptor = CssElementDescriptorFactory.getDescriptor(propertyName);
        final boolean unitlessProperty = descriptor != null && descriptor.allowsIntegerWithoutSuffix();
        return StringUtil.join((Collection)Collections2.transform(this.myValues, (Function)new Function<String, String>(){

            public String apply(String input) {
                return CssEmmetUtil.normalizeValue(input, unitlessProperty);
            }
        }), (String)" ");
    }

    protected String createDeclarationsString(String propertyName, String value, String declarationsTerminator) {
        Collection<CssPrefix> explicitlyEnabledPrefixes;
        Collection<CssPrefix> prefixes = this.myPrefixes;
        CssEmmetOptions cssEmmetOptions = CssEmmetOptions.getInstance();
        if (cssEmmetOptions.isAutoInsertCssPrefixedEnabled() && !(explicitlyEnabledPrefixes = cssEmmetOptions.getPrefixStateForProperty(propertyName).getEnabledPrefixes()).isEmpty() && (prefixes.isEmpty() || prefixes.equals(CssEmmetUtil.ALL_PREFIXES))) {
            prefixes = explicitlyEnabledPrefixes;
        }
        prefixes = CssEmmetUtil.filterPrefixes(prefixes);
        StringBuilder declarations = new StringBuilder();
        if (!StringUtil.startsWithChar((CharSequence)value, (char)' ')) {
            value = ' ' + value;
        }
        for (CssPrefix prefix : prefixes) {
            declarations.append(prefix.getText()).append("-").append(propertyName).append(":").append(value).append(declarationsTerminator);
        }
        declarations.append(propertyName).append(":").append(value).append(declarationsTerminator);
        return declarations.toString();
    }
}

