/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.impl.stubs.index.CssAttributeIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public static final Key<ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>>> CACHE = Key.create((String)"css.attr.cache");
    public static final Key<Boolean> DO_NOT_PROVIDE_ATTRIBUTES_FROM_CSS = Key.create((String)"do.not.provide.attributes.from.css");

    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        if (!HtmlUtil.isHtmlTag((XmlTag)context) || ((Boolean)DO_NOT_PROVIDE_ATTRIBUTES_FROM_CSS.get((UserDataHolder)context, (Object)false)).booleanValue()) {
            return XmlAttributeDescriptor.EMPTY;
        }
        final String name = context.getLocalName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        final Project project = context.getProject();
        UserDataHolderEx holder = (UserDataHolderEx)(module != null ? module : project);
        final GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>> cache = CssAttributeDescriptorsProvider.getCache(holder);
        CachedValue<XmlAttributeDescriptor[]> value = (CachedValue<XmlAttributeDescriptor[]>)cache.get(name);
        if (value == null) {
            PsiManager manager = PsiManager.getInstance((Project)project);
            CachedValue<XmlAttributeDescriptor[]> newValue = new CachedValue<XmlAttributeDescriptor[]>(manager, (CachedValueProvider)new CachedValueProvider<XmlAttributeDescriptor[]>(){

                @Nullable
                public CachedValueProvider.Result<XmlAttributeDescriptor[]> compute() {
                    Collection keys = StubIndex.getInstance().getAllKeys(CssAttributeIndex.KEY, project);
                    if (keys.isEmpty()) {
                        return this.emptyResult();
                    }
                    ArrayList descriptors = new ArrayList();
                    for (String key : keys) {
                        if (!key.startsWith(name + ".") && !key.startsWith("*.")) continue;
                        ContainerUtil.addIfNotNull(descriptors, (Object)CssAttributeDescriptorsProvider.getDescriptor(key, scope, project));
                    }
                    if (descriptors.isEmpty()) {
                        return this.emptyResult();
                    }
                    XmlAttributeDescriptor[] result = descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
                    return CachedValueProvider.Result.create((Object)result, (Object[])ContainerUtil.map2Array(descriptors, PsiElement.class, (Function)new Function<XmlAttributeDescriptor, PsiElement>(){

                        public PsiElement fun(XmlAttributeDescriptor descriptor) {
                            return descriptor.getDeclaration();
                        }
                    }));
                }

                private CachedValueProvider.Result<XmlAttributeDescriptor[]> emptyResult() {
                    return CachedValueProvider.Result.create((Object)XmlAttributeDescriptor.EMPTY, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            });
            value = cache.putIfAbsent(name, newValue);
            value = value == null ? newValue : value;
        }
        return (XmlAttributeDescriptor[])value.getValue();
    }

    private static ConcurrentMap<String, CachedValue<XmlAttributeDescriptor[]>> getCache(UserDataHolderEx holder) {
        ConcurrentMap cache = (ConcurrentMap)holder.getUserData(CACHE);
        if (cache == null) {
            cache = (ConcurrentMap)holder.putUserDataIfAbsent(CACHE, (Object)ContainerUtil.newConcurrentMap());
        }
        return cache;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        if (!HtmlUtil.isHtmlTag((XmlTag)context)) {
            return null;
        }
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        XmlAttributeDescriptor descriptor = CssAttributeDescriptorsProvider.getDescriptor(context.getLocalName() + "." + attributeName, scope, context.getProject());
        return descriptor != null ? descriptor : CssAttributeDescriptorsProvider.getDescriptor("*." + attributeName, scope, context.getProject());
    }

    private static XmlAttributeDescriptor getDescriptor(String attributeIndexKey, GlobalSearchScope scope, Project project) {
        final Ref result = Ref.create();
        StubIndex.getInstance().processElements(CssAttributeIndex.KEY, (Object)attributeIndexKey, project, scope, CssAttribute.class, (Processor)new Processor<CssAttribute>(){

            public boolean process(CssAttribute attribute) {
                result.set((Object)new CssAttributeDescriptor(attribute));
                return false;
            }
        });
        return (XmlAttributeDescriptor)result.get();
    }

    private static class CssAttributeDescriptor
    extends BasicXmlAttributeDescriptor
    implements XmlAttributeDescriptorEx {
        private CssAttribute myAttribute;

        public CssAttributeDescriptor(CssAttribute attribute) {
            this.myAttribute = attribute;
        }

        @Nullable
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            if (newTargetName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "com/intellij/psi/css/CssAttributeDescriptorsProvider$CssAttributeDescriptor", "handleTargetRename"));
            }
            return null;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        public boolean isEnumerated() {
            return false;
        }

        public PsiElement getDeclaration() {
            return this.myAttribute;
        }

        public String getName() {
            return this.myAttribute.getAttributeName();
        }

        public void init(PsiElement element) {
        }

        public Object[] getDependences() {
            return new Object[]{this.myAttribute};
        }

        public boolean isFixed() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public String[] getEnumeratedValues() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }
}

