/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssMinifiedFileChecker;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMinifiedFilesFilter
extends GeneratedSourcesFilter {
    private boolean enableMinifiedFilesFilterInTests = false;

    public boolean isGeneratedSource(final @NotNull VirtualFile file, final @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/CssMinifiedFilesFilter", "isGeneratedSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/CssMinifiedFilesFilter", "isGeneratedSource"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.enableMinifiedFilesFilterInTests) {
            return false;
        }
        if (file.isDirectory() || !file.isValid() || file.getCanonicalPath() == null) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof LanguageFileType) || !((LanguageFileType)fileType).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return PsiManager.getInstance((Project)project).findFile(file);
            }
        });
        return psiFile != null && CssMinifiedFilesFilter.isMinified(file, psiFile) != false;
    }

    private static Boolean isMinified(final @NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/CssMinifiedFilesFilter", "isMinified"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/css/CssMinifiedFilesFilter", "isMinified"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)CssMinifiedFileChecker.isMinifiedFile(file), (Object[])new Object[]{file});
            }
        });
    }

    public static void enableMinifiedFilesFilterInTests(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/psi/css/CssMinifiedFilesFilter", "enableMinifiedFilesFilterInTests"));
        }
        final CssMinifiedFilesFilter instance = (CssMinifiedFilesFilter)((Object)GeneratedSourcesFilter.EP_NAME.findExtension(CssMinifiedFilesFilter.class));
        if (instance != null) {
            instance.enableMinifiedFilesFilterInTests = true;
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    instance.enableMinifiedFilesFilterInTests = false;
                }
            });
        }
    }
}

