/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiTreeChangeProcessor
extends PsiTreeChangePreprocessorBase {
    public CssPsiTreeChangeProcessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "<init>"));
        }
        super(project);
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "treeChanged"));
        }
        PsiFile file = event.getFile();
        if (file instanceof CssFile || file instanceof XmlFile || event.getChild() instanceof CssStylesheet) {
            super.treeChanged(event);
        }
    }

    public boolean isInsideCodeBlock(@Nullable PsiElement element) {
        boolean inSelector;
        if (element instanceof PsiFileSystemItem || element != null && element.getContainingFile().getLanguage() != CSSLanguage.INSTANCE) {
            return false;
        }
        boolean bl = inSelector = PsiTreeUtil.getParentOfType((PsiElement)element, CssSelectorList.class, (boolean)false) != null;
        if (inSelector) {
            return false;
        }
        CssBlock parentBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        return parentBlock != null && PsiTreeUtil.getParentOfType((PsiElement)parentBlock, CssBlock.class, (boolean)true) == null;
    }
}

