/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.actions.ruleset.CssSelectTargetPopupFactory;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSelectorAction
extends BaseRefactoringIntentionAction {
    private static final String CREATE_SELECTOR_ID_STRING = "createCssSelectorIntention";
    public static final Key<StyleCreator> EXPLICITLY_CHOSEN_STYLE_CREATOR = new Key("EXPLICITLY_CHOSEN_STYLE_CREATOR");

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"create.selector.action", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CreateSelectorAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"create.selector.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CreateSelectorAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CreateSelectorAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CreateSelectorAction", "isAvailable"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)containingFile)) {
            return false;
        }
        HtmlCssClassOrIdReference reference = CreateSelectorAction.getClassOrIdReference(element, editor);
        if (reference != null && containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            return document != null && reference.multiResolve(false).length == 0;
        }
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CreateSelectorAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CreateSelectorAction", "invoke"));
        }
        final PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        final HtmlCssClassOrIdReference classOrIdReference = CreateSelectorAction.getClassOrIdReference(element, editor);
        if (classOrIdReference != null) {
            Pass<StyleCreator> chooseCreatorCallback = new Pass<StyleCreator>(){

                public void pass(final StyleCreator styleCreator) {
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            CssRuleset createdRuleset = styleCreator.createStyleDeclaration(classOrIdReference, new CssDeclaration[0]);
                            if (createdRuleset != null) {
                                CssBlock block = createdRuleset.getBlock();
                                if (block != null && block.isValid() && containingFile == block.getContainingFile()) {
                                    CreateSelectorAction.navigateInBlock(block, editor);
                                } else if (createdRuleset.canNavigate()) {
                                    createdRuleset.navigate(true);
                                }
                            }
                        }
                    }, CreateSelectorAction.this.getText(), (Object)CreateSelectorAction.CREATE_SELECTOR_ID_STRING, editor.getDocument());
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StyleCreator styleCreator = (StyleCreator)project.getUserData(EXPLICITLY_CHOSEN_STYLE_CREATOR);
                assert (styleCreator != null);
                chooseCreatorCallback.pass((Object)styleCreator);
            } else {
                CssSelectTargetPopupFactory.createSelectTargetPopup(this.getText(), containingFile, chooseCreatorCallback).showInBestPositionFor(editor);
            }
        }
    }

    @Nullable
    private static HtmlCssClassOrIdReference getClassOrIdReference(PsiElement element, Editor editor) {
        PsiReference[] references;
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)false);
        PsiReference[] psiReferenceArray = references = xmlAttributeValue != null ? xmlAttributeValue.getReferences() : PsiReference.EMPTY_ARRAY;
        if (xmlAttributeValue != null && references.length > 0) {
            int inElementOffset = editor.getCaretModel().getOffset() - xmlAttributeValue.getTextOffset();
            for (PsiReference each : references) {
                TextRange range;
                UnfairTextRange textRange;
                if (!(each instanceof HtmlCssClassOrIdReference) || !(textRange = new UnfairTextRange((range = each.getRangeInElement()).getStartOffset() - 1, range.getEndOffset())).contains(inElementOffset)) continue;
                return (HtmlCssClassOrIdReference)each;
            }
        }
        return null;
    }

    private static void navigateInBlock(CssBlock block, Editor editor) {
        Object[] declarations = block.getDeclarations();
        CssDeclaration firstDeclaration = (CssDeclaration)ArrayUtil.getFirstElement((Object[])declarations);
        if (firstDeclaration != null && firstDeclaration.canNavigate()) {
            firstDeclaration.navigate(true);
        } else {
            PsiElement lBrace = block.getLBrace();
            if (lBrace != null) {
                editor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

