/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.CssSelectTargetPopupFactory;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringTokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractInlineCssAction
extends BaseRefactoringIntentionAction {
    public static final Key<StyleCreator> EXPLICITLY_CHOSEN_STYLE_CREATOR = new Key("EXPLICITLY_CHOSEN_STYLE_CREATOR");
    public static final Key<String> EXPLICITLY_CHOSEN_SELECTOR = new Key("EXPLICITLY_CHOSEN_SELECTOR");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.css.actions.extract.ExtractInlineCssAction");
    private static final String EXTRACT_INLINE_CSS_ID_STRING = "extractInlineCss";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/ExtractInlineCssAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/ExtractInlineCssAction", "isAvailable"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)containingFile)) {
            return false;
        }
        CssBlock cssBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class);
        return cssBlock != null && cssBlock.getParent() instanceof XmlAttributeValue;
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/ExtractInlineCssAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/ExtractInlineCssAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/ExtractInlineCssAction", "invoke"));
        }
        final PsiFile file = element.getContainingFile();
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class});
        final CssBlock block = (CssBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssBlock.class});
        if (!ApplicationManager.getApplication().isUnitTestMode() && declaration != null && block != null && block.getDeclarations().length > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)Lists.newArrayList((Object[])new CssElement[]{declaration, block}), (Pass)new Pass<CssElement>(){

                public void pass(CssElement expression) {
                    CssDeclaration[] cssDeclarationArray;
                    if (expression instanceof CssBlock) {
                        cssDeclarationArray = ((CssBlock)expression).getDeclarations();
                    } else {
                        CssDeclaration[] cssDeclarationArray2 = new CssDeclaration[1];
                        cssDeclarationArray = cssDeclarationArray2;
                        cssDeclarationArray2[0] = (CssDeclaration)expression;
                    }
                    ExtractInlineCssAction.this.extractDeclarations(project, editor, file, block, cssDeclarationArray);
                }
            }, (Function)new Function<CssElement, String>(){

                public String fun(@NotNull CssElement expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/css/actions/ExtractInlineCssAction$2", "fun"));
                    }
                    return expression.getText();
                }
            });
        } else if (block != null) {
            this.extractDeclarations(project, editor, file, block, block.getDeclarations());
        } else {
            this.showExtractErrorMessage(project, editor);
        }
    }

    private void extractDeclarations(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file, @NotNull CssBlock ownerBlock, final @NotNull CssDeclaration[] declarations) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/ExtractInlineCssAction", "extractDeclarations"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/ExtractInlineCssAction", "extractDeclarations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ExtractInlineCssAction", "extractDeclarations"));
        }
        if (ownerBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlock", "com/intellij/psi/css/actions/ExtractInlineCssAction", "extractDeclarations"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ExtractInlineCssAction", "extractDeclarations"));
        }
        if (declarations.length == 0) {
            return;
        }
        final List<String> selectorNameCandidates = AbstractTagUtil.getPossibleSelectorsForTag(AbstractTagUtil.findInjectionHostTagByCssElement((CssElement)ownerBlock));
        final String defaultSelectorValue = (String)Iterables.getFirst(selectorNameCandidates, (Object)".class");
        XmlAttribute styleAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)ownerBlock, XmlAttribute.class);
        if (styleAttribute == null) {
            this.showExtractErrorMessage(project, editor);
            return;
        }
        final ExtractInlineCssCallback createStyleCallback = new ExtractInlineCssCallback(project, ownerBlock, declarations, styleAttribute, editor);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StyleCreator styleCreator = (StyleCreator)project.getUserData(EXPLICITLY_CHOSEN_STYLE_CREATOR);
            String selector = StringUtil.notNullize((String)((String)project.getUserData(EXPLICITLY_CHOSEN_SELECTOR)), (String)defaultSelectorValue);
            assert (styleCreator != null);
            styleCreator.createStyleDeclarationInteractively(editor, selector, Lists.newArrayList((Object[])new String[]{selector}), createStyleCallback, declarations);
            return;
        }
        CssSelectTargetPopupFactory.createSelectTargetPopup(this.getText(), file, new Pass<StyleCreator>(){

            public void pass(final @Nullable StyleCreator creator) {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        LOG.assertTrue(creator != null);
                        creator.createStyleDeclarationInteractively(editor, defaultSelectorValue, selectorNameCandidates, createStyleCallback, declarations);
                    }
                }, ExtractInlineCssAction.this.getText(), (Object)ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, editor.getDocument());
            }
        }).showInBestPositionFor(editor);
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.extract.embedded.css.action", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ExtractInlineCssAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.extract.embedded.css.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ExtractInlineCssAction", "getFamilyName"));
        }
        return string;
    }

    private static void deleteSourceDeclarations(@NotNull CssBlock ownerBlock, CssDeclaration ... declarations) {
        if (ownerBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerBlock", "com/intellij/psi/css/actions/ExtractInlineCssAction", "deleteSourceDeclarations"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ExtractInlineCssAction", "deleteSourceDeclarations"));
        }
        for (CssDeclaration declaration : declarations) {
            PsiElement semicolon = PsiTreeUtil.nextVisibleLeaf((PsiElement)declaration);
            if (semicolon != null && semicolon.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON) {
                ownerBlock.deleteChildRange((PsiElement)declaration, semicolon);
                continue;
            }
            declaration.delete();
        }
    }

    private static void cleanUpXmlAfterExtracting(@NotNull String selectorText, @NotNull XmlAttribute attribute) {
        if (selectorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorText", "com/intellij/psi/css/actions/ExtractInlineCssAction", "cleanUpXmlAfterExtracting"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/css/actions/ExtractInlineCssAction", "cleanUpXmlAfterExtracting"));
        }
        XmlTag tag = attribute.getParent();
        if (tag != null) {
            ExtractInlineCssAction.appendMissingIdOrClassDeclarations(tag, selectorText);
            String value = attribute.getValue();
            if (value == null || value.trim().isEmpty()) {
                PsiElement prevSibling = attribute.getPrevSibling();
                if (prevSibling instanceof PsiWhiteSpace) {
                    tag.deleteChildRange(prevSibling, (PsiElement)attribute);
                } else {
                    attribute.delete();
                }
            } else {
                CodeEditUtil.markToReformat((ASTNode)attribute.getNode(), (boolean)true);
            }
        }
    }

    private static void appendMissingIdOrClassDeclarations(@NotNull XmlTag parent, String newSelectorName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/css/actions/ExtractInlineCssAction", "appendMissingIdOrClassDeclarations"));
        }
        StringTokenizer st = new StringTokenizer(newSelectorName, "#.", true);
        boolean _class = false;
        boolean _id = false;
        block3: while (st.hasMoreTokens()) {
            String idAttribute;
            String s = st.nextToken();
            if (s.length() == 1) {
                switch (s.charAt(0)) {
                    case '.': {
                        _class = true;
                        continue block3;
                    }
                }
                _id = true;
                continue;
            }
            if (_class) {
                XmlAttribute classAttribute = parent.getAttribute("class");
                if (classAttribute == null) {
                    parent.setAttribute("class", s);
                    continue;
                }
                String classes = Strings.nullToEmpty((String)classAttribute.getValue());
                List list = StringUtil.split((String)classes, (String)" ");
                if (list.contains(s)) continue;
                parent.setAttribute("class", classAttribute.getValue() + " " + s);
                continue;
            }
            if (!_id || (idAttribute = parent.getAttributeValue("id")) != null && idAttribute.equals(s)) continue;
            parent.setAttribute("id", s);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void showExtractErrorMessage(@NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/ExtractInlineCssAction", "showExtractErrorMessage"));
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"introduce.selection.error"), (String)this.getText(), null);
    }

    private class ExtractInlineCssCallback
    implements CreateStyleCallback {
        private final Project myProject;
        private final CssBlock myOwnerBlock;
        private final CssDeclaration[] myDeclarations;
        private final XmlAttribute myStyleAttribute;
        private final Editor myEditor;

        public ExtractInlineCssCallback(Project project, CssBlock ownerBlock, CssDeclaration[] declarations, XmlAttribute styleAttribute, Editor editor) {
            this.myProject = project;
            this.myOwnerBlock = ownerBlock;
            this.myDeclarations = declarations;
            this.myStyleAttribute = styleAttribute;
            this.myEditor = editor;
        }

        @Override
        public void after(final @NotNull String newSelector, @Nullable CssRuleset createdRuleset) {
            if (newSelector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelector", "com/intellij/psi/css/actions/ExtractInlineCssAction$ExtractInlineCssCallback", "after"));
            }
            if (createdRuleset != null) {
                CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                ExtractInlineCssAction.deleteSourceDeclarations(ExtractInlineCssCallback.this.myOwnerBlock, ExtractInlineCssCallback.this.myDeclarations);
                                ExtractInlineCssAction.cleanUpXmlAfterExtracting(newSelector, ExtractInlineCssCallback.this.myStyleAttribute);
                            }
                        });
                    }
                }, ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, (Object)ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, this.myEditor.getDocument());
            } else {
                ExtractInlineCssAction.this.showExtractErrorMessage(this.myProject, this.myEditor);
            }
        }
    }
}

