/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public enum ColorDeclarationType {
    RGB,
    RGBA,
    HSL,
    HSLA,
    HEX,
    TEXTUAL;


    public static ColorDeclarationType fromColorTerm(@NotNull PsiElement colorTerm) {
        if (colorTerm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorTerm", "com/intellij/psi/css/browse/ColorDeclarationType", "fromColorTerm"));
        }
        String colorString = colorTerm.getText();
        if (colorString.startsWith("rgba")) {
            return RGBA;
        }
        if (colorString.startsWith("rgb")) {
            return RGB;
        }
        if (colorString.startsWith("hsla")) {
            return HSLA;
        }
        if (colorString.startsWith("hsl")) {
            return HSL;
        }
        if (StringUtil.startsWithChar((CharSequence)colorString, (char)'#')) {
            return HEX;
        }
        return TEXTUAL;
    }

    public boolean withAlphaChannel() {
        return this == RGBA || this == HSLA;
    }
}

