/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.UnicodeUtil;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorSelfReference;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssIdSelectorImpl
extends CssNamedStubElement<CssNamedStub<CssIdSelector>>
implements CssIdSelector {
    public CssIdSelectorImpl(@NotNull CssNamedStub<CssIdSelector> stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssIdSelectorImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssIdSelectorImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssIdSelectorImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssIdSelectorImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String getName() {
        CssNamedStub stub = (CssNamedStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssIdSelectorImpl", "getName"));
            }
            return string;
        }
        String text = CssPsiUtil.getTokenText((PsiElement)this.getNameIdentifier());
        String string = UnicodeUtil.transformUnicodes(!text.isEmpty() ? text.substring(1) : text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssIdSelectorImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public CssSelectorSuffixType getType() {
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.ID;
        if (cssSelectorSuffixType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssIdSelectorImpl", "getType"));
        }
        return cssSelectorSuffixType;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssIdSelectorImpl", "setName"));
        }
        PsiElement token = this.getNameIdentifier();
        if (token != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)("#" + name));
        }
        return this;
    }

    @Nullable
    private PsiElement getNameIdentifier() {
        return this.findChildByType(CssElementTypes.CSS_HASH);
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/CssIdSelectorImpl", "isMatch"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/impl/CssIdSelectorImpl", "isMatch"));
        }
        return CssResolveUtil.checkTagForMatching(tag, "id", this.getName(), resolver);
    }

    public ItemPresentation getPresentation() {
        return new CssNamedItemPresentation((PsiNamedElement)this, "#" + this.getName());
    }

    public Icon getIcon(int flags) {
        return AllIcons.Xml.Html_id;
    }

    public int getTextOffset() {
        return this.getTextRange().isEmpty() ? super.getTextOffset() : super.getTextOffset() + 1;
    }

    public PsiReference getReference() {
        int startOffset = this.getTextOffset() - this.getTextRange().getStartOffset();
        return new CssSelectorSelfReference((CssSelectorSuffix)this, TextRange.from((int)startOffset, (int)this.getName().length()));
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }
}

