/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssOperationImpl
extends CssElementImpl
implements CssOperation {
    protected CssOperationImpl(@NotNull IElementType operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/psi/css/impl/CssOperationImpl", "<init>"));
        }
        super(operation);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssOperationImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssOperation((CssOperation)this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public CssTermType getTermType() {
        PsiElement firstTerm = this.getFirstChild();
        if (firstTerm != null && firstTerm.getNode().getElementType() == CssElementTypes.CSS_LPAREN) {
            firstTerm = firstTerm.getNextSibling();
        }
        if (this.getElementType() == CssElementTypes.CSS_UNARY_OPERATION) {
            if (firstTerm instanceof CssTerm) {
                CssTermType cssTermType = ((CssTerm)firstTerm).getTermType();
                if (cssTermType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                }
                return cssTermType;
            }
        } else {
            PsiElement secondTerm = this.getSecondTerm();
            if (firstTerm instanceof CssTerm && secondTerm instanceof CssTerm) {
                IElementType operatorType;
                CssTermType leftType = ((CssTerm)firstTerm).getTermType();
                CssTermType rightType = ((CssTerm)secondTerm).getTermType();
                if (leftType == CssTermType.UNKNOWN || rightType == CssTermType.UNKNOWN) {
                    CssTermType cssTermType = CssTermType.UNKNOWN;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
                if (leftType == CssTermTypes.PERCENTAGE) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(rightType) ? CssTermTypes.PERCENTAGE : rightType;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
                if (rightType == CssTermTypes.PERCENTAGE) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(leftType) ? CssTermTypes.PERCENTAGE : leftType;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
                PsiElement operator = this.getToken(CssMathParser.OPERATORS);
                IElementType iElementType = operatorType = operator != null ? operator.getNode().getElementType() : null;
                if (operatorType == CssElementTypes.CSS_MINUS || operatorType == CssElementTypes.CSS_PLUS) {
                    if (leftType == rightType) {
                        CssTermType cssTermType = leftType;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    if (leftType == CssTermTypes.NUMBER) {
                        CssTermType cssTermType = rightType == CssTermTypes.INTEGER ? CssTermTypes.NUMBER : rightType;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    if (rightType == CssTermTypes.NUMBER) {
                        CssTermType cssTermType = leftType == CssTermTypes.INTEGER ? CssTermTypes.NUMBER : leftType;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    if (leftType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = rightType;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    if (rightType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = leftType;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    CssTermType cssTermType = CssTermType.UNKNOWN;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
                if (operatorType == CssElementTypes.CSS_ASTERISK) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(rightType) ? leftType : rightType;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
                if (operatorType == CssElementTypes.CSS_SLASH) {
                    if (rightType == CssTermTypes.NUMBER && leftType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = CssTermTypes.NUMBER;
                        if (cssTermType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                        }
                        return cssTermType;
                    }
                    CssTermType cssTermType = leftType;
                    if (cssTermType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
                    }
                    return cssTermType;
                }
            }
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssOperationImpl", "getTermType"));
        }
        return cssTermType;
    }

    private static boolean numberOrInteger(CssTermType termType) {
        return termType == CssTermTypes.INTEGER || termType == CssTermTypes.NUMBER;
    }

    @Nullable
    private PsiElement getSecondTerm() {
        PsiElement secondTerm = this.getLastChild();
        if (secondTerm != null && secondTerm.getNode().getElementType() == CssElementTypes.CSS_RPAREN) {
            secondTerm = secondTerm.getPrevSibling();
        }
        return secondTerm;
    }
}

