/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.CssStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssRulesetImpl
extends CssStubElement<CssStub>
implements CssRuleset {
    public CssRulesetImpl(@NotNull CssStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssRulesetImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssRulesetImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssRulesetImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssRulesetImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public CssSelector[] getSelectors() {
        CssSelectorList selectorList = this.getSelectorList();
        CssSelector[] cssSelectorArray = selectorList != null ? selectorList.getSelectors() : CssSelector.EMPTY_ARRAY;
        if (cssSelectorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetImpl", "getSelectors"));
        }
        return cssSelectorArray;
    }

    @Nullable
    public CssSelectorList getSelectorList() {
        return (CssSelectorList)this.getStubOrPsiChild(CssElementTypes.CSS_SELECTOR_LIST);
    }

    @Nullable
    public CssBlock getBlock() {
        return (CssBlock)this.findChildByClass(CssBlock.class);
    }

    @NotNull
    public String getPresentableText() {
        String string = StringUtil.join((Object[])this.getSelectors(), (Function)new Function<CssSelector, String>(){

            public String fun(CssSelector selector) {
                return selector.getPresentableText();
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetImpl", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public CssRuleset[] getNestedRulesets() {
        CssStub stub = (CssStub)this.getStub();
        if (stub != null) {
            CssRuleset[] cssRulesetArray = (CssRuleset[])stub.getChildrenByType((IElementType)CssElementTypes.CSS_RULESET, CssRuleset.ARRAY_FACTORY);
            if (cssRulesetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetImpl", "getNestedRulesets"));
            }
            return cssRulesetArray;
        }
        CssRuleset[] result = (CssRuleset[])PsiTreeUtil.getChildrenOfType((PsiElement)this.getBlock(), CssRuleset.class);
        CssRuleset[] cssRulesetArray = (CssRuleset[])ObjectUtils.notNull((Object)result, (Object)CssRuleset.EMPTY_ARRAY);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetImpl", "getNestedRulesets"));
        }
        return cssRulesetArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssRulesetImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssRuleset((CssRuleset)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

