/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueDescriptorMapper {
    @Nullable
    private final PsiElement myStartElement;
    @Nullable
    private final PsiElement myStopElement;

    public CssValueDescriptorMapper(@Nullable CssTermList termList) {
        this(CssPsiUtil.getFirstDeepestTerm((PsiElement)termList), CssPsiUtil.getLastDeepestTerm((PsiElement)termList));
    }

    public CssValueDescriptorMapper(@Nullable PsiElement startElement, @Nullable PsiElement stopElement) {
        this.myStartElement = startElement;
        this.myStopElement = stopElement;
    }

    @NotNull
    public CssValueMatchData mapValue(@NotNull CssValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapValue"));
        }
        CssValueMatchData cssValueMatchData = this.mapValue(this.myStartElement, descriptor);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapValue"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapValue(@Nullable PsiElement current, @NotNull CssValueDescriptor descriptor) {
        CssValueMatchData firstMatchData;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapValue"));
        }
        ProgressManager.checkCanceled();
        current = CssPsiUtil.getFirstDeepestTerm((PsiElement)current);
        int maxOccur = descriptor.getMaxOccur();
        int minOccur = descriptor.getMinOccur();
        boolean matched = true;
        ArrayList matchData = ContainerUtil.newArrayList();
        int attempt = 0;
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)current);
        CssValueDescriptor separator = null;
        if (descriptorProvider != null) {
            separator = (CssValueDescriptor)ContainerUtil.getFirstItem((Collection)descriptorProvider.getNamedValueDescriptors("comma-separator", descriptor));
        }
        while (attempt++ < maxOccur || maxOccur == -1) {
            boolean separatorMatched = true;
            if (attempt != 1 && descriptor.isCommaSeparated()) {
                assert (separator != null);
                CssValueMatchData separatorMatchData = this.mapValue(current, separator);
                matchData.add(separatorMatchData);
                separatorMatched = separatorMatchData.isMatched();
                if (separatorMatched) {
                    current = this.nextElement(separatorMatchData.getLastMatchedElement(), true, current);
                }
            }
            CssValueMatchData nodeMatch = this.match(descriptor, current);
            if (separatorMatched && nodeMatch.isMatched()) {
                PsiElement lastMatchedElement = nodeMatch.getLastMatchedElement();
                if (lastMatchedElement != null) {
                    current = lastMatchedElement;
                }
            } else {
                if (attempt > minOccur) break;
                matched = false;
                matchData.add(nodeMatch);
                break;
            }
            matchData.add(nodeMatch);
            if (attempt < maxOccur || maxOccur == -1) {
                current = this.nextElement(current, true);
            }
            if (current != null) continue;
            if (attempt >= minOccur) break;
            matched = false;
            break;
        }
        if (matchData.size() == 1 && (firstMatchData = (CssValueMatchData)ContainerUtil.getFirstItem((List)matchData)) != null) {
            CssValueMatchData cssValueMatchData = firstMatchData;
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapValue"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = new CssValueMatchData(descriptor, matched, (List)matchData);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapValue"));
        }
        return cssValueMatchData;
    }

    private CssValueMatchData match(@NotNull CssValueDescriptor descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "match"));
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
        if (descriptor instanceof CssGroupValue) {
            return this.matchGroupValue((CssGroupValue)descriptor, element);
        }
        if (descriptor instanceof CssInlineValue && descriptorProvider != null) {
            return this.matchInlineValue((CssInlineValue)descriptor, element, descriptorProvider);
        }
        if (descriptor instanceof CssPropertyReferenceValue && descriptorProvider != null) {
            return this.matchPropertyReferenceValue((CssPropertyReferenceValue)descriptor, element, descriptorProvider);
        }
        if (element == null) {
            return CssValueMatchData.fail((CssValueDescriptor)descriptor);
        }
        CssValueMatchData result = new CssValueMatchData(descriptor, CssValueDescriptorMapper.getValueValidator(element).isValid(element, descriptor));
        if (result.isMatched()) {
            result.addMatchedElement(element);
        }
        return result;
    }

    @NotNull
    private CssValueMatchData matchGroupValue(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchGroupValue"));
        }
        switch (descriptor.getType()) {
            case OR: {
                CssValueMatchData cssValueMatchData = this.mapGroupOrDescriptor(descriptor, element);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchGroupValue"));
                }
                return cssValueMatchData;
            }
            case AND: {
                CssValueMatchData cssValueMatchData = this.mapGroupAndDescriptor(descriptor, element);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchGroupValue"));
                }
                return cssValueMatchData;
            }
            case ANY: {
                CssValueMatchData cssValueMatchData = this.mapGroupAnyDescriptor(descriptor, element);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchGroupValue"));
                }
                return cssValueMatchData;
            }
            case ALL: {
                CssValueMatchData cssValueMatchData = this.mapGroupAllDescriptor(descriptor, element);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchGroupValue"));
                }
                return cssValueMatchData;
            }
        }
        throw new IllegalArgumentException("Unknown group type: " + (Object)((Object)descriptor.getType()));
    }

    @NotNull
    private CssValueMatchData matchInlineValue(@NotNull CssInlineValue descriptor, @Nullable PsiElement element, @NotNull CssElementDescriptorProvider descriptorProvider) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchInlineValue"));
        }
        if (descriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorProvider", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchInlineValue"));
        }
        Collection inlineValues = CssDescriptorsUtil.sortDescriptors((Collection)descriptorProvider.getNamedValueDescriptors(descriptor.getRefId(), (CssValueDescriptor)descriptor));
        CssValueMatchData matchData = this.matchFirstLongest(inlineValues, element);
        if (matchData != null) {
            CssValueMatchData cssValueMatchData = new CssValueMatchData((CssValueDescriptor)descriptor, matchData.isMatched(), Collections.singletonList(matchData));
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchInlineValue"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchInlineValue"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData matchPropertyReferenceValue(final @NotNull CssPropertyReferenceValue descriptor, @Nullable PsiElement element, @NotNull CssElementDescriptorProvider descriptorProvider) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchPropertyReferenceValue"));
        }
        if (descriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorProvider", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchPropertyReferenceValue"));
        }
        Collection propertyDescriptors = descriptorProvider.findPropertyDescriptors(descriptor.getPropertyName(), element);
        CssValueMatchData matchData = this.matchFirstLongest(ContainerUtil.map((Collection)propertyDescriptors, (Function)new NotNullFunction<CssPropertyDescriptor, CssValueDescriptor>(){

            @NotNull
            public CssValueDescriptor fun(CssPropertyDescriptor propertyDescriptor) {
                CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.withParent(propertyDescriptor.getValueDescriptor(), descriptor);
                if (cssValueDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper$1", "fun"));
                }
                return cssValueDescriptor;
            }
        }), element);
        if (matchData != null) {
            CssValueMatchData cssValueMatchData = new CssValueMatchData((CssValueDescriptor)descriptor, matchData.isMatched(), Collections.singletonList(matchData));
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchPropertyReferenceValue"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchPropertyReferenceValue"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupAllDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAllDescriptor"));
        }
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList childrenMatchData = ContainerUtil.newArrayList();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        for (CssValueDescriptor child : descriptor.getChildren()) {
            boolean matched;
            boolean childIsRequired = CssValueDescriptorMapper.isRequired(child);
            if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else if (childIsRequired) {
                    childrenMatchData.add(separatorMatchData);
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    if (cssValueMatchData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAllDescriptor"));
                    }
                    return cssValueMatchData;
                }
                element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            }
            CssValueMatchData childMatchData = this.mapValue(element, child);
            boolean bl = matched = element != null && (whitespacesShouldBeIgnored || !(element instanceof PsiWhiteSpace)) && childMatchData.isMatched();
            if (matched) {
                childrenMatchData.add(childMatchData);
            } else if (childIsRequired) {
                childrenMatchData.add(childMatchData);
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAllDescriptor"));
                }
                return cssValueMatchData;
            }
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAllDescriptor"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAllDescriptor"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupAnyDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
        }
        ArrayList restChildrenDescriptors = ContainerUtil.newArrayList(descriptor.getChildren());
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList childrenMatchData = ContainerUtil.newArrayList();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        boolean first = true;
        while (!restChildrenDescriptors.isEmpty() && (element != null || first)) {
            PsiElement nextElement;
            if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else if (CssValueDescriptorMapper.isRequired(separatorMatchData.getDescriptor()) || CssValueDescriptorMapper.isRequired(restChildrenDescriptors)) {
                    childrenMatchData.add(separatorMatchData);
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    if (cssValueMatchData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                    }
                    return cssValueMatchData;
                }
                element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            }
            if (element == null) {
                for (CssValueDescriptor requiredChild : CssValueDescriptorMapper.getAllRequired(restChildrenDescriptors)) {
                    childrenMatchData.add(this.match(requiredChild, null));
                }
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                }
                return cssValueMatchData;
            }
            Collection<CssValueMatchData> longestMatchedChildrenData = this.matchAllLongest(restChildrenDescriptors, element);
            if (longestMatchedChildrenData.isEmpty()) {
                if (!first) break;
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                }
                return cssValueMatchData;
            }
            CssValueMatchData childMatchData = (CssValueMatchData)ContainerUtil.getFirstItem(longestMatchedChildrenData);
            assert (childMatchData != null);
            if (longestMatchedChildrenData.size() > 1 && (nextElement = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, this.nextElement(element, whitespacesShouldBeIgnored))) != null) {
                for (CssValueDescriptor childDescriptor : restChildrenDescriptors) {
                    CssValueMatchData nextChildData = this.mapValue(nextElement, childDescriptor);
                    if (!nextChildData.isMatched()) continue;
                    CssValueDescriptor nextChildDataDescriptor = nextChildData.getDescriptor();
                    Iterator<CssValueMatchData> iterator = longestMatchedChildrenData.iterator();
                    while (iterator.hasNext()) {
                        CssValueMatchData matchData = iterator.next();
                        if (!matchData.getDescriptor().equals(nextChildDataDescriptor)) continue;
                        iterator.remove();
                    }
                }
                childMatchData = (CssValueMatchData)ContainerUtil.getFirstItem(longestMatchedChildrenData, (Object)childMatchData);
            }
            CssValueMatchData lastMatched = (CssValueMatchData)ContainerUtil.getLastItem((List)childrenMatchData);
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched()) {
                if (lastMatched == null) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    if (cssValueMatchData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                    }
                    return cssValueMatchData;
                }
                if (lastMatched.getDescriptor() != separator) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
                    if (cssValueMatchData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                    }
                    return cssValueMatchData;
                }
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
                }
                return cssValueMatchData;
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            first = false;
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAnyDescriptor"));
        }
        return cssValueMatchData;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private CssValueMatchData mapGroupAndDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
        }
        ArrayList restChildrenDescriptors = ContainerUtil.newArrayList(descriptor.getChildren());
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList childrenMatchData = ContainerUtil.newArrayList();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        boolean first = true;
        while (!restChildrenDescriptors.isEmpty() && (element != null || first)) {
            CssValueMatchData childMatchData;
            block16: {
                first = false;
                if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                    CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                    childrenMatchData.add(separatorMatchData);
                    if (!separatorMatchData.isMatched() && CssValueDescriptorMapper.isRequired(separatorMatchData.getDescriptor()) && CssValueDescriptorMapper.isRequired(restChildrenDescriptors)) {
                        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                        if (cssValueMatchData == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
                        }
                        return cssValueMatchData;
                    }
                    element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
                }
                if (element == null) {
                    CssValueDescriptor optionalChild = CssValueDescriptorMapper.findFirstOptional(restChildrenDescriptors);
                    if (optionalChild != null) {
                        childMatchData = CssValueMatchData.success((CssValueDescriptor)optionalChild);
                        break block16;
                    } else {
                        CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                        if (cssValueMatchData == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
                        }
                        return cssValueMatchData;
                    }
                }
                childMatchData = this.matchFirstLongest(restChildrenDescriptors, element);
            }
            if (childMatchData == null) {
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
                }
                return cssValueMatchData;
            }
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched() && CssValueDescriptorMapper.isRequired(childMatchData.getDescriptor())) {
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
                if (cssValueMatchData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
                }
                return cssValueMatchData;
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail((CssValueDescriptor)descriptor, (List)childrenMatchData);
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor, (List)childrenMatchData);
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupAndDescriptor"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupOrDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupOrDescriptor"));
        }
        boolean required = CssValueDescriptorMapper.isRequired(descriptor.getChildren());
        if (element == null) {
            CssValueMatchData cssValueMatchData = new CssValueMatchData((CssValueDescriptor)descriptor, !required);
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupOrDescriptor"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData matchData = this.matchFirstLongest(descriptor.getChildren(), element);
        if (!(required || matchData != null && matchData.isMatched())) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.success((CssValueDescriptor)descriptor);
            if (cssValueMatchData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupOrDescriptor"));
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = new CssValueMatchData((CssValueDescriptor)descriptor, matchData != null && matchData.isMatched(), Collections.singletonList(matchData));
        if (cssValueMatchData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "mapGroupOrDescriptor"));
        }
        return cssValueMatchData;
    }

    @NotNull
    private Collection<CssValueMatchData> matchAllLongest(@NotNull Collection<? extends CssValueDescriptor> descriptors, @Nullable PsiElement element) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchAllLongest"));
        }
        boolean somethingAlreadyMatched = false;
        LinkedList result = ContainerUtil.newLinkedList();
        int maxWeight = -1;
        for (CssValueDescriptor cssValueDescriptor : descriptors) {
            int weight;
            CssValueMatchData childData = this.mapValue(element, cssValueDescriptor);
            if (somethingAlreadyMatched && !childData.isMatched()) continue;
            if (!somethingAlreadyMatched && childData.isMatched()) {
                result.clear();
                somethingAlreadyMatched = true;
            }
            if ((weight = CssValueDescriptorMapper.weightMatchData(childData)) == maxWeight) {
                result.add(childData);
                continue;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            result.clear();
            result.add(childData);
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchAllLongest"));
        }
        return linkedList;
    }

    @Nullable
    private CssValueMatchData matchFirstLongest(@NotNull Collection<? extends CssValueDescriptor> descriptors, @Nullable PsiElement element) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "matchFirstLongest"));
        }
        CssValueMatchData matchedLongestResult = null;
        CssValueMatchData unmatchedLongestResult = null;
        for (CssValueDescriptor cssValueDescriptor : descriptors) {
            CssValueMatchData data = this.mapValue(element, cssValueDescriptor);
            if (data.isMatched()) {
                matchedLongestResult = CssValueDescriptorMapper.compareAndGetMostMatched(matchedLongestResult, data);
                continue;
            }
            unmatchedLongestResult = CssValueDescriptorMapper.compareAndGetMostMatched(unmatchedLongestResult, data);
        }
        return (CssValueMatchData)ObjectUtils.chooseNotNull(matchedLongestResult, unmatchedLongestResult);
    }

    @Nullable
    private static CssValueMatchData compareAndGetMostMatched(@Nullable CssValueMatchData first, @Nullable CssValueMatchData second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        PsiElement firstLastMatchedElement = first.getLastMatchedElement();
        PsiElement secondLastMatchedElement = second.getLastMatchedElement();
        if (firstLastMatchedElement == null && secondLastMatchedElement == null) {
            return null;
        }
        if (firstLastMatchedElement == null) {
            return second;
        }
        if (secondLastMatchedElement == null) {
            return first;
        }
        return firstLastMatchedElement.getTextRange().getEndOffset() >= secondLastMatchedElement.getTextRange().getEndOffset() ? first : second;
    }

    private static boolean lastIsNotSeparator(@NotNull List<CssValueMatchData> childrenMatchData, @NotNull CssValueDescriptor separator) {
        if (childrenMatchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenMatchData", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "lastIsNotSeparator"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "lastIsNotSeparator"));
        }
        CssValueMatchData lastMatched = (CssValueMatchData)ContainerUtil.getLastItem(childrenMatchData);
        return lastMatched != null && lastMatched.getDescriptor() != separator;
    }

    private static boolean lastIsSeparator(@NotNull List<CssValueMatchData> childrenMatchData, @NotNull CssValueDescriptor separator) {
        if (childrenMatchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenMatchData", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "lastIsSeparator"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "lastIsSeparator"));
        }
        CssValueMatchData lastMatched = (CssValueMatchData)ContainerUtil.getLastItem(childrenMatchData);
        return lastMatched != null && lastMatched.getDescriptor() == separator;
    }

    @Nullable
    private static CssValueDescriptor findFirstOptional(@NotNull Collection<CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "findFirstOptional"));
        }
        return (CssValueDescriptor)ContainerUtil.find(descriptors, (Condition)new Condition<CssValueDescriptor>(){

            public boolean value(CssValueDescriptor descriptor) {
                return !CssValueDescriptorMapper.isRequired(descriptor);
            }
        });
    }

    @NotNull
    public static List<CssValueDescriptor> getAllRequired(@NotNull Collection<CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "getAllRequired"));
        }
        List list = ContainerUtil.filter(descriptors, (Condition)new Condition<CssValueDescriptor>(){

            public boolean value(CssValueDescriptor descriptor) {
                return CssValueDescriptorMapper.isRequired(descriptor);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "getAllRequired"));
        }
        return list;
    }

    private static boolean isRequired(CssValueDescriptor descriptor) {
        return descriptor.getMinOccur() != 0;
    }

    private static boolean isRequired(@NotNull Collection<CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "isRequired"));
        }
        for (CssValueDescriptor child : descriptors) {
            if (child.getMinOccur() != 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private PsiElement nextElement(@Nullable PsiElement element, boolean whitespacesShouldBeIgnored) {
        return this.nextElement(element, whitespacesShouldBeIgnored, null);
    }

    @Nullable
    private PsiElement nextElement(@Nullable PsiElement element, boolean whitespacesShouldBeIgnored, @Nullable PsiElement defaultElement) {
        PsiElement firstChild;
        PsiElement parent;
        PsiElement parentTermList;
        if (element == null) {
            return defaultElement;
        }
        PsiElement nextSibling = this.nextVisibleSibling(element, whitespacesShouldBeIgnored);
        if (nextSibling == null && (parentTermList = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{CssTermList.class, CssTerm.class})) != null && (nextSibling = this.nextVisibleSibling(parentTermList, whitespacesShouldBeIgnored)) == null && (parent = parentTermList.getParent()) instanceof CssTerm) {
            nextSibling = this.nextVisibleSibling(parent, whitespacesShouldBeIgnored);
        }
        if (nextSibling instanceof CssTerm && (firstChild = nextSibling.getFirstChild()) instanceof CssTermList) {
            return CssPsiUtil.getFirstDeepestTerm((PsiElement)nextSibling.getFirstChild());
        }
        return CssPsiUtil.getFirstDeepestTerm((PsiElement)nextSibling);
    }

    @Nullable
    private PsiElement nextVisibleSibling(@NotNull PsiElement element, boolean whitespacesShouldBeIgnored) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "nextVisibleSibling"));
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e == this.myStopElement) {
                return e;
            }
            if (this.myStopElement != null && e.getTextRange().getEndOffset() > this.myStopElement.getTextRange().getEndOffset()) {
                return null;
            }
            if (e instanceof PsiComment || whitespacesShouldBeIgnored && e instanceof PsiWhiteSpace) continue;
            return e;
        }
        return null;
    }

    @NotNull
    private static CssValueValidator getValueValidator(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "getValueValidator"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context);
        if (provider == null) {
            CssValueValidatorStub cssValueValidatorStub = new CssValueValidatorStub();
            if (cssValueValidatorStub == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "getValueValidator"));
            }
            return cssValueValidatorStub;
        }
        CssValueValidator cssValueValidator = provider.getValueValidator();
        if (cssValueValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "getValueValidator"));
        }
        return cssValueValidator;
    }

    private static int weightMatchData(@NotNull CssValueMatchData matchData) {
        if (matchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchData", "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper", "weightMatchData"));
        }
        PsiElement lastMatchedElement = matchData.getLastMatchedElement();
        return lastMatchedElement != null ? lastMatchedElement.getTextRange().getEndOffset() : -1;
    }
}

