/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.stubs.index.CssClassIndex;
import com.intellij.psi.css.impl.stubs.index.CssIdIndex;
import com.intellij.psi.css.index.CssTemplateSelectorsIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import org.jetbrains.annotations.NotNull;

public class CssIndexUtil {
    private static final Logger LOG = Logger.getInstance(CssIndexUtil.class);

    private CssIndexUtil() {
    }

    public static void processAllSelectorSuffixes(@NotNull CssSelectorSuffixType type, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super CssSelectorSuffix> processor) {
        block7: {
            block6: {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorSuffixes"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorSuffixes"));
                }
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorSuffixes"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorSuffixes"));
                }
                if (type != CssSelectorSuffixType.CLASS) break block6;
                for (String name : StubIndex.getInstance().getAllKeys(CssClassIndex.KEY, project)) {
                    CssIndexUtil.processSelectorSuffixes(type, name, project, scope, processor);
                }
                break block7;
            }
            if (type != CssSelectorSuffixType.ID) break block7;
            for (String name : StubIndex.getInstance().getAllKeys(CssIdIndex.KEY, project)) {
                CssIndexUtil.processSelectorSuffixes(type, name, project, scope, processor);
            }
        }
    }

    public static void processSelectorSuffixes(@NotNull CssSelectorSuffixType type, @NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super CssSelectorSuffix> processor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorSuffixes"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorSuffixes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorSuffixes"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorSuffixes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorSuffixes"));
        }
        if (type == CssSelectorSuffixType.CLASS) {
            CssIndexUtil.processClasses(name, project, scope, processor);
        } else if (type == CssSelectorSuffixType.ID) {
            CssIndexUtil.processIds(name, project, scope, processor);
        }
    }

    public static void processAllSelectorNamesInScope(@NotNull CssSelectorSuffixType type, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorNamesInScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorNamesInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorNamesInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllSelectorNamesInScope"));
        }
        if (type == CssSelectorSuffixType.CLASS) {
            CssIndexUtil.processAllClassNamesInScope(project, scope, processor);
        } else if (type == CssSelectorSuffixType.ID) {
            CssIndexUtil.processAllIdNamesInScope(project, scope, processor);
        }
    }

    public static void processSelectorNamesFromHtmlAttributes(@NotNull GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorNamesFromHtmlAttributes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processSelectorNamesFromHtmlAttributes"));
        }
        CssIndexUtil.processKeysInScope(CssTemplateSelectorsIndex.KEY, scope, processor);
    }

    public static void processAllIdNamesInScope(@NotNull Project project, GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllIdNamesInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllIdNamesInScope"));
        }
        CssIndexUtil.processKeysInScope(CssIdIndex.KEY, CssSelectorSuffix.class, project, scope, processor);
    }

    public static void processIds(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super CssSelectorSuffix> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processIds"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processIds"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processIds"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processIds"));
        }
        for (CssSelectorSuffix suffix : StubIndex.getElements(CssIdIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssSelectorSuffix.class)) {
            if (processor.process((Object)suffix)) continue;
            return;
        }
    }

    public static void processAllClassNamesInScope(@NotNull Project project, GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllClassNamesInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processAllClassNamesInScope"));
        }
        CssIndexUtil.processKeysInScope(CssClassIndex.KEY, CssSelectorSuffix.class, project, scope, processor);
    }

    public static void processClasses(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super CssSelectorSuffix> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processClasses"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processClasses"));
        }
        for (CssSelectorSuffix suffix : StubIndex.getElements(CssClassIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssSelectorSuffix.class)) {
            if (processor.process((Object)suffix)) continue;
            return;
        }
    }

    public static <T extends PsiElement> void processKeysInScope(@NotNull StubIndexKey<String, T> indexKey, @NotNull Class<T> requiredClass, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        for (String s : StubIndex.getInstance().getAllKeys(indexKey, project)) {
            if (StubIndex.getElements(indexKey, (Object)s, (Project)project, (GlobalSearchScope)scope, requiredClass).isEmpty() || processor.process((Object)s)) continue;
            return;
        }
    }

    public static <T> void processKeysInScope(@NotNull ID<String, T> indexId, @NotNull GlobalSearchScope scope, @NotNull Processor<String> processor) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/stubs/index/CssIndexUtil", "processKeysInScope"));
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        Project project = scope.getProject();
        if (project == null) {
            LOG.error("Scope doesn't contain a project: " + scope.toString() + "[" + scope.getClass().getSimpleName() + "]");
            return;
        }
        for (String s : index.getAllKeys(indexId, project)) {
            if (index.getContainingFiles(indexId, (Object)s, scope).isEmpty()) continue;
            processor.process((Object)s);
        }
    }
}

