/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSelectorSuffixCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final CssSelectorSuffixType mySelectorSuffixType;
    @Nullable
    private final Condition<String> myFilter;

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType) {
        if (selectorSuffixType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffixType", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "<init>"));
        }
        this(selectorSuffixType, null);
    }

    public CssSelectorSuffixCompletionProvider(@NotNull CssSelectorSuffixType selectorSuffixType, @Nullable Condition<String> filter) {
        if (selectorSuffixType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffixType", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "<init>"));
        }
        this.mySelectorSuffixType = selectorSuffixType;
        this.myFilter = filter;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
        GlobalSearchScope scope;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        final Project project = position.getProject();
        final PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)parameters.getOriginalFile());
        if (parameters.getInvocationCount() < 2 || ApplicationManager.getApplication().isUnitTestMode()) {
            scope = CssSelectorSuffixCompletionProvider.getCompletionScope(position, parameters.getOriginalFile());
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            result.addLookupAdvertisement("Press " + shortcutText + " again for selectors from all stylesheets");
        } else {
            scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        }
        CssSelectorSuffix suffix = (CssSelectorSuffix)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssSelectorSuffix.class});
        final CssSelectorSuffix originalSuffix = suffix != null ? (CssSelectorSuffix)CompletionUtil.getOriginalOrSelf((PsiElement)suffix) : null;
        CssIndexUtil.processAllSelectorSuffixes(this.mySelectorSuffixType, project, scope, (Processor<? super CssSelectorSuffix>)new Processor<CssSelectorSuffix>(){

            public boolean process(CssSelectorSuffix selectorSuffix) {
                String name = selectorSuffix.getName();
                if (name != null && selectorSuffix != originalSuffix && (CssSelectorSuffixCompletionProvider.this.myFilter == null || CssSelectorSuffixCompletionProvider.this.myFilter.value((Object)name))) {
                    result.addElement(CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, file));
                }
                return true;
            }
        });
        GlobalSearchScope htmlScope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        CssIndexUtil.processSelectorNamesFromHtmlAttributes(htmlScope, new Processor<String>(){

            public boolean process(String selectorSuffix) {
                if (selectorSuffix.length() < 2 || CssSelectorSuffixCompletionProvider.this.myFilter != null && !CssSelectorSuffixCompletionProvider.this.myFilter.value((Object)selectorSuffix)) {
                    return true;
                }
                if (CssSelectorSuffixCompletionProvider.this.mySelectorSuffixType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'.') || CssSelectorSuffixCompletionProvider.this.mySelectorSuffixType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)selectorSuffix, (char)'#')) {
                    String suffixName = selectorSuffix.substring(1);
                    result.addElement(CssCompletionUtil.lookupForSelectorSuffixFromHtml(suffixName, CssSelectorSuffixCompletionProvider.this.mySelectorSuffixType, null, project));
                }
                return true;
            }
        });
    }

    @NotNull
    private static GlobalSearchScope getCompletionScope(@NotNull PsiElement position, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        Project project = position.getProject();
        if (file instanceof StylesheetFile && (virtualFile = file.getVirtualFile()) != null) {
            HashSet importedFiles = ContainerUtil.newHashSet((Object[])new VirtualFile[]{virtualFile});
            importedFiles.addAll(CssUtil.getImportedFiles(file, position, false));
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)importedFiles);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)file);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/provider/CssSelectorSuffixCompletionProvider", "getCompletionScope"));
        }
        return globalSearchScope;
    }
}

