/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssClassOrIdReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements CssReference {
    public CssClassOrIdReference(PsiElement element, @Nullable TextRange range) {
        super(element, range, true);
    }

    protected TextRange calculateDefaultRangeInElement() {
        TextRange range = super.calculateDefaultRangeInElement();
        boolean id = this.isId();
        if (range.isEmpty()) {
            return range;
        }
        if (id && this.hasExplicitIdMark() || !id && this.hasExplicitClassMark()) {
            range = new TextRange(range.getStartOffset() + 1, range.getEndOffset());
        }
        return range;
    }

    protected boolean hasExplicitIdMark() {
        return true;
    }

    protected boolean hasExplicitClassMark() {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        final CssSelectorSuffixType selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        final Project project = this.myElement.getProject();
        GlobalSearchScope scope = this.getSearchScope();
        final ArrayList result = ContainerUtil.newArrayList();
        CssIndexUtil.processAllSelectorNamesInScope(selectorType, project, scope, new Processor<String>(){

            public boolean process(String suffix) {
                result.add(LookupElementBuilder.create((String)suffix).withIcon(selectorType.getIcon()));
                return true;
            }
        });
        CssIndexUtil.processSelectorNamesFromHtmlAttributes(scope, new Processor<String>(){

            public boolean process(String suffix) {
                if (suffix.length() < 2) {
                    return true;
                }
                if (selectorType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)suffix, (char)'.') || selectorType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)suffix, (char)'#')) {
                    result.add(CssCompletionUtil.lookupForSelectorSuffixFromHtml(suffix.substring(1), selectorType, null, project));
                }
                return true;
            }
        });
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "getVariants"));
        }
        return objectArray;
    }

    protected GlobalSearchScope getSearchScope() {
        return CssUtil.getCompletionAndResolvingScopeForElement(this.myElement);
    }

    protected abstract boolean isId();

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)(this.isId() ? "invalid.css.id.reference" : "invalid.css.class.reference"), (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Project project = this.myElement.getProject();
        String text = this.getCanonicalText();
        CssSelectorSuffixType selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        final ArrayList result = ContainerUtil.newArrayList();
        CssIndexUtil.processSelectorSuffixes(selectorType, text, project, this.getSearchScope(), (Processor<? super CssSelectorSuffix>)new Processor<CssSelectorSuffix>(){

            public boolean process(CssSelectorSuffix selectorSuffix) {
                return result.add(new PsiElementResolveResult((PsiElement)selectorSuffix));
            }
        });
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "multiResolve"));
        }
        return resolveResultArray;
    }
}

