/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueType;
import com.intellij.psi.css.impl.CssTermTypeImpl;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssMediaFeatureDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPropertyDescriptorImplEx;
import com.intellij.psi.css.impl.descriptor.CssPseudoClassDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPseudoElementDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssSchemeConstants;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssDescriptorsLoader {
    private final CssDescriptorsHolder myDescriptors = new CssDescriptorsHolder();
    private static final Logger LOG = Logger.getInstance(CssDescriptorsLoader.class);
    private static final Function<String, String> PROCESS_VALUE_PRESENTABLE_NAME = new Function<String, String>(){

        public String fun(String presentableName) {
            return !Strings.isNullOrEmpty((String)presentableName) && !StringUtil.startsWithChar((CharSequence)presentableName, (char)'<') && presentableName.length() > 1 ? "<" + presentableName + ">" : presentableName;
        }
    };
    private static final Function<String, String> PROCESS_FUNCTION_PRESENTABLE_NAME = new Function<String, String>(){

        public String fun(String presentableName) {
            return presentableName + "()";
        }
    };
    private static final CssContextType[] ANY_AT_RULE_TYPES = new CssContextType[]{CssContextType.ANY};
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Pattern DOCUMENTATION_LINK_PATTERN = Pattern.compile("<see[\n\r ]+cref=\"([^:]*:([^\"]+))\"\\s*/>");

    CssDescriptorsLoader() {
    }

    public void loadDescriptors(@NotNull URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadDescriptors"));
        }
        try {
            Document document = JDOMUtil.loadDocument((URL)resource);
            for (Object child : document.getRootElement().getChildren()) {
                ProgressManager.checkCanceled();
                if (!(child instanceof Element)) continue;
                Element element = (Element)child;
                String tagName = element.getName();
                if ("property".equals(tagName)) {
                    this.loadPropertyDescriptor(element);
                    continue;
                }
                if ("prefixed-property".equals(tagName)) {
                    this.loadPrefixedPropertyDescriptor(element);
                    continue;
                }
                if ("pseudo-element".equals(tagName)) {
                    this.loadPseudoElementDescriptor(element);
                    continue;
                }
                if ("pseudo-class".equals(tagName)) {
                    this.loadPseudoClassDescriptor(element);
                    continue;
                }
                if ("function".equals(tagName)) {
                    this.loadFunctionDescriptor(element);
                    continue;
                }
                if ("prefixed-function".equals(tagName)) {
                    this.loadPrefixedFunctionDescriptor(element);
                    continue;
                }
                if ("named-value".equals(tagName)) {
                    this.loadNamedValueDescriptor(element);
                    continue;
                }
                if (!"media-feature".equals(tagName)) continue;
                this.loadMediaFeatureDescriptor(element);
            }
        }
        catch (JDOMException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e);
        }
    }

    @NotNull
    public CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder cssDescriptorsHolder = this.myDescriptors;
        if (cssDescriptorsHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "getDescriptors"));
        }
        return cssDescriptorsHolder;
    }

    private void loadPropertyDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadPropertyDescriptor"));
        }
        String name = element.getAttributeValue("id");
        CssMediaGroup[] mediaGroup = CssDescriptorsLoader.parseMediaGroups(element);
        String initialValue = element.getAttributeValue("initial");
        String appliesToValue = element.getAttributeValue("applies");
        String percentageValue = element.getAttributeValue("percentage");
        boolean inherited = CssDescriptorsLoader.parseBoolean(element, "inherited", false);
        this.myDescriptors.properties.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPropertyDescriptorImplEx(CssDescriptorsLoader.parseCommonDescriptorData(element), this.loadValueOfElement(element), initialValue, appliesToValue, percentageValue, inherited, mediaGroup));
    }

    private void loadPrefixedPropertyDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadPrefixedPropertyDescriptor"));
        }
        String name = element.getAttributeValue("id");
        Collection descriptors = this.myDescriptors.properties.get((Object)name);
        if (descriptors.isEmpty()) {
            LOG.error("Property should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssPropertyDescriptor originalProperty = (CssPropertyDescriptor)ContainerUtil.getFirstItem((Collection)descriptors);
        String prefix = element.getAttributeValue("prefix");
        String propertyName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalProperty != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalProperty.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalProperty.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(propertyName, "-" + prefix + "-" + originalProperty.getPresentableName(), originalProperty.getAllowedContextTypes(), browserVersions, cssVersion, url, originalProperty.getDescription());
        this.myDescriptors.properties.putValue((Object)propertyName.toLowerCase(Locale.US), (Object)new CssPropertyDescriptorImplEx(commonDescriptorData, originalProperty.getValueDescriptor(), originalProperty.getInitialValue(), originalProperty.getAppliesToValue(), originalProperty.getPercentageValue(), originalProperty.isInherited(), originalProperty.getMediaGroups()));
    }

    private void loadFunctionDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadFunctionDescriptor"));
        }
        String name = element.getAttributeValue("id");
        String returnTypeName = element.getAttributeValue("returnType");
        CssTermType returnType = StringUtil.isNotEmpty((String)returnTypeName) ? CssTermTypeImpl.find(returnTypeName) : CssTermType.UNKNOWN;
        this.myDescriptors.functions.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssFunctionDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.loadValueOfElement(element), returnType));
    }

    private void loadPrefixedFunctionDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadPrefixedFunctionDescriptor"));
        }
        String name = element.getAttributeValue("id");
        Collection descriptors = this.myDescriptors.functions.get((Object)name);
        if (descriptors.size() != 1) {
            LOG.error("Function should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssFunctionDescriptor originalFunction = (CssFunctionDescriptor)ContainerUtil.getFirstItem((Collection)descriptors);
        String prefix = element.getAttributeValue("prefix");
        String functionName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalFunction != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalFunction.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalFunction.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(functionName, "-" + prefix + "-" + originalFunction.getPresentableName(), originalFunction.getAllowedContextTypes(), browserVersions, cssVersion, url, originalFunction.getDescription());
        this.myDescriptors.functions.putValue((Object)functionName.toLowerCase(Locale.US), (Object)new CssFunctionDescriptorImpl(commonDescriptorData, originalFunction.getValueDescriptor(), originalFunction.getType()));
    }

    private void loadMediaFeatureDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadMediaFeatureDescriptor"));
        }
        String name = element.getAttributeValue("id").toLowerCase(Locale.US);
        CssValueDescriptor valueDescriptor = this.loadValueOfElement(element);
        CssCommonDescriptorData commonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element);
        CssMediaGroup[] mediaGroups = CssDescriptorsLoader.parseMediaGroups(element);
        String appliesToValue = element.getAttributeValue("applies");
        this.myDescriptors.mediaFeatures.putValue((Object)name, (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData, valueDescriptor));
        boolean acceptsMinMaxPrefixed = CssDescriptorsLoader.parseBoolean(element, "min-max", false);
        if (acceptsMinMaxPrefixed) {
            this.myDescriptors.mediaFeatures.putValue((Object)("min-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("min-"), valueDescriptor));
            this.myDescriptors.mediaFeatures.putValue((Object)("max-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("max-"), valueDescriptor));
        }
    }

    private void loadNamedValueDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadNamedValueDescriptor"));
        }
        String name = element.getAttributeValue("id");
        CssValueDescriptor valueDescriptor = CssValueDescriptorModificator.withCommonData(this.loadValueOfElement(element), CssDescriptorsLoader.parseCommonDescriptorData(element));
        this.myDescriptors.namedValues.putValue((Object)name.toLowerCase(Locale.US), (Object)valueDescriptor);
    }

    private void loadPseudoClassDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadPseudoClassDescriptor"));
        }
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        String name = element.getAttributeValue("id");
        this.myDescriptors.pseudoSelectors.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPseudoClassDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private void loadPseudoElementDescriptor(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadPseudoElementDescriptor"));
        }
        String name = element.getAttributeValue("id");
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        this.myDescriptors.pseudoSelectors.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPseudoElementDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private static boolean parseBoolean(@NotNull Element element, String attributeName, boolean defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseBoolean"));
        }
        return "yes".equals(element.getAttributeValue(attributeName)) || defaultValue;
    }

    private static int parseInt(@NotNull Element element, String attributeName, int defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInt"));
        }
        try {
            Attribute attribute = element.getAttribute(attributeName);
            return attribute != null ? attribute.getIntValue() : defaultValue;
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    @NotNull
    private static CssContextType[] parseContextTypes(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseContextTypes"));
        }
        String rules = element.getAttributeValue("rules");
        if (Strings.isNullOrEmpty((String)rules)) {
            if (ANY_AT_RULE_TYPES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseContextTypes"));
            }
            return ANY_AT_RULE_TYPES;
        }
        TreeSet result = Sets.newTreeSet((Comparator)CssContextType.COMPARATOR);
        for (String rule : COMMA_SPLITTER.split((CharSequence)rules)) {
            result.add(CssContextType.fromString((String)rule));
        }
        CssContextType[] cssContextTypeArray = result.toArray(new CssContextType[result.size()]);
        if (cssContextTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseContextTypes"));
        }
        return cssContextTypeArray;
    }

    @NotNull
    private static CssElementDescriptor.CssVersion parseVersion(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseVersion"));
        }
        CssElementDescriptor.CssVersion cssVersion = CssElementDescriptor.CssVersion.fromString((String)element.getAttributeValue("declared-in"));
        if (cssVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseVersion"));
        }
        return cssVersion;
    }

    @Nullable
    private static CssElementDescriptor.CssVersion parseObsoleteVersion(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseObsoleteVersion"));
        }
        String obsoleteInValue = element.getAttributeValue("obsolete-in");
        return obsoleteInValue != null ? CssElementDescriptor.CssVersion.fromString((String)obsoleteInValue) : null;
    }

    @Nullable
    private static String parseDescription(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseDescription"));
        }
        Element descriptionTag = element.getChild("description", CssSchemeConstants.NAMESPACE);
        if (descriptionTag != null) {
            return CssDescriptorsLoader.processDocumentation(descriptionTag.getTextTrim());
        }
        return CssDescriptorsLoader.processDocumentation(StringUtil.escapeXml((String)element.getAttributeValue("tooltip")));
    }

    @Nullable
    private static String processDocumentation(@Nullable String result) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        Matcher matcher = DOCUMENTATION_LINK_PATTERN.matcher(result);
        if (matcher.find()) {
            result = matcher.replaceAll("<a href=\"psi_element://$1\">$2</a>");
        }
        return result;
    }

    private static BrowserVersion[] parseBrowsers(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseBrowsers"));
        }
        String browsers = element.getAttributeValue("browsers");
        if (Strings.isNullOrEmpty((String)browsers)) {
            return BrowserVersion.EMPTY_ARRAY;
        }
        TreeSet result = ContainerUtilRt.newTreeSet((Comparator)BrowserVersion.COMPARATOR);
        for (String browser : COMMA_SPLITTER.split((CharSequence)browsers)) {
            result.add(BrowserVersion.fromString((String)browser));
        }
        return result.toArray(new BrowserVersion[result.size()]);
    }

    @NotNull
    private CssValueDescriptor loadValueOfElement(@NotNull Element valueOwnerElement) {
        if (valueOwnerElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueOwnerElement", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadValueOfElement"));
        }
        List children = valueOwnerElement.getChildren();
        for (Element child : children) {
            CssValueDescriptor valueDescriptor = this.parseValue(child, null);
            if (valueDescriptor == null) continue;
            CssValueDescriptor cssValueDescriptor = valueDescriptor;
            if (cssValueDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "loadValueOfElement"));
            }
            return cssValueDescriptor;
        }
        throw new IllegalArgumentException("Value cannot be empty");
    }

    @Nullable
    private CssValueDescriptor parseValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseValue"));
        }
        ProgressManager.checkCanceled();
        String name = valueElement.getName();
        if ("description".equalsIgnoreCase(name)) {
            return null;
        }
        CssValueType valueType = CssValueType.fromTag((String)name);
        if (valueType == null) {
            throw new IllegalArgumentException("Unknown value: " + valueElement.toString());
        }
        switch (valueType) {
            case GROUP: {
                return this.parseGroupValue(valueElement, parent);
            }
            case INLINE: {
                return this.parseInlineValue(valueElement, parent);
            }
            case URI: {
                return this.parseUriValue(valueElement, parent);
            }
            case STRING: {
                return this.parseStringValue(valueElement, parent);
            }
            case INTEGER: {
                return this.parseIntegerValue(valueElement, parent);
            }
            case PERCENTAGE: {
                return this.parsePercentageValue(valueElement, parent);
            }
            case NAME: {
                return this.parseNameValue(valueElement, parent);
            }
            case PROPERTY: {
                return this.parsePropertyReferenceValue(valueElement, parent);
            }
            case ANGLE: {
                return this.parseAngleValue(valueElement, parent);
            }
            case FREQUENCY: {
                return this.parseFrequencyValue(valueElement, parent);
            }
            case POSITION: {
                return this.parsePositionValue(valueElement, parent);
            }
            case RESOLUTION: {
                return this.parseResolutionValue(valueElement, parent);
            }
            case LENGTH: {
                return this.parseLengthValue(valueElement, parent);
            }
            case NUMBER: {
                return this.parseNumberValue(valueElement, parent);
            }
            case TIME: {
                return this.parseTimeValue(valueElement, parent);
            }
            case DECIBEL: {
                return this.parseDecibelValue(valueElement, parent);
            }
            case SEMITONES: {
                return this.parseSemitoneValue(valueElement, parent);
            }
            case URANGE: {
                return this.parseUrangeValue(valueElement, parent);
            }
            case INVOKE: {
                return this.parseFunctionValue(valueElement, parent);
            }
            case TEXT: {
                return this.parseTextValue(valueElement, parent);
            }
            case COLOR: {
                return this.parseColorValue(valueElement, parent);
            }
            case EXPRESSION: {
                return this.parseExpressionValue(valueElement, parent);
            }
            case JAVASCRIPT: {
                return this.parseJavaScriptValue(valueElement, parent);
            }
            case SELECTOR: {
                return this.parseSelectorValue(valueElement, parent);
            }
            case ANY: {
                return this.parseAnyValue(valueElement, parent);
            }
        }
        throw new IllegalArgumentException("Unknown value: " + valueElement.toString());
    }

    @NotNull
    private CssValueDescriptor parseFunctionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseFunctionValue"));
        }
        CssFunctionInvocationValue cssFunctionInvocationValue = new CssFunctionInvocationValue(element.getAttributeValue("name"), CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssFunctionInvocationValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseFunctionValue"));
        }
        return cssFunctionInvocationValue;
    }

    @NotNull
    private CssValueDescriptor parsePropertyReferenceValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePropertyReferenceValue"));
        }
        String refId = element.getAttributeValue("id");
        assert (StringUtil.isNotEmpty((String)refId));
        CssPropertyReferenceValue cssPropertyReferenceValue = new CssPropertyReferenceValue(refId, CssDescriptorsLoader.parseCommonDescriptorData(element, refId, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPropertyReferenceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePropertyReferenceValue"));
        }
        return cssPropertyReferenceValue;
    }

    @NotNull
    private CssValueDescriptor parseNameValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseNameValue"));
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        CssNameValue cssNameValue = new CssNameValue(value, false, CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"name.value.presentable.name", (Object[])new Object[0])), this.parseValueDescriptorData(element, parent));
        if (cssNameValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseNameValue"));
        }
        return cssNameValue;
    }

    @NotNull
    private CssValueDescriptor parseJavaScriptValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseJavaScriptValue"));
        }
        CssJavaScriptValue cssJavaScriptValue = new CssJavaScriptValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"java.script.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssJavaScriptValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseJavaScriptValue"));
        }
        return cssJavaScriptValue;
    }

    @NotNull
    private CssValueDescriptor parseAngleValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseAngleValue"));
        }
        CssAngleValue cssAngleValue = new CssAngleValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"angle.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssAngleValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseAngleValue"));
        }
        return cssAngleValue;
    }

    @NotNull
    private CssValueDescriptor parseFrequencyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseFrequencyValue"));
        }
        CssFrequencyValue cssFrequencyValue = new CssFrequencyValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"frequency.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssFrequencyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseFrequencyValue"));
        }
        return cssFrequencyValue;
    }

    @NotNull
    private CssValueDescriptor parsePositionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePositionValue"));
        }
        CssPositionValue cssPositionValue = new CssPositionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"position.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPositionValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePositionValue"));
        }
        return cssPositionValue;
    }

    @NotNull
    private CssValueDescriptor parseResolutionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseResolutionValue"));
        }
        CssResolutionValue cssResolutionValue = new CssResolutionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"resolution.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssResolutionValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseResolutionValue"));
        }
        return cssResolutionValue;
    }

    @NotNull
    private CssValueDescriptor parseLengthValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseLengthValue"));
        }
        CssLengthValue cssLengthValue = new CssLengthValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"length.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssLengthValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseLengthValue"));
        }
        return cssLengthValue;
    }

    @NotNull
    private CssValueDescriptor parseNumberValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseNumberValue"));
        }
        CssNumberValue cssNumberValue = new CssNumberValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"number.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssNumberValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseNumberValue"));
        }
        return cssNumberValue;
    }

    @NotNull
    private CssValueDescriptor parseTimeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseTimeValue"));
        }
        CssTimeValue cssTimeValue = new CssTimeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"time.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssTimeValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseTimeValue"));
        }
        return cssTimeValue;
    }

    @NotNull
    private CssValueDescriptor parseDecibelValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseDecibelValue"));
        }
        CssDecibelValue cssDecibelValue = new CssDecibelValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"decibel.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssDecibelValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseDecibelValue"));
        }
        return cssDecibelValue;
    }

    @NotNull
    private CssValueDescriptor parseSemitoneValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseSemitoneValue"));
        }
        CssSemitonesValue cssSemitonesValue = new CssSemitonesValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"semitones.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssSemitonesValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseSemitoneValue"));
        }
        return cssSemitonesValue;
    }

    @NotNull
    private CssValueDescriptor parseUrangeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseUrangeValue"));
        }
        CssUrangeValue cssUrangeValue = new CssUrangeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"urange.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssUrangeValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseUrangeValue"));
        }
        return cssUrangeValue;
    }

    @NotNull
    private CssValueDescriptor parsePercentageValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePercentageValue"));
        }
        CssPercentageValue cssPercentageValue = new CssPercentageValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"percentage.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPercentageValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parsePercentageValue"));
        }
        return cssPercentageValue;
    }

    @NotNull
    private CssValueDescriptor parseColorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseColorValue"));
        }
        CssColorValue cssColorValue = new CssColorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"color.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssColorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseColorValue"));
        }
        return cssColorValue;
    }

    @NotNull
    private CssValueDescriptor parseAnyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseAnyValue"));
        }
        CssAnyValueImpl cssAnyValueImpl = new CssAnyValueImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"any.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssAnyValueImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseAnyValue"));
        }
        return cssAnyValueImpl;
    }

    @NotNull
    private CssValueDescriptor parseIntegerValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseIntegerValue"));
        }
        CssIntegerValue cssIntegerValue = new CssIntegerValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"integer.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssIntegerValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseIntegerValue"));
        }
        return cssIntegerValue;
    }

    @NotNull
    private CssValueDescriptor parseStringValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseStringValue"));
        }
        CssStringValue cssStringValue = new CssStringValue(element.getAttributeValue("value"), CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"string.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssStringValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseStringValue"));
        }
        return cssStringValue;
    }

    @NotNull
    private CssValueDescriptor parseTextValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseTextValue"));
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        CssTextValue cssTextValue = new CssTextValue(value, CssDescriptorsLoader.parseCommonDescriptorData(element), this.parseValueDescriptorData(element, parent));
        if (cssTextValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseTextValue"));
        }
        return cssTextValue;
    }

    @NotNull
    private CssValueDescriptor parseExpressionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseExpressionValue"));
        }
        CssExpressionValue cssExpressionValue = new CssExpressionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"expression.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssExpressionValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseExpressionValue"));
        }
        return cssExpressionValue;
    }

    @NotNull
    private CssValueDescriptor parseSelectorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseSelectorValue"));
        }
        CssSelectorValue cssSelectorValue = new CssSelectorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"selector.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssSelectorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseSelectorValue"));
        }
        return cssSelectorValue;
    }

    @NotNull
    private CssValueDescriptor parseUriValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseUriValue"));
        }
        CssUrlValue cssUrlValue = new CssUrlValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"url.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssUrlValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseUriValue"));
        }
        return cssUrlValue;
    }

    @NotNull
    private CssValueDescriptor parseInlineValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInlineValue"));
        }
        boolean inline = CssDescriptorsLoader.parseBoolean(element, "inline", false);
        String name = element.getAttributeValue("id");
        if ("id".equalsIgnoreCase(name)) {
            CssIdValue cssIdValue = new CssIdValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"id.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
            if (cssIdValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInlineValue"));
            }
            return cssIdValue;
        }
        CssInlineValue inlineValue = new CssInlineValue(name, CssDescriptorsLoader.parseCommonDescriptorData(element, name, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (inline) {
            CssValueDescriptor namedValue;
            Collection namedValues = this.myDescriptors.namedValues.get((Object)name);
            if (namedValues.size() == 1 && (namedValue = (CssValueDescriptor)ContainerUtil.getFirstItem((Collection)namedValues)) != null) {
                CssValueDescriptor result = CssValueDescriptorModificator.withParent(namedValue, parent);
                if (inlineValue.isCommaSeparated() || inlineValue.getMinOccur() != 1 || inlineValue.getMaxOccur() != 1) {
                    CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.withQuantifiers(result, inlineValue.getMinOccur(), inlineValue.getMaxOccur(), inlineValue.isCommaSeparated());
                    if (cssValueDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInlineValue"));
                    }
                    return cssValueDescriptor;
                }
                CssValueDescriptor cssValueDescriptor = result;
                if (cssValueDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInlineValue"));
                }
                return cssValueDescriptor;
            }
            LOG.error("Named value should be declared before inlining.", new String[]{name});
        }
        CssInlineValue cssInlineValue = inlineValue;
        if (cssInlineValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseInlineValue"));
        }
        return cssInlineValue;
    }

    @NotNull
    private CssValueDescriptor parseGroupValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseGroupValue"));
        }
        CssGroupValue cssGroupValue = CssGroupValue.create(CssDescriptorsLoader.parseCommonDescriptorData(valueElement, "", PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(valueElement, parent), CssDescriptorsLoader.parseBoolean(valueElement, "ignoreWhitespaces", true), this.parseSeparator(valueElement), CssDescriptorsLoader.parseGroupType(valueElement));
        for (Element child : valueElement.getChildren()) {
            CssValueDescriptor descriptor;
            if ("separator".equals(child.getName()) || (descriptor = this.parseValue(child, cssGroupValue)) == null) continue;
            cssGroupValue.addChild(descriptor);
        }
        CssGroupValue cssGroupValue2 = cssGroupValue;
        if (cssGroupValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseGroupValue"));
        }
        return cssGroupValue2;
    }

    @Nullable
    private CssValueDescriptor parseSeparator(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseSeparator"));
        }
        Element separatorTag = element.getChild("separator", CssSchemeConstants.NAMESPACE);
        return separatorTag != null ? this.loadValueOfElement(separatorTag) : null;
    }

    @Nullable
    private CssValueDescriptor parseExclusion(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseExclusion"));
        }
        Element exclusionTag = element.getChild("exclusion", CssSchemeConstants.NAMESPACE);
        return exclusionTag != null ? this.loadValueOfElement(exclusionTag) : null;
    }

    @NotNull
    private static CssGroupValue.Type parseGroupType(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseGroupType"));
        }
        String typeAttributeValue = element.getAttributeValue("type");
        CssGroupValue.Type type = Strings.isNullOrEmpty((String)typeAttributeValue) ? CssGroupValue.Type.ALL : CssGroupValue.Type.valueOf(typeAttributeValue.toUpperCase(Locale.US));
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseGroupType"));
        }
        return type;
    }

    @NotNull
    private CssValueDescriptorData parseValueDescriptorData(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseValueDescriptorData"));
        }
        boolean commaSeparated = CssDescriptorsLoader.parseBoolean(element, "comma-separated", false);
        int minOccur = CssDescriptorsLoader.parseInt(element, "min", 1);
        int maxOccur = CssDescriptorsLoader.parseInt(element, "max", commaSeparated ? -1 : 1);
        if (maxOccur != -1 && maxOccur < minOccur) {
            maxOccur = minOccur;
        }
        CssValueDescriptorData cssValueDescriptorData = new CssValueDescriptorData(CssDescriptorsLoader.parseBoolean(element, "completion", true), minOccur, maxOccur, CssDescriptorsLoader.parseObsoleteVersion(element), CssDescriptorsLoader.processDocumentation(StringUtil.escapeXml((String)element.getAttributeValue("obsolete-tooltip"))), parent, this.parseExclusion(element), commaSeparated);
        if (cssValueDescriptorData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseValueDescriptorData"));
        }
        return cssValueDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        CssCommonDescriptorData cssCommonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element, "", (Function<String, String>)Functions.id());
        if (cssCommonDescriptorData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        if (defaultPresentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPresentableName", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        CssCommonDescriptorData cssCommonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element, defaultPresentableName, (Function<String, String>)Functions.id());
        if (cssCommonDescriptorData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName, @NotNull Function<String, String> processPresentableName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        if (defaultPresentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPresentableName", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        if (processPresentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentableName", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        String id = element.getAttributeValue("id", defaultPresentableName);
        String valueAttribute = element.getAttributeValue("value", id);
        String presentableName = (String)processPresentableName.fun((Object)element.getAttributeValue("name", valueAttribute));
        CssCommonDescriptorData cssCommonDescriptorData = new CssCommonDescriptorData(id, presentableName, CssDescriptorsLoader.parseContextTypes(element), CssDescriptorsLoader.parseBrowsers(element), CssDescriptorsLoader.parseVersion(element), element.getAttributeValue("url"), Strings.nullToEmpty((String)CssDescriptorsLoader.parseDescription(element)));
        if (cssCommonDescriptorData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseCommonDescriptorData"));
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssMediaGroup[] parseMediaGroups(Element element) {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (String s : StringUtil.split((String)element.getAttributeValue("media", "all").toUpperCase(Locale.US), (String)" ")) {
            try {
                result.add(CssMediaGroup.valueOf((String)s.trim()));
            }
            catch (IllegalArgumentException e) {
                Collections.addAll(result, CssMediaType.valueOf((String)s.trim()).getSupportedGroups());
            }
        }
        CssMediaGroup[] cssMediaGroupArray = !result.isEmpty() ? result.toArray(new CssMediaGroup[result.size()]) : CssElementDescriptorConstants.EMPTY_MEDIA_GROUP;
        if (cssMediaGroupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader", "parseMediaGroups"));
        }
        return cssMediaGroupArray;
    }
}

