/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueBase;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssTableLoaderValue
extends CssTableValueBase<CssTableLoaderValue, String> {
    @NonNls
    private static final Map<String, String> ourValueTypes = new THashMap();
    @NonNls
    private static final List<String> ourDoNotCompleteValues;
    private CssTableLoaderValue myParent;
    static final Set<String> ourUnknownTypes;

    public CssTableLoaderValue(@NotNull CssTableValue.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "<init>"));
        }
        super(type);
    }

    public CssTableLoaderValue(@Nullable String value) {
        super(value);
    }

    @Nullable
    public CssTableLoaderValue getParent() {
        return this.myParent;
    }

    public void setParent(@Nullable CssTableLoaderValue parent) {
        this.myParent = parent;
    }

    @Override
    public CssTableLoaderValue addChild(@NotNull CssTableLoaderValue child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "addChild"));
        }
        child.setParent(this);
        return super.addChild(child);
    }

    @Override
    public void removeChild(@NotNull CssTableLoaderValue child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "removeChild"));
        }
        super.removeChild(child);
        child.setParent(null);
    }

    @Override
    protected void removeAllChildren() {
        for (CssTableLoaderValue child : this.getChildren()) {
            child.setParent(null);
        }
        super.removeAllChildren();
    }

    public void write(@NotNull String propertyName, @NotNull XmlStringWriter writer) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "write"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "write"));
        }
        this.write(propertyName, writer, new Function<String, String>(){

            public String fun(String v) {
                return CssTableLoaderValue.getMapKey(v);
            }
        }, new Function<String, String>(){

            public String fun(String key) {
                return (String)ourValueTypes.get(key);
            }
        });
    }

    public void write(@NotNull String propertyName, @NotNull XmlStringWriter writer, Function<String, String> map, Function<String, String> vmap) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "write"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue", "write"));
        }
        switch (this.getType()) {
            case ANY: {
                writer.addAttribute("type", CssTableValue.Type.ANY.toString().toLowerCase(Locale.US));
                break;
            }
            case FULL_ANY: {
                writer.addAttribute("type", CssTableValue.Type.FULL_ANY.toString().toLowerCase(Locale.US));
                break;
            }
            case OR: {
                writer.addAttribute("type", CssTableValue.Type.OR.toString().toLowerCase(Locale.US));
                break;
            }
        }
        if (-1 != this.getMinCount()) {
            writer.addAttribute("min", this.getMinCount());
            writer.addAttribute("max", this.getMaxCount());
        }
        if (this.getPrefix() != null) {
            writer.addAttribute("prefix", this.getPrefix());
        }
        if (this.isGroup()) {
            final boolean[] notComplete = new boolean[]{false};
            this.accept((CssTableValueVisitor)new CssTableValueVisitor<CssTableLoaderValue>(){

                public void visit(@NotNull CssTableLoaderValue value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssTableLoaderValue$3", "visit"));
                    }
                    for (CssTableLoaderValue each : value.getChildren()) {
                        String s = (String)each.getValue();
                        if (s == null || !s.equals("identifier#helpref=syndata.html#value-def-identifier")) continue;
                        notComplete[0] = true;
                    }
                }
            });
            if (notComplete[0]) {
                writer.addAttribute("donotcomplete", "true");
            }
            writer.printlnOpeningTag("group");
            for (CssTableLoaderValue each : this.getChildren()) {
                each.write(propertyName, writer, map, vmap);
            }
            writer.printlnClosingTag();
        } else {
            String functionName;
            String functionName2;
            int funcNdx;
            String v = (String)this.getValue();
            assert (v != null);
            if (ourDoNotCompleteValues.contains(v)) {
                writer.addAttribute("donotcomplete", "true");
            }
            if ((funcNdx = v.indexOf("#func")) >= 0 && (functionName2 = CssTableLoaderValue.getMapKey(v)) != null) {
                writer.addAttribute("vtype", "function");
                writer.addAttribute("function-name", functionName2);
                writer.printlnShortTag("value");
                return;
            }
            int optfuncNdx = v.indexOf("#optfunc");
            if (optfuncNdx >= 0 && (functionName = CssTableLoaderValue.getMapKey(v)) != null) {
                writer.addAttribute("vtype", "optional-function");
                writer.addAttribute("function-name", functionName);
                writer.printlnShortTag("value");
                return;
            }
            int proprefNdx = v.indexOf("#propref");
            boolean forceTypeRef = v.contains("#typeref");
            String key = (String)map.fun((Object)v);
            String valueType = (String)vmap.fun((Object)key);
            if (forceTypeRef && valueType == null) {
                valueType = "identifier";
                ourUnknownTypes.add(key);
            }
            if (valueType != null) {
                writer.addAttribute("vtype", valueType);
                if (-1 != proprefNdx && !propertyName.equals(v.substring(0, proprefNdx))) {
                    writer.addAttribute("refname", v.substring(0, proprefNdx));
                }
                writer.printlnShortTag("value");
            } else {
                int helprefNdx = v.indexOf("#helpref=");
                if (-1 != helprefNdx) {
                    writer.addAttribute("helpRef", v.substring(helprefNdx + "helpref=".length() + 1));
                    writer.printlnFullTag("value", v.substring(0, helprefNdx));
                } else if (-1 != proprefNdx) {
                    writer.addAttribute("vtype", "ref");
                    writer.addAttribute("refname", v.substring(0, proprefNdx));
                    writer.printlnShortTag("value");
                } else {
                    writer.printlnFullTag("value", v);
                }
            }
        }
    }

    @Nullable
    private static String getMapKey(String v) {
        int sharpIndex = v.indexOf(35);
        int parenIndex = v.indexOf(40);
        String key = null;
        if (sharpIndex != -1) {
            int min = parenIndex < sharpIndex && parenIndex != -1 ? parenIndex : sharpIndex;
            key = v.substring(0, min);
        } else if (parenIndex != -1) {
            key = v.substring(0, parenIndex);
        }
        return key;
    }

    static {
        ourValueTypes.put("angle", "angle");
        ourValueTypes.put("resolution", "resolution");
        ourValueTypes.put("percentage", "percentage");
        ourValueTypes.put("length", "length");
        ourValueTypes.put("shape", "shape");
        ourValueTypes.put("uri", "uri");
        ourValueTypes.put("counter", "counter");
        ourValueTypes.put("attr", "attr");
        ourValueTypes.put("string", "string");
        ourValueTypes.put("border-style", "border-style");
        ourValueTypes.put("border-width", "border-width");
        ourValueTypes.put("color", "color");
        ourValueTypes.put("identifier", "identifier");
        ourValueTypes.put("integer", "integer");
        ourValueTypes.put("number", "integer");
        ourValueTypes.put("time", "time");
        ourValueTypes.put("generic-family", "generic-font-family");
        ourValueTypes.put("family-name", "font-family");
        ourValueTypes.put("absolute-size", "absolute-size");
        ourValueTypes.put("relative-size", "relative-size");
        ourValueTypes.put("frequency", "frequency");
        ourValueTypes.put("margin-width", "margin-width");
        ourValueTypes.put("padding-width", "padding-width");
        ourValueTypes.put("non-negative-integer", "integer");
        ourValueTypes.put("image", "image");
        ourValueTypes.put(", family-name#helpref=fonts.html#value-def-family-name", "font-family");
        ourDoNotCompleteValues = new ArrayList<String>();
        ourDoNotCompleteValues.add("string#helpref=syndata.html#value-def-string");
        ourDoNotCompleteValues.add("number#helpref=syndata.html#value-def-number");
        ourUnknownTypes = new HashSet();
    }
}

