/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.style;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.CssInsertMissingSemicolonQuickFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssMissingSemicolonInspection
extends CssBaseInspection {
    private static final LocalQuickFix localFix = new CssInsertMissingSemicolonQuickFix();

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.missing.semicolon.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                super.visitCssDeclaration(declaration);
                CssOneLineStatement oneLineStatement = CssUtil.findOneLineStatement((PsiElement)declaration);
                if (CssUtil.isSemicolonMissing(oneLineStatement)) {
                    holder.registerProblem((PsiElement)oneLineStatement, CssBundle.message((String)"css.inspections.missing.semicolon.name", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{localFix});
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

