/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5Action;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceAppletTagAction;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceFontTagAction;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlDeprecatedTagInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourHtmlReplacableTags = new HashSet();
    @NonNls
    private static final Set<String> ourCssReplacableTags;
    @NonNls
    private static final Set<String> ourDeprecatedTags;
    @NonNls
    private static final Set<String> ourHtml5DeprecatedTags;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.deprecated.tag", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlDeprecatedTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "getShortName"));
        }
        return "HtmlDeprecatedTag";
    }

    static void registerTag(@NotNull XmlTag tag, @NotNull String message, @NotNull ProblemsHolder holder, LocalQuickFix[] fixes, @NotNull ProblemHighlightType type) {
        XmlToken endTagNameElement;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "registerTag"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "registerTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "registerTag"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "registerTag"));
        }
        if (fixes == null) {
            return;
        }
        XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        String description = XmlBundle.message((String)message, (Object[])new Object[0]);
        if (description != null) {
            description = description + " #loc";
        }
        if (startTagNameElement != null) {
            holder.registerProblem((PsiElement)startTagNameElement, description, type, fixes);
        }
        if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null) {
            holder.registerProblem((PsiElement)endTagNameElement, description, type, fixes);
        }
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlDeprecatedTagInspection", "checkTag"));
        }
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            LocalQuickFix[] fixes;
            String name = tag.getName().toLowerCase();
            boolean deprecated = ourDeprecatedTags.contains(name);
            boolean deprecatedInHtml5 = ourHtml5DeprecatedTags.contains(name);
            if (!deprecated && !deprecatedInHtml5) {
                return;
            }
            boolean inHtml5 = HtmlUtil.isHtml5Context((XmlElement)tag);
            if (!(inHtml5 && deprecatedInHtml5 || !inHtml5 && deprecated)) {
                return;
            }
            if (tag.getDescriptor() == null) {
                return;
            }
            if ("font".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceFontTagAction()};
            } else if ("applet".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceAppletTagAction()};
            } else if (ourCssReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplacableTags.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else {
                fixes = ourHtmlReplacableTags.contains(name) ? new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)} : new LocalQuickFix[]{};
            }
            if (!inHtml5 && deprecated && !deprecatedInHtml5 && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag)) {
                LocalQuickFix[] newFixes = new LocalQuickFix[fixes.length + 1];
                System.arraycopy(fixes, 0, newFixes, 0, fixes.length);
                newFixes[fixes.length] = new SwitchToHtml5Action();
                fixes = newFixes;
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.deprecated.tag", holder, fixes, ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    static {
        ourHtmlReplacableTags.addAll(Arrays.asList("s", "strike", "u", "menu"));
        ourCssReplacableTags = new HashSet();
        ourCssReplacableTags.addAll(Arrays.asList("center", "u", "s", "strike", "xmp"));
        ourDeprecatedTags = new HashSet();
        ourDeprecatedTags.addAll(Arrays.asList("applet", "basefont", "center", "dir", "font", "frame", "frameset", "isindex", "menu", "noframes", "s", "strike", "u", "xmp"));
        ourHtml5DeprecatedTags = new HashSet();
        ourHtml5DeprecatedTags.addAll(Arrays.asList("acronym", "applet", "basefont", "big", "center", "dir", "font", "frame", "frameset", "isindex", "noframes", "strike", "tt", "u"));
    }
}

