/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HtmlLabelsHolder {
    private static final Key<CachedValue<HtmlLabelsHolder>> htmlLabelsHolderKey = Key.create((String)"html labels holder");
    private final Set<String> myForValuesOfLabels = new HashSet();
    private static final UserDataCache<CachedValue<HtmlLabelsHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<HtmlLabelsHolder>, XmlFile, Object>(){

        protected CachedValue<HtmlLabelsHolder> compute(final XmlFile file, Object p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<HtmlLabelsHolder>(){

                public CachedValueProvider.Result<HtmlLabelsHolder> compute() {
                    HtmlLabelsHolder holder = new HtmlLabelsHolder();
                    Language language = file.getViewProvider().getBaseLanguage();
                    PsiFile psiFile = file.getViewProvider().getPsi(language);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new LabelGatheringRecursiveVisitor(holder));
                        return new CachedValueProvider.Result((Object)holder, new Object[]{file});
                    }
                    return null;
                }
            }, false);
        }
    };

    public static HtmlLabelsHolder getInstance(XmlFile file) {
        return (HtmlLabelsHolder)((CachedValue)CACHE.get(htmlLabelsHolderKey, (UserDataHolder)file, null)).getValue();
    }

    private void registerForValue(@NotNull String forValue) {
        if (forValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forValue", "com/intellij/codeInspection/htmlInspections/HtmlLabelsHolder", "registerForValue"));
        }
        this.myForValuesOfLabels.add(forValue);
    }

    public boolean hasForValue(@NotNull String forValue) {
        if (forValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forValue", "com/intellij/codeInspection/htmlInspections/HtmlLabelsHolder", "hasForValue"));
        }
        return this.myForValuesOfLabels.contains(forValue);
    }

    private static class LabelGatheringRecursiveVisitor
    extends XmlRecursiveElementVisitor {
        private final HtmlLabelsHolder myHolder;

        private LabelGatheringRecursiveVisitor(HtmlLabelsHolder holder) {
            super(true);
            this.myHolder = holder;
        }

        public void visitXmlTag(XmlTag tag) {
            super.visitXmlTag(tag);
            if ("label".equals(tag.getName().toLowerCase())) {
                for (XmlAttribute attribute : tag.getAttributes()) {
                    String id;
                    if (!"for".equals(attribute.getLocalName().toLowerCase()) || (id = attribute.getValue()) == null) continue;
                    this.myHolder.registerForValue(id);
                }
            }
        }
    }
}

