/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlBundle;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceHtmlTagWithAnotherAction
implements LocalQuickFix {
    @NonNls
    private static final Map<String, String> ourTagToNewTagMap = new HashMap();
    @NonNls
    private final String myName;

    public ReplaceHtmlTagWithAnotherAction(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.another.quickfix.text", (Object[])new Object[]{this.myName, ourTagToNewTagMap.get(this.myName)});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        if ("ReplaceDepracatedTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction", "getFamilyName"));
        }
        return "ReplaceDepracatedTag";
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, String tagName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction", "generateContainingElements"));
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, ourTagToNewTagMap.get(tagName));
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction", "applyFix"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parent.getContainingFile())) {
            return;
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && this.myName.equals(((XmlTag)parent).getLocalName().toLowerCase())); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        String name = ((XmlTag)parent).getLocalName().toLowerCase();
        XmlTag tag = (XmlTag)parent;
        PsiElement[] replacePsiElements = ReplaceHtmlTagWithAnotherAction.generateContainingElements(project, name);
        int cnt = 0;
        for (PsiElement element : tag.getChildren()) {
            XmlToken token;
            IElementType type;
            if (!(element instanceof XmlToken) || (type = (token = (XmlToken)element).getTokenType()) != XmlTokenType.XML_NAME) continue;
            token.replace(replacePsiElements[cnt++]);
        }
    }

    static {
        ourTagToNewTagMap.put("i", "em");
        ourTagToNewTagMap.put("b", "strong");
        ourTagToNewTagMap.put("s", "del");
        ourTagToNewTagMap.put("strike", "del");
        ourTagToNewTagMap.put("tt", "samp");
        ourTagToNewTagMap.put("u", "cite");
        ourTagToNewTagMap.put("xmp", "pre");
        ourTagToNewTagMap.put("menu", "ul");
    }
}

