/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LessElement;

public class LessImportType
extends CompositePsiElement
implements LessElement {
    public static final String LESS_IMPORT_TYPE = "less";
    public static final String CSS_IMPORT_TYPE = "css";
    public static final String OPTIONAL_IMPORT_TYPE = "optional";
    public static final Set<String> KNOWN_IMPORT_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"less", "css", "inline", "reference", "multiple", "once", "optional"});

    protected LessImportType() {
        super(LESSElementTypes.LESS_IMPORT_TYPE);
    }

    @NotNull
    public ASTNode[] getImportTypeNodes() {
        ASTNode[] aSTNodeArray = this.getChildren(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT}));
        if (aSTNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LessImportType", "getImportTypeNodes"));
        }
        return aSTNodeArray;
    }

    @NotNull
    public Set<String> getImportTypes() {
        Set set = ContainerUtil.map2Set((Object[])this.getImportTypeNodes(), (Function)new Function<ASTNode, String>(){

            public String fun(ASTNode node) {
                return node.getText().trim();
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LessImportType", "getImportTypes"));
        }
        return set;
    }
}

