/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianJUnitConfigurationPanel;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianJUnitRunConfigurationType;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class ArquillianJUnitRunConfiguration
extends JUnitConfiguration
implements ArquillianTestFrameworkRunConfiguration {
    public ArquillianRunConfiguration arquillianRunConfiguration;

    public ArquillianJUnitRunConfiguration(String name, Project project, String containerStateName, ConfigurationFactory configurationFactory) {
        super(name, project, configurationFactory);
        this.setNameChangedByUser(false);
        this.arquillianRunConfiguration = new ArquillianRunConfiguration(containerStateName);
    }

    private ArquillianJUnitRunConfiguration(String name, Project project, JUnitConfiguration.Data data, ConfigurationFactory configurationFactory, ArquillianRunConfiguration arquillianRunConfiguration) {
        super(name, project, data, configurationFactory);
        this.arquillianRunConfiguration = arquillianRunConfiguration;
    }

    public String suggestedName() {
        String containerName = this.arquillianRunConfiguration.getContainerStateName();
        String suggestedName = super.suggestedName();
        return Strings.isNullOrEmpty((String)containerName) ? suggestedName : containerName + ": " + suggestedName;
    }

    protected ModuleBasedConfiguration createInstance() {
        return new ArquillianJUnitRunConfiguration(this.getName(), this.getProject(), this.getPersistentData().clone(), ArquillianJUnitRunConfigurationType.getInstance().getConfigurationFactories()[0], this.getArquillianRunConfiguration());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String containerStateName = this.arquillianRunConfiguration.getContainerStateName();
        if (Strings.isNullOrEmpty((String)containerStateName)) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.specified", (Object[])new Object[0]));
        }
        if (ArquillianContainersManager.getInstance((Project)this.getProject()).findStateByName(containerStateName) == null) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.found", (Object[])new Object[]{containerStateName}));
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ArquillianBundle.message((String)"arquillian.run.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ArquillianJUnitConfigurationPanel(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor("Logs", (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianJUnitRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public ArquillianRunConfiguration getArquillianRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    public ArquillianRunConfiguration getRunConfiguration() {
        return this.arquillianRunConfiguration;
    }
}

