/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.ReadOnlyBlockInformationProvider;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import org.coffeescript.CoffeeScriptDocStringUtil;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.CoffeeScriptLiterateLanguage;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.formatter.CoffeeScriptCodeStyleSettings;
import org.coffeescript.formatter.blocks.CoffeeScriptPropertyAlignmentFactory;
import org.coffeescript.formatter.blocks.CoffeeScriptSpacingProcessor;
import org.coffeescript.lang.lexer.CoffeeScriptTokenSets;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptBlock
extends JSBlock
implements ReadOnlyBlockInformationProvider {
    protected Alignment childAlignment;
    private CommonCodeStyleSettings myCommonCodeStyleSettings;

    public CoffeeScriptBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "<init>"));
        }
        super(node, alignment, indent, wrap, settings, alignmentFactory, (Language)CoffeeScriptLanguage.INSTANCE);
        this.childAlignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        this.myCommonCodeStyleSettings = settings.getCommonSettings((Language)CoffeeScriptLanguage.INSTANCE);
    }

    private CoffeeScriptCodeStyleSettings getCoffeeScriptCodeStyleSettings() {
        return (CoffeeScriptCodeStyleSettings)this.mySettings.getCustomSettings(CoffeeScriptCodeStyleSettings.class);
    }

    @Nullable
    private ASTNode getNodeBefore(int newChildIndex) {
        if (newChildIndex == 0) {
            return null;
        }
        int prevIndex = newChildIndex - 1;
        JSBlock insertAfterBlock = (JSBlock)this.getSubBlocksAsIs().get(prevIndex);
        return insertAfterBlock.getNode();
    }

    @NotNull
    private static ASTNode findLastLeaf(@NotNull ASTNode container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "findLastLeaf"));
        }
        ASTNode result = container;
        while (result.getLastChildNode() != null) {
            result = result.getLastChildNode();
        }
        ASTNode aSTNode = result;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "findLastLeaf"));
        }
        return aSTNode;
    }

    private static ASTNode findElementToHandleEnter(@NotNull ASTNode container, @NotNull ASTNode afterNode) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "findElementToHandleEnter"));
        }
        if (afterNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterNode", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "findElementToHandleEnter"));
        }
        ASTNode result = CoffeeScriptBlock.findLastLeaf(afterNode);
        if (afterNode.getElementType() == CoffeeScriptElementTypes.CALL_EXPRESSION) {
            afterNode = afterNode.getLastChildNode();
        }
        if (afterNode.getLastChildNode() == result && result.getElementType() == CoffeeScriptTokenTypes.PARENTHESIS_END) {
            result = afterNode.getTreeParent();
        }
        while (!CoffeeScriptBlock.containerAcceptEnter(result) && result != container) {
            result = result.getTreeParent();
        }
        return result;
    }

    private static boolean containerAcceptEnter(@NotNull ASTNode node) {
        IElementType lastChildType;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "containerAcceptEnter"));
        }
        IElementType type = node.getElementType();
        IElementType firstChildType = node.getFirstChildNode() != null ? node.getFirstChildNode().getElementType() : null;
        IElementType iElementType = lastChildType = node.getLastChildNode() != null ? node.getLastChildNode().getElementType() : null;
        if (node instanceof LeafPsiElement) {
            return false;
        }
        if (type == CoffeeScriptElementTypes.ARGUMENT_LIST) {
            return lastChildType == CoffeeScriptTokenTypes.COMMA || firstChildType == CoffeeScriptTokenTypes.PARENTHESIS_START;
        }
        if (type == CoffeeScriptElementTypes.OBJECT) {
            return lastChildType != CoffeeScriptTokenTypes.BRACE_END;
        }
        if (type == CoffeeScriptElementTypes.FOR_STATEMENT) {
            return node.getFirstChildNode().getElementType() == CoffeeScriptTokenTypes.FOR;
        }
        if (type == CoffeeScriptElementTypes.WHILE_STATEMENT) {
            return firstChildType == CoffeeScriptTokenTypes.WHILE || firstChildType == CoffeeScriptTokenTypes.UNTIL;
        }
        if (type == CoffeeScriptElementTypes.IF_STATEMENT) {
            return firstChildType == CoffeeScriptTokenTypes.IF || firstChildType == CoffeeScriptTokenTypes.UNLESS;
        }
        IElementType[] acceptedTypes = new IElementType[]{CoffeeScriptElementTypes.INDENT_BLOCK, CoffeeScriptElementTypes.SWITCH_STATEMENT, CoffeeScriptTokenTypes.EQ, CoffeeScriptElementTypes.TRY_STATEMENT, CoffeeScriptElementTypes.ASSIGN_EXPRESSION, CoffeeScriptElementTypes.VARIABLE, CoffeeScriptElementTypes.PROPERTY, CoffeeScriptElementTypes.CLASS, CoffeeScriptElementTypes.FUNCTION_EXPRESSION, CoffeeScriptElementTypes.CATCH_BLOCK, CoffeeScriptElementTypes.CASE_CLAUSE};
        return Arrays.asList(acceptedTypes).contains(type);
    }

    private static boolean shouldDelegateToChild(@NotNull ASTNode node, @NotNull ASTNode afterNode) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "shouldDelegateToChild"));
        }
        if (afterNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterNode", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "shouldDelegateToChild"));
        }
        ASTNode elementToHandleEnter = CoffeeScriptBlock.findElementToHandleEnter(node, afterNode);
        return elementToHandleEnter != node;
    }

    private ChildAttributes getChildAttributes(@NotNull ASTNode node, @Nullable ASTNode afterNode) {
        Indent indent;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "getChildAttributes"));
        }
        IElementType nodeType = node.getElementType();
        IElementType afterNodeType = afterNode != null ? afterNode.getElementType() : null;
        Alignment alignment = null;
        if (nodeType == CoffeeScriptElementTypes.IF_STATEMENT) {
            boolean directIf;
            ASTNode firstChild = node.getFirstChildNode();
            if (firstChild != null && firstChild instanceof PsiErrorElement) {
                firstChild = firstChild.getTreeNext();
            }
            boolean bl = directIf = firstChild != null && (firstChild.getElementType() == CoffeeScriptTokenTypes.IF || firstChild.getElementType() == CoffeeScriptTokenTypes.UNLESS);
            indent = directIf ? (afterNode != null && afterNode.getElementType() != CoffeeScriptTokenTypes.THEN ? Indent.getNormalIndent() : Indent.getNoneIndent()) : Indent.getNoneIndent();
        } else if (nodeType == CoffeeScriptElementTypes.OBJECT) {
            ASTNode firstChild = node.getFirstChildNode();
            indent = firstChild != null && firstChild.getElementType() == CoffeeScriptTokenTypes.BRACE_START ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else if (nodeType == JSElementTypes.ARGUMENT_LIST) {
            indent = afterNode != null && (afterNode.getElementType() == JSTokenTypes.LPAR || afterNode.getElementType() == JSTokenTypes.COMMA) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else if (nodeType == CoffeeScriptElementTypes.VARIABLE || nodeType == CoffeeScriptElementTypes.ASSIGN_EXPRESSION) {
            indent = afterNode != null && CoffeeScriptTokenTypes.ASSIGNMENT_OPERATIONS.contains(afterNode.getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else if (nodeType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION) {
            indent = afterNode != null && afterNode.getElementType() != CoffeeScriptTokenTypes.BRACKET_END ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else if (nodeType == CoffeeScriptElementTypes.FUNCTION_EXPRESSION) {
            indent = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)this.getCoffeeScriptCodeStyleSettings().ALIGN_FUNCTION_BODY, (boolean)false);
        } else {
            TokenSet containersThatShouldIndent = TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptElementTypes.INDENT_BLOCK, CoffeeScriptElementTypes.WHILE_STATEMENT, CoffeeScriptElementTypes.FOR_STATEMENT, JSElementTypes.SWITCH_STATEMENT, CoffeeScriptElementTypes.CATCH_BLOCK, CoffeeScriptElementTypes.CLASS, CoffeeScriptElementTypes.TRY_STATEMENT, CoffeeScriptTokenTypes.ELSE, CoffeeScriptTokenTypes.CATCH, CoffeeScriptTokenTypes.EQ, CoffeeScriptElementTypes.CASE_CLAUSE, CoffeeScriptElementTypes.PARENTHESIZED_EXPRESSION, JSStubElementTypes.PARAMETER_LIST});
            Indent indent2 = indent = containersThatShouldIndent.contains(nodeType) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (afterNodeType == CoffeeScriptTokenTypes.HEREDOC_START || afterNodeType == CoffeeScriptTokenTypes.HEREDOC) {
            indent = Indent.getIndent((Indent.Type)Indent.Type.NONE, (boolean)true, (boolean)true);
            alignment = this.childAlignment;
        }
        return new ChildAttributes(indent, alignment);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode afterNode;
        ASTNode aSTNode = afterNode = newChildIndex > 0 ? this.getNodeBefore(newChildIndex) : null;
        if (afterNode != null && CoffeeScriptBlock.shouldDelegateToChild(this.myNode, afterNode)) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = this.getChildAttributes(this.myNode, afterNode);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    protected MyJSSubBlockVisitor createSubBlockVisitor() {
        return new MyJSSubBlockVisitor(this, this.getSettings(), (Language)CoffeeScriptLanguage.INSTANCE, this.mySharedAlignmentFactory);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/coffeescript/formatter/blocks/CoffeeScriptBlock", "getSpacing"));
        }
        if (!(child1 instanceof JSBlock) || !(child2 instanceof JSBlock)) {
            return null;
        }
        return new CoffeeScriptSpacingProcessor(this.getNode(), ((JSBlock)child1).getNode(), ((JSBlock)child2).getNode(), this.mySettings, (Language)CoffeeScriptLanguage.INSTANCE).calcSpacing();
    }

    public boolean isReadOnly(Block block) {
        ASTNode node;
        return block instanceof CoffeeScriptBlock && CoffeeScriptDocStringUtil.isDocString(node = ((CoffeeScriptBlock)block).getNode());
    }

    protected ASTNodeBasedAlignmentFactory getSharedAlignmentFactory(@Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            return new CoffeeScriptPropertyAlignmentFactory(this.getCoffeeScriptCodeStyleSettings(), this.getAlignment());
        }
        return super.getSharedAlignmentFactory(sharedAlignmentFactory);
    }

    private static boolean isHeredocElement(IElementType childType) {
        return childType == CoffeeScriptTokenTypes.HEREDOC || childType == CoffeeScriptTokenTypes.HEREDOC_START || childType == CoffeeScriptTokenTypes.HEREDOC_END;
    }

    class MyJSSubBlockVisitor
    extends SubBlockVisitor {
        JSBlock myBlock;

        public MyJSSubBlockVisitor(@NotNull JSBlock block, @NotNull CodeStyleSettings settings, Language dialect, ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/coffeescript/formatter/blocks/CoffeeScriptBlock$MyJSSubBlockVisitor", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "org/coffeescript/formatter/blocks/CoffeeScriptBlock$MyJSSubBlockVisitor", "<init>"));
            }
            super(block, settings, dialect, sharedAlignmentFactory);
            this.myBlock = block;
        }

        private boolean isPrecededByNewLine(ASTNode node) {
            ASTNode prev = node.getTreePrev();
            if (prev != null) {
                return prev.getText().contains("\n");
            }
            return false;
        }

        protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
            ASTNode prevNode;
            Indent result = super.getIndent(node, child, sharedSmartIndent);
            IElementType nodeElementType = node.getElementType();
            IElementType childElementType = child.getElementType();
            if (CoffeeScriptBlock.isHeredocElement(childElementType)) {
                return Indent.getIndent((Indent.Type)Indent.Type.NONE, (boolean)true, (boolean)true);
            }
            if (childElementType == JSTokenTypes.COMMA) {
                if (nodeElementType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION) {
                    return Indent.getNoneIndent();
                }
            } else {
                if (childElementType == JSElementTypes.ARGUMENT_LIST) {
                    ASTNode reference;
                    for (reference = child.getTreePrev(); reference != null && reference.getElementType() == JSTokenTypes.WHITE_SPACE; reference = reference.getTreePrev()) {
                    }
                    if (reference != null) {
                        ASTNode referenceChild;
                        for (referenceChild = reference.getLastChildNode(); !(referenceChild == null || referenceChild.getElementType() == JSTokenTypes.WHITE_SPACE && referenceChild.getText().contains("\n")); referenceChild = referenceChild.getTreePrev()) {
                        }
                        if (referenceChild != null && referenceChild.getTreeNext().getElementType() == JSTokenTypes.DOT) {
                            return Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)false);
                        }
                    }
                    return Indent.getNoneIndent();
                }
                if (childElementType == CoffeeScriptElementTypes.OBJECT) {
                    if (nodeElementType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION && child.getFirstChildNode().getElementType() == CoffeeScriptTokenTypes.BRACE_START) {
                        return Indent.getNormalIndent();
                    }
                    if (CoffeeScriptUtil.isObjectWithBrace(child)) {
                        return result;
                    }
                    return Indent.getNoneIndent();
                }
                if (childElementType == CoffeeScriptElementTypes.RETURN_STATEMENT) {
                    if (TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptElementTypes.IF_STATEMENT, CoffeeScriptElementTypes.WHILE_STATEMENT}).contains(nodeElementType)) {
                        return Indent.getNoneIndent();
                    }
                } else {
                    if (childElementType == CoffeeScriptElementTypes.PROPERTY) {
                        ASTNode parent = CoffeeScriptBlock.this.myNode.getTreeParent();
                        IElementType parentType = parent.getElementType();
                        if (parentType == CoffeeScriptElementTypes.ASSIGN_EXPRESSION || parentType == CoffeeScriptElementTypes.VARIABLE || parentType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION || parentType == CoffeeScriptElementTypes.PROPERTY || parentType == CoffeeScriptElementTypes.PARENTHESIZED_EXPRESSION || parentType == CoffeeScriptElementTypes.ARGUMENT_LIST) {
                            return Indent.getNormalIndent();
                        }
                        if (CoffeeScriptBlock.this.myNode.getFirstChildNode().getElementType() == CoffeeScriptTokenTypes.BRACE_START) {
                            return Indent.getNormalIndent();
                        }
                        return Indent.getNoneIndent();
                    }
                    if (childElementType == CoffeeScriptTokenTypes.LINE_COMMENT || childElementType == CoffeeScriptTokenTypes.BLOCK_COMMENT) {
                        PsiElement childPsi = child.getPsi();
                        if (childPsi != null && childPsi.getContainingFile().getLanguage() == CoffeeScriptLiterateLanguage.INSTANCE) {
                            String fileText = childPsi.getContainingFile().getText();
                            int offset = child.getStartOffset();
                            if (offset == 0 || fileText.charAt(offset - 1) == '\n') {
                                return Indent.getAbsoluteNoneIndent();
                            }
                        }
                        if (nodeElementType == CoffeeScriptElementTypes.CLASS) {
                            return Indent.getNormalIndent();
                        }
                    }
                }
            }
            if (nodeElementType == CoffeeScriptElementTypes.PARENTHESIZED_EXPRESSION || nodeElementType == CoffeeScriptElementTypes.ARGUMENT_LIST && (childElementType == CoffeeScriptElementTypes.FUNCTION_EXPRESSION || childElementType == CoffeeScriptTokenTypes.COMMA)) {
                ASTNode prevChild = child.getTreePrev();
                result = childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.COMMA || prevChild != null && !prevChild.getText().contains("\n") ? Indent.getNoneIndent() : Indent.getNormalIndent();
            } else if (nodeElementType == JSStubElementTypes.PARAMETER_LIST) {
                result = childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.COMMA ? Indent.getNoneIndent() : Indent.getNormalIndent();
            } else {
                if (nodeElementType == CoffeeScriptElementTypes.VAR_STATEMENT) {
                    return Indent.getNoneIndent();
                }
                if (nodeElementType == CoffeeScriptElementTypes.FUNCTION_EXPRESSION) {
                    if (childElementType == CoffeeScriptElementTypes.EXPRESSION_STATEMENT) {
                        return Indent.getNormalIndent();
                    }
                    if (childElementType == CoffeeScriptElementTypes.INDENT_BLOCK) {
                        return Indent.getIndent((Indent.Type)Indent.Type.NONE, (boolean)((CoffeeScriptBlock)CoffeeScriptBlock.this).getCoffeeScriptCodeStyleSettings().ALIGN_FUNCTION_BODY, (!((CoffeeScriptBlock)CoffeeScriptBlock.this).getCoffeeScriptCodeStyleSettings().ALIGN_FUNCTION_BODY ? 1 : 0) != 0);
                    }
                } else if (nodeElementType == CoffeeScriptElementTypes.BINARY_EXPRESSION && node.getFirstChildNode() != child) {
                    return Indent.getContinuationIndent();
                }
            }
            if (nodeElementType == CoffeeScriptElementTypes.INDENT_BLOCK) {
                return Indent.getNormalIndent();
            }
            TokenSet containerElements = TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptElementTypes.FOR_STATEMENT, CoffeeScriptElementTypes.WHILE_STATEMENT, CoffeeScriptElementTypes.IF_STATEMENT, CoffeeScriptElementTypes.FUNCTION_EXPRESSION});
            if (childElementType == CoffeeScriptTokenTypes.LINE_COMMENT && (prevNode = child.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.getText().contains("\n") && ((CoffeeScriptBlock)CoffeeScriptBlock.this).myCommonCodeStyleSettings.KEEP_FIRST_COLUMN_COMMENT) {
                return Indent.getAbsoluteNoneIndent();
            }
            if (CoffeeScriptTokenSets.COMMENTS_TOKEN_SET.contains(child.getElementType()) && containerElements.contains(nodeElementType)) {
                return Indent.getNormalIndent();
            }
            if (child.getElementType() == CoffeeScriptTokenTypes.SEMICOLON) {
                return Indent.getNoneIndent();
            }
            if (result == Indent.getNormalIndent() && (nodeElementType == CoffeeScriptElementTypes.CLASS || nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || nodeElementType == JSElementTypes.IF_STATEMENT && !node.getText().contains("\n"))) {
                result = Indent.getNoneIndent();
            }
            if (result == null || result == Indent.getNoneIndent()) {
                if (nodeElementType == CoffeeScriptElementTypes.VARIABLE || nodeElementType == CoffeeScriptElementTypes.ASSIGN_EXPRESSION) {
                    if (node.getLastChildNode() == child && this.isPrecededByNewLine(child)) {
                        result = Indent.getNormalIndent();
                    }
                } else if (nodeElementType == CoffeeScriptElementTypes.PROPERTY && child.getElementType() == CoffeeScriptElementTypes.OBJECT) {
                    result = Indent.getNormalIndent();
                }
            }
            if (result == null && childElementType != CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION) {
                result = Indent.getNoneIndent();
            }
            return result;
        }

        protected Wrap getWrap(ASTNode node, ASTNode child) {
            Object result = super.getWrap(node, child);
            IElementType nodeType = node.getElementType();
            IElementType childType = child.getElementType();
            if (nodeType == CoffeeScriptElementTypes.PROPERTY) {
                if (child.getText().trim().contains("\n") && childType == CoffeeScriptElementTypes.OBJECT && !child.getText().startsWith("{")) {
                    result = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
                }
            } else if (nodeType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION) {
                ASTNode prev = child.getTreePrev();
                if (prev != null && prev.getElementType() == CoffeeScriptTokenTypes.BRACKET_START) {
                    result = ((CoffeeScriptBlock)CoffeeScriptBlock.this).mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE ? Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true) : null;
                } else if (childType == CoffeeScriptTokenTypes.BRACKET_END) {
                    result = ((CoffeeScriptBlock)CoffeeScriptBlock.this).mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE ? Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true) : null;
                }
            } else if (nodeType == CoffeeScriptElementTypes.ARGUMENT_LIST) {
                ASTNode second;
                ASTNode firstChildOfArgumentList = node.getFirstChildNode();
                if (firstChildOfArgumentList == null || firstChildOfArgumentList.getElementType() != CoffeeScriptTokenTypes.PARENTHESIS_START) {
                    result = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                } else if (firstChildOfArgumentList.getElementType() == CoffeeScriptTokenTypes.PARENTHESIS_START && ((second = firstChildOfArgumentList.getTreeNext()) == null || second.getElementType() == CoffeeScriptTokenTypes.PARENTHESIS_END)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
            } else if (nodeType == JSStubElementTypes.PARAMETER_LIST) {
                if (childType == JSTokenTypes.RPAR) {
                    return Wrap.createWrap((WrapType)(((CoffeeScriptBlock)CoffeeScriptBlock.this).mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE ? WrapType.ALWAYS : WrapType.NONE), (boolean)true);
                }
                if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && WrappingUtil.shouldWrap((int)((CoffeeScriptBlock)CoffeeScriptBlock.this).myCommonCodeStyleSettings.METHOD_PARAMETERS_WRAP)) {
                    return Wrap.createWrap((WrapType)(((CoffeeScriptBlock)CoffeeScriptBlock.this).myCommonCodeStyleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE ? WrapType.ALWAYS : WrapType.NONE), (boolean)true);
                }
            }
            return result;
        }

        protected JSLocalAlignmentFactory createLocalAlignmentFactory(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/coffeescript/formatter/blocks/CoffeeScriptBlock$MyJSSubBlockVisitor", "createLocalAlignmentFactory"));
            }
            return new MyCoffeeScriptAlignmentFactory(settings);
        }

        private class MyCoffeeScriptAlignmentFactory
        extends JSLocalAlignmentFactory {
            private Alignment myParAlignment;

            public MyCoffeeScriptAlignmentFactory(CodeStyleSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/coffeescript/formatter/blocks/CoffeeScriptBlock$MyJSSubBlockVisitor$MyCoffeeScriptAlignmentFactory", "<init>"));
                }
                super(settings, (Language)CoffeeScriptLanguage.INSTANCE);
                this.myParAlignment = Alignment.createAlignment();
            }

            @Nullable
            protected Alignment getAlignment(@Nullable IElementType parentType, @Nullable IElementType childType) {
                if (CoffeeScriptBlock.isHeredocElement(childType)) {
                    if (MyJSSubBlockVisitor.this.myBlock instanceof CoffeeScriptBlock) {
                        return ((CoffeeScriptBlock)MyJSSubBlockVisitor.this.myBlock).childAlignment;
                    }
                } else {
                    if (childType == CoffeeScriptElementTypes.FUNCTION_EXPRESSION && !((CoffeeScriptBlock)CoffeeScriptBlock.this).getCoffeeScriptCodeStyleSettings().ALIGN_FUNCTION_BODY) {
                        return null;
                    }
                    if (childType == CoffeeScriptElementTypes.OBJECT) {
                        if (parentType == CoffeeScriptElementTypes.ARRAY_LITERAL_EXPRESSION) {
                            return null;
                        }
                    } else if (parentType == CoffeeScriptElementTypes.ARGUMENT_LIST && ((CoffeeScriptBlock)CoffeeScriptBlock.this).myCommonCodeStyleSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS && childType == CoffeeScriptElementTypes.VAR_STATEMENT) {
                        return this.getLocalAlignment();
                    }
                }
                return super.getAlignment(parentType, childType);
            }

            public Alignment getAlignment(@NotNull ASTNode child) {
                ASTNode firstArgument;
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/coffeescript/formatter/blocks/CoffeeScriptBlock$MyJSSubBlockVisitor$MyCoffeeScriptAlignmentFactory", "getAlignment"));
                }
                ASTNode parent = child.getTreeParent();
                if (parent != null && parent.getElementType() == CoffeeScriptElementTypes.ARGUMENT_LIST && ((CoffeeScriptBlock)CoffeeScriptBlock.this).myCommonCodeStyleSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS && ((firstArgument = parent.getFirstChildNode()) == null || parent.getLastChildNode() != firstArgument || firstArgument.getElementType() != CoffeeScriptElementTypes.FUNCTION_EXPRESSION)) {
                    if (child.getElementType() == JSTokenTypes.LPAR || child.getElementType() == JSTokenTypes.RPAR) {
                        return this.myParAlignment;
                    }
                    return this.getLocalAlignment();
                }
                if (CoffeeScriptBlock.this.mySharedAlignmentFactory != null) {
                    return CoffeeScriptBlock.this.mySharedAlignmentFactory.getAlignment(child);
                }
                return super.getAlignment(child);
            }
        }
    }
}

