/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.types.JSCaseClauseElementType;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.lang.javascript.types.JSCompositeBlockStatementElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.lang.lexer.CoffeeScriptElementType;
import org.coffeescript.lang.psi.impl.CoffeeScriptBlockStatementImpl;
import org.coffeescript.lang.types.CoffeeScriptParameterElementType;
import org.coffeescript.lang.types.CoffeeScriptPropertyElementType;
import org.coffeescript.lang.types.CoffeeScriptVariableElementType;
import org.jetbrains.annotations.NotNull;

public interface CoffeeScriptElementTypes {
    public static final IElementType INDENT_BLOCK = new JSCompositeBlockStatementElementType("BLOCK_STATEMENT"){

        public JSElement construct(ASTNode node) {
            return new CoffeeScriptBlockStatementImpl(node);
        }
    };
    public static final IElementType EXPRESSION_STATEMENT = JSElementTypes.EXPRESSION_STATEMENT;
    public static final IElementType CALL_EXPRESSION = JSElementTypes.CALL_EXPRESSION;
    public static final IElementType ARGUMENT_LIST = JSElementTypes.ARGUMENT_LIST;
    public static final IElementType ASSIGN_EXPRESSION = JSElementTypes.ASSIGNMENT_EXPRESSION;
    public static final IElementType DEFINITION_EXPRESSION = JSElementTypes.DEFINITION_EXPRESSION;
    public static final IElementType TRY_STATEMENT = JSElementTypes.TRY_STATEMENT;
    public static final IElementType CATCH_BLOCK = JSElementTypes.CATCH_BLOCK;
    public static final IElementType SWITCH_STATEMENT = JSElementTypes.SWITCH_STATEMENT;
    public static final IElementType IF_STATEMENT = JSElementTypes.IF_STATEMENT;
    public static final IElementType THROW_STATEMENT = JSElementTypes.THROW_STATEMENT;
    public static final IElementType RETURN_STATEMENT = JSElementTypes.RETURN_STATEMENT;
    public static final IElementType OBJECT = JSElementTypes.OBJECT_LITERAL_EXPRESSION;
    public static final IElementType NEW_EXPRESSION = JSElementTypes.NEW_EXPRESSION;
    public static final IElementType REFERENCED_EXPRESSION = JSElementTypes.REFERENCE_EXPRESSION;
    public static final IElementType LITERAL_EXPRESSION = JSElementTypes.LITERAL_EXPRESSION;
    public static final IElementType VAR_STATEMENT = JSStubElementTypes.VAR_STATEMENT;
    public static final JSStubElementType<JSParameterStub, JSParameter> PARAMETER = new CoffeeScriptParameterElementType();
    public static final JSStubElementType<JSVariableStub<JSVariable>, JSVariable> VARIABLE = new CoffeeScriptVariableElementType();
    public static final IElementType PARENTHESIZED_EXPRESSION = JSElementTypes.PARENTHESIZED_EXPRESSION;
    public static final IElementType FUNCTION_EXPRESSION = JSStubElementTypes.FUNCTION_EXPRESSION;
    public static final IElementType ARRAY_LITERAL_EXPRESSION = JSElementTypes.ARRAY_LITERAL_EXPRESSION;
    public static final IElementType INDEXED_PROPERTY_ACCESS_EXPRESSION = JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION;
    public static final IElementType WHILE_STATEMENT = JSElementTypes.WHILE_STATEMENT;
    public static final IElementType BINARY_EXPRESSION = JSElementTypes.BINARY_EXPRESSION;
    public static final IElementType POSTFIX_EXPRESSION = JSElementTypes.POSTFIX_EXPRESSION;
    public static final IElementType PREFIX_EXPRESSION = JSElementTypes.PREFIX_EXPRESSION;
    public static final IElementType THIS_PROPERTY = JSElementTypes.THIS_EXPRESSION;
    public static final JSStubElementType<JSClassStub<JSClass>, JSClass> CLASS = new JSClassElementType(){

        @NotNull
        public Language getLanguage() {
            CoffeeScriptLanguage coffeeScriptLanguage = CoffeeScriptLanguage.INSTANCE;
            if (coffeeScriptLanguage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptElementTypes$2", "getLanguage"));
            }
            return coffeeScriptLanguage;
        }

        @NotNull
        public String getExternalId() {
            String string = this.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptElementTypes$2", "getExternalId"));
            }
            return string;
        }

        public String toString() {
            return "CS:CLASS";
        }
    };
    public static final IElementType CASE_CLAUSE = new JSCaseClauseElementType(){

        @NotNull
        public Language getLanguage() {
            CoffeeScriptLanguage coffeeScriptLanguage = CoffeeScriptLanguage.INSTANCE;
            if (coffeeScriptLanguage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/CoffeeScriptElementTypes$3", "getLanguage"));
            }
            return coffeeScriptLanguage;
        }

        public String toString() {
            return "Case clause";
        }
    };
    public static final CoffeeScriptPropertyElementType PROPERTY = new CoffeeScriptPropertyElementType();
    public static final IElementType EXTENDS_LIST = JSStubElementTypes.DEFAULT_EXTENDS_LIST;
    public static final IElementType FOR_STATEMENT = new CoffeeScriptElementType("For statement");
    public static final IElementType RANGE = new CoffeeScriptElementType("Range");
    public static final IElementType HEREGEX = new CoffeeScriptElementType("Heregex expression");
    public static final IElementType DO_EXPRESSION = new CoffeeScriptElementType("Do expression");
    public static final TokenSet EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PROPERTY, FOR_STATEMENT, HEREGEX, DO_EXPRESSION}), JSElementTypes.EXPRESSIONS});
    public static final TokenSet STATEMENTS = TokenSet.create((IElementType[])new IElementType[]{IF_STATEMENT, WHILE_STATEMENT, FOR_STATEMENT, SWITCH_STATEMENT, TRY_STATEMENT, VAR_STATEMENT, INDENT_BLOCK, CLASS});
}

