/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.model.annotations.mapping.AttributeReferenceSet;
import com.intellij.jpa.model.annotations.mapping.JamAttributeConverter;
import com.intellij.jpa.model.annotations.mapping.JpaAttributeReference;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.util.QueryParameterResolveHelper;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CriteriaApiReferenceProvider
extends PsiReferenceProvider {
    private final ResolveHelper myHelper = new ResolveHelper();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/hibernate/CriteriaApiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/hibernate/CriteriaApiReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new CriteriaAttributeReferenceSet(element, this.myHelper).getPsiReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/CriteriaApiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/hibernate/CriteriaApiReferenceProvider", "acceptsTarget"));
        }
        return JamCommonUtil.getModelObject((PsiElement)target) instanceof PersistentAttribute;
    }

    public class CriteriaAttributeReference
    extends JpaAttributeReference {
        public CriteriaAttributeReference(CriteriaAttributeReferenceSet set, int index, TextRange range) {
            super((AttributeReferenceSet)set, index, range);
        }

        public PsiElement resolve() {
            PersistentAttribute attribute = this.resolveAttribute();
            if (this.getReferenceSet().getClassList().isEmpty()) {
                return this.getElement();
            }
            return attribute == null ? null : attribute.getIdentifyingPsiElement();
        }

        public CriteriaAttributeReferenceSet getReferenceSet() {
            return (CriteriaAttributeReferenceSet)super.getReferenceSet();
        }

        protected PersistenceModelBrowser createBrowser() {
            ArrayList<PsiClass> classList = this.getReferenceSet().getClassList();
            if (classList.isEmpty()) {
                return super.createBrowser();
            }
            return PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)((PsiElement)classList.get(0)));
        }

        protected void processEmptyContext(PersistenceModelBrowser browser, JpaAttributeReference.AttrProcessor processor, boolean resolve) {
            ArrayList<PsiClass> classList = this.getReferenceSet().getClassList();
            if (classList.isEmpty()) {
                return;
            }
            CriteriaAttributeReference.processClassAttributes((PsiClass)classList.get(0), (PersistenceModelBrowser)browser, (JpaAttributeReference.AttrProcessor)processor);
        }

        protected boolean areAttributeNamesEqual(String attrName, String refName) {
            return super.areAttributeNamesEqual(attrName, refName) || super.areAttributeNamesEqual(attrName, this.getReferenceSet().getAliasMap().get(refName));
        }

        protected void addCustomVariants(List<LookupElement> result) {
            if (this.getIndex() == 0) {
                for (String s : this.getReferenceSet().getAliasMap().keySet()) {
                    result.add((LookupElement)LookupElementBuilder.create((String)s).bold());
                }
            }
        }
    }

    private class CriteriaAttributeReferenceSet
    extends AttributeReferenceSet {
        private ArrayList<PsiClass> myClassList;
        private ResolveHelper myHelper;
        private Map<String, String> myAliasMap;

        public CriteriaAttributeReferenceSet(PsiElement element, ResolveHelper helper) {
            super(new JamAttributeConverter(){

                protected boolean traverseCollection() {
                    return true;
                }
            }, element);
            this.myHelper = helper;
        }

        public ArrayList<PsiClass> getClassList() {
            if (this.myClassList == null) {
                this.myClassList = new ArrayList(0);
                this.myAliasMap = new THashMap(0);
                this.myHelper.processPossibleQueryElementsByParameter(CompletionUtil.getOriginalOrSelf((PsiElement)this.getElement()), this.myClassList, this.myAliasMap);
            }
            return this.myClassList;
        }

        @NotNull
        protected JpaAttributeReference createReference(TextRange range, int index) {
            CriteriaAttributeReference criteriaAttributeReference = new CriteriaAttributeReference(this, index, range);
            if (criteriaAttributeReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/CriteriaApiReferenceProvider$CriteriaAttributeReferenceSet", "createReference"));
            }
            return criteriaAttributeReference;
        }

        @NotNull
        public Map<String, String> getAliasMap() {
            if (this.myAliasMap == null) {
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/CriteriaApiReferenceProvider$CriteriaAttributeReferenceSet", "getAliasMap"));
                }
                return map;
            }
            Map<String, String> map = this.myAliasMap;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/CriteriaApiReferenceProvider$CriteriaAttributeReferenceSet", "getAliasMap"));
            }
            return map;
        }
    }

    public static class ResolveHelper
    extends QueryParameterResolveHelper<PsiClass, Map<String, String>> {
        protected boolean addParamMapsByQueryElement(@NotNull PsiElement expression, List<PsiClass> result, Map<String, String> map) {
            PsiMethodCallExpression methodCall;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/hibernate/CriteriaApiReferenceProvider$ResolveHelper", "addParamMapsByQueryElement"));
            }
            if (expression instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression classExpression = (PsiClassObjectAccessExpression)expression;
                PsiType type = classExpression.getOperand().getType();
                PsiClass psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                ContainerUtil.addIfNotNull((Object)psiClass, result);
                return true;
            }
            if (expression instanceof PsiLiteralExpression && (methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class)) != null && "createCriteria".equals(methodCall.getMethodExpression().getReferenceName())) {
                CriteriaAttributeReference reference = (CriteriaAttributeReference)JpaUtil.findReferenceOfType((PsiReference[])expression.getReferences(), CriteriaAttributeReference.class);
                PersistentAttribute attribute = reference == null ? null : reference.resolveAttribute();
                PsiType attrType = attribute == null ? null : attribute.getPsiType();
                JavaTypeInfo typeInfo = attribute == null ? null : PersistenceCommonUtil.getTypeInfo((PsiType)attrType);
                PsiType type = typeInfo == null ? null : typeInfo.getValueType();
                PsiClass psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                ContainerUtil.addIfNotNull((Object)psiClass, result);
                return true;
            }
            return false;
        }

        public boolean processPossibleQueryElementsByParameter(PsiElement paramElement, List<PsiClass> result, Map<String, String> context) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)paramElement, PsiMethodCallExpression.class);
            PsiElement prevElement = paramElement;
            PsiMethodCallExpression curElement = methodCall;
            while (curElement != null) {
                if (this.processPossibleQueryElement((PsiElement)curElement, result, ResolveHelper.initialVisitedElements((PsiElement)prevElement), context)) {
                    return true;
                }
                prevElement = curElement;
                if (methodCall.getParent() instanceof PsiExpressionList) {
                    prevElement = methodCall;
                    curElement = methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethodCallExpression.class);
                    continue;
                }
                curElement = null;
            }
            return false;
        }

        protected boolean skipChainedMethodCall(PsiMethodCallExpression expression, Map<String, String> context) {
            PsiExpression[] args;
            String methodName = expression.getMethodExpression().getReferenceName();
            if ("createCriteria".equals(methodName)) {
                return false;
            }
            if ("createAlias".equals(methodName) && (args = expression.getArgumentList().getExpressions()).length == 2) {
                Object attr = JamCommonUtil.computeMemberValue((PsiElement)args[0]);
                Object alias = JamCommonUtil.computeMemberValue((PsiElement)args[1]);
                if (attr instanceof String && alias instanceof String) {
                    context.put((String)alias, (String)attr);
                }
            }
            return true;
        }

        protected void visitOurVariable(PsiVariable variable, List<PsiClass> result, final Map<String, String> aliasMap) {
            ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(new PsiElement[]{variable.getContainingFile()}, null, true)).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    PsiElement parent = element.getParent();
                    if (parent != null && parent.getParent() instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)parent.getParent()).getMethodExpression() == parent) {
                        PsiElement cur = parent.getParent();
                        while (cur instanceof PsiMethodCallExpression || cur instanceof PsiReferenceExpression) {
                            if (cur instanceof PsiMethodCallExpression) {
                                this.skipChainedMethodCall((PsiMethodCallExpression)cur, aliasMap);
                            }
                            cur = cur.getParent();
                        }
                    }
                    return true;
                }
            });
        }
    }
}

